/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.canvas.TheCanvas;
import com.canvas.view.item.FormView;
import com.canvas.view.item.ImageItem;
import com.canvas.view.item.ImageListView;
import com.canvas.view.item.TextView;
import com.canvas.view.item.TitleView;
import com.canvas.view.until.ViewManager;
import com.http.Connection;
import com.image.ImageHolder;
import com.image.ImageLoaderManager;
import com.model.EpgMenu;
import com.model.Node;
import com.model.Resource;
import com.model.SystemInfo;
import com.res.Res;
import com.scene.MainMenuScene;
import com.scene.Welcome;
import com.thread.ThreadManager;
import com.tools.Tools;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class WonHot
extends MIDlet {
    public static WonHot midlet;
    public static Display display;
    public static TheCanvas canvas;
    public static Displayable currentDisp;
    public static final byte TASKMODE_VIEWINIT = 1;
    public static final byte TASKMODE_TOMAINVMENU = 2;
    public static Welcome welcome;
    public static MainMenuScene mainMenu;

    public WonHot() {
        midlet = this;
        display = Display.getDisplay((MIDlet)this);
        String mobile = midlet.getAppProperty("mobile");
        String host = midlet.getAppProperty("host");
        System.out.println("mobile:" + mobile);
        System.out.println("host:" + host);
        if (mobile != null) {
            Connection.mobileCode = mobile;
        }
        if (host != null) {
            Resource.WBSC_MOBILE_HOST = host;
        }
        this.initApp();
        canvas = new TheCanvas();
        canvas.startCanvas();
        currentDisp = canvas;
        WonHot.setCurrentDisp(currentDisp);
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    public void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
    }

    public static void setCurrentDisp(Displayable disp) {
        currentDisp = disp;
        display.setCurrent(currentDisp);
    }

    public static Displayable getCurrentDisp() {
        return currentDisp;
    }

    public static void quitApp() {
        try {
            midlet.notifyDestroyed();
            midlet.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initApp() {
        ThreadManager.start();
        welcome = new Welcome();
        welcome.start();
        mainMenu = new MainMenuScene();
        this.doTask((byte)1);
    }

    public void loadImages() {
        int i = 0;
        while (i < Res.IMAGEBUFFER.length) {
            String key = Res.IMAGEBUFFER[i].trim();
            Image img = Tools.createImage("/" + Res.imgPath + key + ".png");
            Res.imageTable.put(key, img);
            ++i;
        }
    }

    public void initViews() {
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + Res.imgPath + "epg.xml");
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            String str = new String(bytes, "utf-8");
            EpgMenu.buildViewsByXml(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshMainMenu() {
        Node root = EpgMenu.rootNode;
        if (root != null) {
            ImageListView nodelist = (ImageListView)ViewManager.getViewByName("channellist");
            nodelist.setFocus(true);
            int i = 0;
            while (i < root.getNodeNum()) {
                Node node = root.getNodeAt(i);
                if (node != null) {
                    FormView discImg;
                    if (i == 0) {
                        TextView test;
                        TitleView tv = (TitleView)ViewManager.getViewByName("epgtitle");
                        if (tv != null) {
                            tv.setLabel(node.name);
                        }
                        if ((test = (TextView)ViewManager.getViewByName("discText")) != null) {
                            test.setText(node.desc);
                        }
                    }
                    ImageItem iv = new ImageItem();
                    iv.setShowDesCribe(false);
                    iv.setId(node.id);
                    iv.setName(node.name);
                    iv.setDeskCribe(node.desc);
                    System.out.println("icon: " + node.icon);
                    if (Res.imageTable.containsKey(node.icon)) {
                        iv.setImg(node.icon);
                        if (i == 0) {
                            FormView fv = (FormView)ViewManager.getViewByName("discImg");
                            fv.setImg(iv.getImg());
                        }
                    } else {
                        iv.setDefaultImg(node.nodeType);
                        ImageHolder holder = new ImageHolder();
                        holder.url = node.icon;
                        iv.sanxingSelectedIndex = i;
                        iv.addAttachImageView((FormView)ViewManager.getViewByName("discImg"));
                        holder.addListenner(iv);
                        ImageLoaderManager.add(holder);
                    }
                    if (i == 0 && (discImg = (FormView)ViewManager.getViewByName("discImg")) != null && iv.getImg() != null) {
                        discImg.setImg(iv.getImg());
                    }
                    iv.setData(node);
                    nodelist.addItem(iv);
                }
                ++i;
            }
            String space = "userSpace";
            ImageItem spaceitem = new ImageItem();
            spaceitem.setImg("userSpace");
            spaceitem.setShowDesCribe(false);
            spaceitem.setData(space);
            spaceitem.setName("\u4e2a\u4eba\u7a7a\u95f4");
            spaceitem.setDeskCribe("\u60a8\u53ef\u4ee5\u66f4\u6539\u60a8\u4e2a\u4eba\u559c\u597d\u548c\u6536\u85cf");
            nodelist.addItem(spaceitem);
            String str = "search";
            ImageItem iv = new ImageItem();
            iv.setImg("search");
            iv.setShowDesCribe(false);
            iv.setData(str);
            iv.setName("\u8282\u76ee\u641c\u7d22");
            iv.setDeskCribe("\u60a8\u53ef\u4ee5\u8f93\u5165\u5173\u952e\u5b57\u641c\u7d22\u60a8\u611f\u5174\u8da3\u7684\u8282\u76ee");
            nodelist.addItem(iv);
        }
    }

    public void gotoMainMenu() {
        this.refreshMainMenu();
        if (mainMenu == null) {
            mainMenu = new MainMenuScene();
        }
        mainMenu.open();
    }

    public void doTask(byte mode) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new GameTask(mode), 0L);
    }

    public static void UpdateByOTA() {
        try {
            SystemInfo iSystemInf = SystemInfo.initSystemInfo();
            if (iSystemInf.updateurl != null && iSystemInf.updateurl.trim().length() > 0) {
                midlet.platformRequest(iSystemInf.updateurl);
            }
            Thread.sleep(1000L);
            WonHot.quitApp();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            WonHot.quitApp();
        }
    }

    public static String getPlayUrl() {
        String url = midlet.getAppProperty("playurl");
        return url;
    }

    public class GameTask
    extends TimerTask {
        private byte mode = 0;

        public GameTask(byte mode) {
            this.mode = mode;
        }

        public void run() {
            switch (this.mode) {
                case 1: {
                    WonHot.this.initViews();
                    break;
                }
                case 2: {
                    WonHot.this.gotoMainMenu();
                }
            }
        }
    }
}

