/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.WonHot;
import com.canvas.view.View;
import com.canvas.view.item.TextView;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;

public class InputView
extends View
implements CommandListener {
    private boolean drawBorder = true;
    private String inputString = "";
    private TextBox txtBox;
    private Command CMD_OK;
    private byte inputType = 0;
    public static final byte INPUTTYPE_LINE = 0;
    public static final byte INPUTTYPE_ARE = 1;
    public boolean isPassword = false;
    private int maxLen = 20;
    private TextView text;
    private int rectColor = 4244724;

    public InputView(int len) {
        this.maxLen = len;
        this.type = 10;
    }

    public void setInputType(byte type) {
        this.inputType = type;
        if (this.inputType == 1) {
            this.text = new TextView();
            this.text.setFont(this.font);
            this.text.setFontColor(this.fontColor);
            this.text.setColor(this.color);
            this.text.setFillBG(false);
            this.text.setX(this.x);
            this.text.setY(this.y);
            this.text.setWidth(this.width);
            this.text.setHeight(this.height);
        }
    }

    public void createTextBox(String title, String key, int type) {
        this.txtBox = new TextBox(title, key, this.maxLen, type);
        this.CMD_OK = new Command("\u786e\u5b9a", 2, 1);
        this.txtBox.addCommand(this.CMD_OK);
        this.txtBox.setCommandListener((CommandListener)this);
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public void setRectColor(int c) {
        this.rectColor = c;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        int dx = this.x;
        int dy = this.y;
        if (this.transparency == -1 && this.fillBG) {
            g.setColor(this.color);
            g.fillRect(dx, dy, this.width, this.height);
        }
        this.drawImage(g, this.img, dx, dy);
        g.setFont(Res.UIFONT);
        g.setColor(this.rectColor);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.setColor(this.fontColor);
        if (this.drawBorder && this.isFocus()) {
            g.setColor(Res.UICOLOR_BORDER);
            g.drawRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
            g.drawRect(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
        }
        String str = this.inputString;
        if (this.isPassword && this.inputString != null && this.inputString.trim().length() > 0) {
            str = "********";
        }
        if (this.inputType == 0) {
            g.setColor(this.fontColor);
            dy = this.y + (this.height - g.getFont().getHeight()) / 2;
            if (g.getFont().stringWidth(str) < this.width - 2) {
                g.drawString(str, this.x + 1, dy, 20);
            } else {
                int cx = g.getClipX();
                int cy = g.getClipY();
                int cw = g.getClipWidth();
                int ch = g.getClipHeight();
                g.setClip(this.x, dy, this.width, this.height);
                dx = this.x + this.width - 3;
                g.drawString(str, this.x + 1, dy, 20);
                g.setClip(cx, cy, cw, ch);
            }
        } else if (this.inputType == 1 && this.text != null) {
            this.text.setColor(this.color);
            this.text.setFont(this.font);
            this.text.setFontColor(this.fontColor);
            this.text.paint(g);
        }
    }

    public ViewEvent InputAction(int keyCode, String title, String key, int type) {
        this.createTextBox(title, key, type);
        WonHot.setCurrentDisp((Displayable)this.txtBox);
        return null;
    }

    public void clear() {
        this.txtBox = null;
        this.CMD_OK = null;
    }

    public String getText() {
        return this.inputString;
    }

    public void setText(String str) {
        if (str == null || str.trim().length() == 0) {
            return;
        }
        this.inputString = str;
        if (this.inputString.length() > this.maxLen) {
            this.inputString = this.inputString.substring(0, this.maxLen - 3);
            this.inputString = String.valueOf(this.inputString) + "...";
        }
        if (this.inputType == 1) {
            this.text.setText(this.inputString);
        }
    }

    public void commandAction(Command cmd, Displayable arg1) {
        if (cmd == this.CMD_OK) {
            this.inputString = this.txtBox.getString();
            if (this.text != null && this.inputType == 1) {
                this.text.setText(this.inputString);
            }
            WonHot.setCurrentDisp((Displayable)WonHot.canvas);
            WonHot.canvas.setFullScreenMode(true);
        }
    }
}

