/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.until;

import com.canvas.view.View;
import com.canvas.view.item.ButtonView;
import com.canvas.view.item.FormView;
import com.canvas.view.item.ImageItem;
import com.canvas.view.item.ListView;
import com.canvas.view.item.Progress;
import com.canvas.view.item.TitleView;
import java.util.Hashtable;

public class ViewManager {
    public static Hashtable table = new Hashtable();

    public static View getViewByName(String key) {
        return (View)table.get(key);
    }

    public static void addView(String key, View view) {
        table.put(key, view);
    }

    public static void removeView(String key) {
        if (table.contains(key)) {
            View view = (View)table.get(key);
            View parent = view.getContainer();
            if (parent != null) {
                parent.removeItem(view);
            }
            table.remove(key);
            view.clear();
            Object var1_1 = null;
        }
    }

    public static void clearViews() {
        table.clear();
    }

    public static int getSize() {
        return table.size();
    }

    public static boolean containView(String key) {
        return table.containsKey(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static View buildViewsByXML(View view, String xml) {
        try {
            if (xml == null) return null;
            xml = xml.trim();
            while (true) {
                if (xml.length() <= 0) {
                    return null;
                }
                String event = ViewManager.getNextEvent(xml);
                if (event.equals("cmt")) continue;
                if (event.equals("form")) {
                    FormView formView = new FormView();
                    View view2 = ViewManager.buildViewsByXML(formView, xml);
                    view.addItem(view2);
                    continue;
                }
                event.equals("list");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getViewByEvent(String event, String xml) {
        String content = ViewManager.getTagContent(event, xml);
        return content;
    }

    public static String getNextEvent(String xml) {
        int index1 = xml.indexOf("<");
        int index2 = xml.indexOf(">");
        int index3 = xml.indexOf("<--");
        int index4 = xml.indexOf("<?");
        if (index1 < 0 || index2 < 0) {
            return null;
        }
        if (index3 == index1) {
            return "cmt";
        }
        if (index4 == index1) {
            return "start";
        }
        if (index2 > index1) {
            return xml.substring(index1 + 1, index2).trim();
        }
        return null;
    }

    public static View pharseXML(View view, String xml) {
        if (xml != null) {
            xml = xml.trim();
        }
        if (xml == null || xml.length() <= 0) {
            return null;
        }
        String event = ViewManager.getNextEvent(xml);
        View v = null;
        if (event == null) {
            return null;
        }
        if (event.equals("form")) {
            v = new FormView();
            v = (FormView)ViewManager.pharseXML(v, xml);
        } else if (event.equals("list")) {
            v = new ListView();
            v = (ListView)ViewManager.pharseXML(v, xml);
        } else if (event.equals("title")) {
            v = new TitleView();
            v = (TitleView)ViewManager.pharseXML(v, xml);
        } else if (event.equals("imageitem")) {
            v = new ImageItem();
            v = (ImageItem)ViewManager.pharseXML(v, xml);
        } else if (event.equals("button")) {
            v = new ButtonView();
            v = (ButtonView)ViewManager.pharseXML(v, xml);
        } else if (event.equals("progress")) {
            v = new Progress();
            v = (Progress)ViewManager.pharseXML(v, xml);
        } else if (event.equals("id")) {
            view.setId(event);
        }
        if (v != null) {
            view.addItem(v);
        }
        return null;
    }

    public static String getTagContent(String src, String tag) {
        String temp1 = "<" + tag + ">";
        String temp2 = "</" + tag + ">";
        int index1 = src.indexOf(temp1);
        int index2 = src.indexOf(temp2);
        if (index1 >= 0 && index2 > index1) {
            String result = src.substring(index1 + temp1.length(), index2);
            return result;
        }
        return null;
    }
}

