/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.until;

import javax.microedition.lcdui.Image;

public class Until {
    public static final int FP_SHIFT = 13;
    public static final int FP_ONE = 8192;
    public static final int FP_HALF = 4096;
    public static final int MODE_POINT_SAMPLE = 0;
    public static final int MODE_BOX_FILTER = 1;

    public static Image RollImage(Image img, int angle) {
        Image image = null;
        int ang = -999;
        if (angle == 90) {
            ang = 5;
        } else if (angle == 180) {
            ang = 3;
        } else if (angle == 270) {
            ang = 6;
        }
        if (ang != -999) {
            image = Image.createImage((Image)img, (int)0, (int)0, (int)img.getWidth(), (int)img.getHeight(), (int)ang);
        }
        return image;
    }

    public static Image[] RollImage(Image img1, Image img2) {
        Image[] image = new Image[]{img1, img2, Until.RollImage(img1, 90), Until.RollImage(img2, 90), Until.RollImage(img1, 180), Until.RollImage(img2, 180), Until.RollImage(img1, 270), Until.RollImage(img2, 270)};
        return image;
    }

    public static Image scaleImage(Image src, int scales1, int scales2) {
        return Until.transImage(src, src.getWidth() * scales1 / scales2, src.getHeight() * scales1 / scales2);
    }

    public static Image transImage(Image src, int w, int h) {
        return Until.resizeImage(src, w, h, 0);
    }

    public static Image createAlphaImage(Image img, int alphaColor) {
        int w = img.getWidth();
        int h = img.getHeight();
        int[] imgData = new int[w * h];
        img.getRGB(imgData, 0, w, 0, 0, w, h);
        int i = 0;
        while (i < imgData.length) {
            imgData[i] = imgData[i] & alphaColor;
            ++i;
        }
        Image immutableImg = Image.createRGBImage((int[])imgData, (int)w, (int)h, (boolean)true);
        return immutableImg;
    }

    static int[] getPixels(Image src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] pixels = new int[w * h];
        src.getRGB(pixels, 0, w, 0, 0, w, h);
        return pixels;
    }

    static Image drawPixels(int[] pixels, int w, int h) {
        return Image.createRGBImage((int[])pixels, (int)w, (int)h, (boolean)true);
    }

    static Image resizeImage(Image src, int destW, int destH, int mode) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = Until.getPixels(src);
        if (mode == 0) {
            int destY = 0;
            while (destY < destH) {
                int destX = 0;
                while (destX < destW) {
                    int srcX = destX * srcW / destW;
                    int srcY = destY * srcH / destH;
                    destPixels[destX + destY * destW] = srcPixels[srcX + srcY * srcW];
                    ++destX;
                }
                ++destY;
            }
        } else {
            int argb;
            int g;
            int b;
            int r;
            int a;
            int count;
            int ratioW = (srcW << 13) / destW;
            int ratioH = (srcH << 13) / destH;
            int[] tmpPixels = new int[destW * srcH];
            int y = 0;
            while (y < srcH) {
                int destX = 0;
                while (destX < destW) {
                    count = 0;
                    a = 0;
                    r = 0;
                    b = 0;
                    g = 0;
                    int srcX = destX * ratioW >> 13;
                    int srcX2 = (destX + 1) * ratioW >> 13;
                    do {
                        argb = srcPixels[srcX + y * srcW];
                        a += (argb & 0xFF000000) >> 24;
                        r += (argb & 0xFF0000) >> 16;
                        g += (argb & 0xFF00) >> 8;
                        b += argb & 0xFF;
                        ++count;
                    } while (++srcX <= srcX2 && srcX + y * srcW < srcPixels.length);
                    tmpPixels[destX + y * destW] = (a /= count) << 24 | (r /= count) << 16 | (g /= count) << 8 | (b /= count);
                    ++destX;
                }
                ++y;
            }
            System.out.println("Vertical resampling...");
            int x = 0;
            while (x < destW) {
                int destY = 0;
                while (destY < destH) {
                    count = 0;
                    a = 0;
                    r = 0;
                    b = 0;
                    g = 0;
                    int srcY = destY * ratioH >> 13;
                    int srcY2 = (destY + 1) * ratioH >> 13;
                    do {
                        argb = tmpPixels[x + srcY * destW];
                        a += (argb & 0xFF000000) >> 24;
                        r += (argb & 0xFF0000) >> 16;
                        g += (argb & 0xFF00) >> 8;
                        b += argb & 0xFF;
                        ++count;
                    } while (++srcY <= srcY2 && x + srcY * destW < tmpPixels.length);
                    a = (a /= count) > 255 ? 255 : a;
                    r = (r /= count) > 255 ? 255 : r;
                    g = (g /= count) > 255 ? 255 : g;
                    b = (b /= count) > 255 ? 255 : b;
                    destPixels[x + destY * destW] = a << 24 | r << 16 | g << 8 | b;
                    ++destY;
                }
                ++x;
            }
        }
        return Until.drawPixels(destPixels, destW, destH);
    }
}

