/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.utility;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LineEnumeration
implements Enumeration {
    private Font font;
    private String text;
    private int width;
    private int position;
    private int length;
    private int start = 0;

    public LineEnumeration(Font font, String text, int width) {
        this.font = font;
        this.text = text;
        this.width = width;
        this.length = text.length();
    }

    public boolean hasMoreElements() {
        return this.position <= this.length - 1;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            int next = this.next();
            String s = this.text.substring(this.start, next);
            this.start = next;
            if (this.text.length() - 1 > this.start && (this.text.charAt(this.start) == ' ' || this.text.charAt(this.start) == '\n')) {
                ++this.position;
                ++this.start;
            }
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    private int next() {
        int i = this.position;
        int lastBreak = -1;
        while (i < this.length && this.font.stringWidth(this.text.substring(this.position, i + 1)) <= this.width) {
            if (this.text.charAt(i) == ' ') {
                lastBreak = i;
            } else if (this.text.charAt(i) == '\n') {
                lastBreak = i;
                break;
            }
            ++i;
        }
        this.position = i == this.length ? i : (lastBreak == this.position ? ++this.position : (lastBreak < this.position ? i : lastBreak));
        return this.position;
    }

    public int writeTo(Graphics g, int startx, int starty, Font font) {
        int fontHeight = font.getHeight() + 1;
        while (this.hasMoreElements()) {
            g.drawString(String.valueOf(this.nextElement()), startx, starty, 20);
            starty += fontHeight;
        }
        return starty;
    }

    public String[] getStringArray() {
        Vector<String> stringVector = new Vector<String>();
        while (this.hasMoreElements()) {
            stringVector.addElement(String.valueOf(this.nextElement()));
        }
        if (stringVector.size() == 0) {
            stringVector.removeAllElements();
            stringVector = null;
            System.gc();
            return null;
        }
        Object[] stringArray = new String[stringVector.size()];
        stringVector.copyInto(stringArray);
        stringVector.removeAllElements();
        stringVector = null;
        System.gc();
        return stringArray;
    }

    public void reset() {
        this.start = 0;
        this.position = 0;
    }

    public void reset(Font font, String text, int width) {
        this.font = font;
        this.text = text;
        this.width = width;
        this.length = text.length();
        this.reset();
    }

    public void unload() {
        this.font = null;
        this.text = null;
    }
}

