/*
 * Decompiled with CFR 0.152.
 */
package gps;

import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV2.MapLV2Canvas;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.DataPool;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import net.kbox.Action;
import net.kbox.ActionForward;
import net.kbox.component.KCommand;
import search.Address;
import search.HSBCSearcher;
import util.Area;

public class GetLocation
implements Action {
    public void execute(KCommand kcmd, Item item, Displayable display, ActionForward forward, Hashtable parameters) throws Exception {
        Hashtable ps = kcmd.getParameters();
        Point p = (Point)ps.get("point");
        String area = Area.getArea(p.getLn());
        MapCanvas mc = (MapCanvas)DataPool.getAttribute(String.valueOf(area) + "mapL3");
        if (mc == null) {
            return;
        }
        if (mc.getPersons() == null) {
            mc.setPersons(new Vector());
        }
        if (mc.getPersons().size() == 0) {
            mc.getPersons().addElement(new Building());
        }
        Building person = (Building)mc.getPersons().firstElement();
        person.setLat(p.getLat());
        person.setLn(p.getLn());
        final MapLV2Canvas mcl2 = (MapLV2Canvas)mc;
        try {
            if (mcl2.getLV() == 3) {
                System.out.println("loading building...");
                Thread t = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e1) {
                            throw new RuntimeException(e1.toString());
                        }
                        Address[] as = new HSBCSearcher().searchAddressByCoordinate(mcl2.getCurrentLn(), mcl2.getCurrentLat(), 0.0036);
                        Vector<Address> showOnMap = new Vector<Address>();
                        if (as != null) {
                            int i = 0;
                            while (i < as.length) {
                                Address building = new Address();
                                building.setName(as[i].getName());
                                building.setAddress(as[i].getAddress());
                                building.setLat(as[i].getLat());
                                building.setLn(as[i].getLn());
                                building.setAddressId(as[i].getAddressId());
                                showOnMap.addElement(building);
                                ++i;
                            }
                        }
                        mcl2.setShowOnMap(showOnMap);
                        double currentLn = mcl2.getCurrentLn();
                        double currentLat = mcl2.getCurrentLat();
                        Vector buildings = mcl2.getShowOnMap();
                        if (buildings != null) {
                            Vector<Integer> selectedBuildingIndexs = new Vector<Integer>();
                            int i = 0;
                            while (i < buildings.size()) {
                                Building building = (Building)buildings.elementAt(i);
                                double addLn = Math.abs(building.getLn() - currentLn);
                                double addLat = Math.abs(building.getLat() - currentLat);
                                if (addLn < 4.5E-5 && addLat < 4.5E-5) {
                                    selectedBuildingIndexs.addElement(new Integer(i));
                                }
                                ++i;
                            }
                            mcl2.setSelectedBuildingIndex(selectedBuildingIndexs);
                        }
                        try {
                            mcl2.reflash();
                        }
                        catch (NullAreaException e) {
                            throw new RuntimeException(e.toString());
                        }
                    }
                };
                DataPool.setAttribute("LoadingBuildingThread", t);
                t.setPriority(1);
                t.start();
            }
            mcl2.showMapBy84(p.getLn(), p.getLat());
        }
        catch (NullAreaException e1) {
            mcl2.drawString("[ERROR]Map Error!", 0, 0);
            forward.forward((Displayable)mcl2);
            return;
        }
        forward.forward((Displayable)mcl2);
    }
}

