/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.utility;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateTime {
    private static String[] WEEKDAYS = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    public final String timeZone;
    public final int year;
    public final int month;
    public final int day;
    public final int weekday;
    public final int hour;
    public final int minute;
    public final int second;

    public DateTime(Date date, String timeZone) {
        this.timeZone = timeZone;
        Calendar c = timeZone == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        c.setTime(date);
        this.year = c.get(1);
        this.month = c.get(2);
        this.day = c.get(5);
        this.weekday = c.get(7);
        this.hour = c.get(11);
        this.minute = c.get(12);
        this.second = c.get(13);
    }

    public DateTime(long time, String timeZone) {
        this(new Date(time), timeZone);
    }

    public Date toDate() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(this.timeZone));
        c.set(1, this.year);
        c.set(2, this.month);
        c.set(5, this.day);
        c.set(11, this.hour);
        c.set(12, this.minute);
        c.set(13, this.second);
        return c.getTime();
    }

    public String toTimestampString() {
        String secondString;
        String minuteString;
        String hourString;
        String dayString;
        String monthString;
        String yearString = Integer.toString(this.year);
        if (yearString.length() > 2) {
            yearString = yearString.substring(2, yearString.length());
        }
        if ((monthString = Integer.toString(this.month + 1)).length() == 1) {
            monthString = "0" + monthString;
        }
        if ((dayString = Integer.toString(this.day)).length() == 1) {
            dayString = "0" + dayString;
        }
        if ((hourString = Integer.toString(this.hour)).length() == 1) {
            hourString = "0" + hourString;
        }
        if ((minuteString = Integer.toString(this.minute)).length() == 1) {
            minuteString = "0" + minuteString;
        }
        if ((secondString = Integer.toString(this.second)).length() == 1) {
            secondString = "0" + secondString;
        }
        return String.valueOf(yearString) + monthString + dayString + hourString + minuteString + secondString;
    }

    public String toMonthString() {
        String monthString;
        String yearString = Integer.toString(this.year);
        if (yearString.length() > 2) {
            yearString = yearString.substring(2, yearString.length());
        }
        if ((monthString = Integer.toString(this.month + 1)).length() == 1) {
            monthString = "0" + monthString;
        }
        return String.valueOf(monthString) + "/" + yearString;
    }

    public String toDateString() {
        return String.valueOf(this.day) + "/" + (this.month + 1) + "/" + this.year;
    }

    public String toTimeString() {
        return String.valueOf(this.hour) + ":" + this.minute + ":" + this.second;
    }

    public String toString() {
        return String.valueOf(this.toDateString()) + " " + this.toTimeString();
    }
}

