/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

public class Base64 {
    static final String ENCODING_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static char[] map1;
    private static byte[] map2;

    private Base64() {
    }

    public static String encode(String source) {
        int i;
        char[] sourceBytes = Base64.getPaddedBytes(source);
        int numGroups = (sourceBytes.length + 2) / 3;
        char[] targetBytes = new char[4];
        char[] target = new char[4 * numGroups];
        for (int group = 0; group < numGroups; ++group) {
            Base64.convert3To4(sourceBytes, group * 3, targetBytes);
            for (i = 0; i < targetBytes.length; ++i) {
                target[i + 4 * group] = ENCODING_CHARS.charAt(targetBytes[i]);
            }
        }
        int numPadBytes = sourceBytes.length - source.length();
        for (i = target.length - numPadBytes; i < target.length; ++i) {
            target[i] = 61;
        }
        return new String(target);
    }

    private static char[] getPaddedBytes(String source) {
        char[] converted = source.toCharArray();
        int requiredLength = 3 * ((converted.length + 2) / 3);
        char[] result = new char[requiredLength];
        System.arraycopy(converted, 0, result, 0, converted.length);
        return result;
    }

    private static void convert3To4(char[] source, int sourceIndex, char[] target) {
        target[0] = (char)(source[sourceIndex] >>> 2);
        target[1] = (char)((source[sourceIndex] & 3) << 4 | source[sourceIndex + 1] >>> 4);
        target[2] = (char)((source[sourceIndex + 1] & 0xF) << 2 | source[sourceIndex + 2] >>> 6);
        target[3] = (char)(source[sourceIndex + 2] & 0x3F);
    }

    public static String decode(String source) {
        if (source.length() % 4 != 0) {
            throw new RuntimeException("valid Base64 codes have a multiple of 4 characters");
        }
        int numGroups = source.length() / 4;
        int numExtraBytes = source.endsWith("==") ? 2 : (source.endsWith("=") ? 1 : 0);
        byte[] targetBytes = new byte[3 * numGroups];
        byte[] sourceBytes = new byte[4];
        for (int group = 0; group < numGroups; ++group) {
            for (int i = 0; i < sourceBytes.length; ++i) {
                sourceBytes[i] = (byte)Math.max(0, ENCODING_CHARS.indexOf(source.charAt(4 * group + i)));
            }
            Base64.convert4To3(sourceBytes, targetBytes, group * 3);
        }
        return new String(targetBytes, 0, targetBytes.length - numExtraBytes);
    }

    private static void convert4To3(byte[] source, byte[] target, int targetIndex) {
        target[targetIndex] = (byte)(source[0] << 2 | source[1] >>> 4);
        target[targetIndex + 1] = (byte)((source[1] & 0xF) << 4 | source[2] >>> 2);
        target[targetIndex + 2] = (byte)((source[2] & 3) << 6 | source[3]);
    }

    public static byte[] decode(char[] in) {
        int iLen = in.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iLen ? in[ip++] : 65;
            int n = i3 = ip < iLen ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    public static byte[] decode(byte[] in) {
        int iLen = in.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iLen - 1] == 61) {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            byte i0 = in[ip++];
            byte i1 = in[ip++];
            int i2 = ip < iLen ? in[ip++] : 65;
            int n = i3 = ip < iLen ? in[ip++] : 65;
            if (i0 > 127 || i1 > 127 || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    static {
        int c;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.map1[i++] = c;
        }
        Base64.map1[i++] = 43;
        Base64.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            Base64.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64.map2[Base64.map1[i]] = (byte)i;
        }
    }
}

