/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.CntThread;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer
extends CntThread
implements PlayerListener {
    public static final int SOUND_INTERVAL = 1000;
    protected static SoundPlayer instance;
    private static Hashtable soundsProps;
    private static Vector sounds;
    private Player mediaPlayer;
    public static boolean playNextAfterMediaEnd;

    private SoundPlayer() {
        super("SoundPlayer");
    }

    public static SoundPlayer getInstance() {
        if (instance == null) {
            instance = new SoundPlayer();
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playSound(int soundId, String mimeType, byte[] soundData, int volume) {
        Vector vector = sounds;
        synchronized (vector) {
            for (int i = 0; i < sounds.size(); ++i) {
                if ((Integer)sounds.elementAt(i) != soundId) continue;
                return;
            }
            Integer sid = new Integer(soundId);
            Object[] data = new Object[]{sid, mimeType, soundData, new Integer(volume)};
            soundsProps.put(sid, data);
            sounds.addElement(sid);
            SoundPlayer soundPlayer = instance;
            synchronized (soundPlayer) {
                instance.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMe() {
        while (true) {
            if (sounds.size() == 0) {
                SoundPlayer soundPlayer = instance;
                synchronized (soundPlayer) {
                    try {
                        instance.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            Object[] soundData = null;
            Vector ex = sounds;
            synchronized (ex) {
                if (sounds.size() > 0) {
                    soundData = (Object[])soundsProps.get(sounds.elementAt(0));
                }
            }
            if (soundData != null) {
                if (this.mediaPlayer != null) {
                    try {
                        this.mediaPlayer.deallocate();
                        this.mediaPlayer.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.internalPlaySound((String)soundData[1], (byte[])soundData[2], (Integer)soundData[3]);
                soundData = null;
            }
            Vector vector = sounds;
            synchronized (vector) {
                if (sounds.size() > 0) {
                    soundsProps.remove(sounds.elementAt(0));
                    sounds.removeElementAt(0);
                }
            }
        }
    }

    public void closeMe() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPlaySound(String mimeType, byte[] soundData, Integer volume) {
        Hashtable hashtable = soundsProps;
        synchronized (hashtable) {
            if (soundData != null) {
                this.mediaPlayer = this.startMediaPlayer(soundData, mimeType, volume);
            }
            if (this.mediaPlayer != null) {
                try {
                    this.mediaPlayer.start();
                    soundsProps.wait(1000L);
                }
                catch (Throwable mex) {
                    // empty catch block
                }
            }
        }
    }

    private final Player startMediaPlayer(byte[] data, String mimeType, int volume) {
        Player player = null;
        try {
            player = Manager.createPlayer((InputStream)new ByteArrayInputStream(data), (String)mimeType);
            player.addPlayerListener((PlayerListener)this);
            player.realize();
            player.prefetch();
            VolumeControl volControl = (VolumeControl)player.getControl("VolumeControl");
            volControl.setLevel(volume);
        }
        catch (Throwable e) {
            player = null;
        }
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerUpdate(Player player, String event, Object eventData) {
        if (this.mediaPlayer != null && player != null && event != null && event.equals("endOfMedia")) {
            this.mediaPlayer.close();
        }
        if (this.mediaPlayer != null && player != null && event != null && event.equals("closed") && !playNextAfterMediaEnd) {
            Hashtable hashtable = soundsProps;
            synchronized (hashtable) {
                soundsProps.notifyAll();
            }
        }
    }

    private static int getSoundId(int communityId, int alertType) {
        return (communityId & 0x49) << 1 | alertType;
    }

    public static void playAlert(int communityID, int alertType) {
        SoundPlayer.playSound(communityID, alertType, "audio/midi");
    }

    public static void playSound(int communityID, int alertType, String mimeType) {
        int level = 80;
        String alertVolume = "0";
        if (alertVolume.equals("0")) {
            level = 100;
        } else if (alertVolume.equals("1")) {
            level = 80;
        } else if (alertVolume.equals("2")) {
            level = 0;
        }
        if (level > 0) {
            byte[] soundData = null;
            SoundPlayer.playSound(SoundPlayer.getSoundId(communityID, alertType), mimeType, soundData, level);
        }
    }

    public byte[] read(String file) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(file);
        byte[] data = new byte[in.available()];
        in.read(data);
        return data;
    }

    static {
        soundsProps = new Hashtable();
        sounds = new Vector();
        playNextAfterMediaEnd = true;
    }
}

