/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.engine;

import com.fw.j2me.ui.UiCallback;
import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.SyncQueue;
import com.sonyericsson.ykjc.engine.Engine;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.DataChannelVideos;
import com.sonyericsson.ykjc.model.DataMyYouKu;
import com.sonyericsson.ykjc.model.SearchResult;
import com.sonyericsson.ykjc.model.UserInfo;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.proxy.YkEvent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import java.util.Random;
import java.util.Vector;

public class SimEngine
extends Engine {
    private static final int FOUND = 80;
    private String curKeyword;
    private WaitThread wThread;
    private Random r = new Random(System.currentTimeMillis());

    public SimEngine(UiCallback cb) {
        super(cb);
        this.wThread = new WaitThread();
        this.wThread.start();
        this.initDummyData();
    }

    private void initDummyData() {
        this.simChannels();
        this.simHotWords();
        this.simCurrentVideo();
        this.simMyYouku();
        this.simRecommendList();
        this.simRelativeList();
        this.simSearchResult();
        this.simUserInfo();
        this.simChannelVideos();
        this.simGetMyYouKu();
    }

    private void simUserInfo() {
        UserInfo info = new UserInfo();
        info.setName("seyk@yahoo.com.cn");
        info.setPassword("123456");
        info.setUserId("seyk@yahoo.com.cn");
        info.setVideoList(this.createVideoList());
        this.model.setUserInfo(info);
    }

    private Vector createVideoList() {
        Vector<VideoInfo> vect = new Vector<VideoInfo>();
        for (int i = 0; i < 5; ++i) {
            VideoInfo vi = this.createVideoInfo(i);
            vect.addElement(vi);
        }
        return vect;
    }

    private VideoInfo createVideoInfo(int i) {
        VideoInfo vi = new VideoInfo();
        int min = this.r.nextInt(60);
        int sec = this.r.nextInt(60);
        String smin = min < 10 ? "0" + min : "" + min;
        String ssec = sec < 10 ? "0" + sec : "" + sec;
        vi.setDuration(smin + ":" + ssec);
        vi.setId("" + i);
        int index = i;
        String imgName = index == 0 ? "thumbnail" : "thumbnail" + index;
        vi.setImg(YkUiContext.imgMgr.getImage(imgName));
        vi.setImgUrl("imgurl");
        vi.setDesc("ice forge: " + i);
        vi.setDown(20 + this.r.nextInt(50));
        vi.setPlayTimes(100 + this.r.nextInt(2000));
        vi.setUp(10 + this.r.nextInt(100));
        vi.setTitle(YkUiContext.strMgr.getString("simVideo" + i));
        vi.setVideoUrl("/0.3gp");
        return vi;
    }

    private void simSearchResult() {
        this.model.setSearchResult(this.simSearchResult("keyword", 1, 5, true));
    }

    private SearchResult simSearchResult(String key, int page, int num, boolean success) {
        SearchResult result = new SearchResult();
        result.setKeyword(key);
        Vector v = this.createVideoList();
        if (success) {
            result.setResult(v);
            result.setAllPage(40000);
            result.setAllResult(19966);
            result.setCurPage(page);
        } else {
            result.setRelateWords(new String[]{key + "BMW", key + "MAZDA6", key + "70M", key + "BUS"});
        }
        return result;
    }

    private void simGetMyYouKu() {
        this.model.setMyYouKu(this.simGetMyYouKu("zengkun@sohu.com", "test", 1, 5));
    }

    private DataMyYouKu simGetMyYouKu(String email, String pwd, int page, int num) {
        DataMyYouKu result = new DataMyYouKu();
        result.setEmail(email);
        result.setPwd(pwd);
        Vector v = this.createVideoList();
        result.setResult(v);
        result.setAllPage(40000);
        result.setAllResult(19966);
        result.setCurPage(page);
        return result;
    }

    private void simChannelVideos() {
        this.model.setChannelVideos(this.simChannelVideos("96", 1, 5));
    }

    private DataChannelVideos simChannelVideos(String cid, int page, int num) {
        DataChannelVideos data = new DataChannelVideos();
        data.setCID(cid);
        Vector v = this.createVideoList();
        data.setResult(v);
        data.setAllPage(40000);
        data.setAllResult(19966);
        data.setCurPage(page);
        return data;
    }

    private void simRelativeList() {
        this.model.setRelativeList(this.createVideoList());
    }

    private void simRecommendList() {
        this.model.setRecommendList(this.createVideoList());
    }

    private void simMyYouku() {
    }

    private void simChannels() {
        Vector<Channel> channels = new Vector<Channel>();
        for (int i = 0; i < 9; ++i) {
            Channel tmpC = new Channel();
            tmpC.setName("Channel " + i);
            channels.addElement(tmpC);
        }
        this.model.setChannels(channels);
    }

    private void simHotWords() {
        this.model.setHotKeywords(new String[]{YkUiContext.strMgr.getString("simHot0"), YkUiContext.strMgr.getString("simHot1")});
    }

    private void simCurrentVideo() {
        VideoInfo vi = this.createVideoInfo(0);
        this.model.setCurrentVideo(vi);
    }

    public void doGetRelateVideoList() {
        this.wThread.addEvent(9);
    }

    public void doGetRecommendVideoList() {
        this.wThread.addEvent(5);
    }

    public void doGetChannels() {
        this.wThread.addEvent(10);
    }

    public void doGetChannelVideos(String strCID, int pg, int pz) {
        this.wThread.addEvent(11);
    }

    public void doSearch(String keyword, int page, int num) {
        if (keyword.equalsIgnoreCase(this.curKeyword)) {
            this.simSearchResult(keyword, page, num, true);
        } else {
            this.curKeyword = keyword;
            this.simSearchResult(keyword, page, num, this.simFound());
        }
        this.wThread.addEvent(6);
    }

    public void doGetMyYouKu(String strEMail, String strPwd, int pg, int pz) {
        this.wThread.addEvent(13);
    }

    public void doGetKeywords(int kn) {
        this.wThread.addEvent(7);
    }

    private boolean simFound() {
        return this.r.nextInt(100) < 80;
    }

    public class WaitThread
    extends CntThread {
        private SyncQueue queueWaiting = new SyncQueue(2);

        public WaitThread() {
            super("WaitThread");
        }

        public void addEvent(int event) {
            this.queueWaiting.put(new Integer(event));
        }

        protected void closeMe() {
            this.queueWaiting.clearQueue();
        }

        protected void runMe() {
            while (!this.stop) {
                int event = (Integer)this.queueWaiting.get(null);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SimEngine.this.callBack.handleEvent(new YkEvent(event));
            }
        }
    }
}

