/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.DataChannelVideos;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.NavigationBar;
import com.sonyericsson.ykjc.ui.component.SearchBox2;
import com.sonyericsson.ykjc.ui.component.YBrowser;
import com.sonyericsson.ykjc.ui.component.YForm;
import com.sonyericsson.ykjc.ui.pages.PageSearchBase;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;

public class PageChannelVideos
extends PageSearchBase
implements FocusListener {
    protected static final int PLAY_COMMAND = 1;
    protected static final int LOGOUT_COMMAND = 2;
    protected static final int MYYOUKU_COMMAND = 3;
    protected static final int HELP_COMMAND = 4;
    private static final int PAGE_NAV_COMMAND = 5;
    protected Command cmdPlay = new Command(YkUiContext.strMgr.getString("play"), 1);
    private Command cmdMyyk = new Command(YkUiContext.strMgr.getString("myYouku"), 3);
    private Command cmdLogout = new Command(YkUiContext.strMgr.getString("logout"), 2);
    private Command cmdHelp = new Command(YkUiContext.strMgr.getString("help"), 4);
    private DataChannelVideos mData = null;
    private VideoInfo[] videos;
    private YBrowser yBrowser;
    private NavigationBar pageNavBar;

    public PageChannelVideos(int id) {
        super(id);
    }

    protected void addTopComponents(Container c) {
        this.pageNavBar = new NavigationBar(this.form.getWidth(), this.mData.getAllResult(), this.mData.getCurPage(), this.mData.getAllPage(), null){

            protected void getPage(int page) {
                IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217751));
                waiting.setExceptEvent(11);
                YkUiContext.proxy.doGetChannelVideos(PageChannelVideos.this.mData.getCID(), page);
            }
        };
        this.pageNavBar.setFocusListener(this);
        Channel curCh = YkUiContext.proxy.getCurrentChannel();
        String strTitle = YkUiContext.strMgr.getString("channel");
        if (null != curCh.getName()) {
            strTitle = curCh.getName() + strTitle;
        }
        this.pageNavBar.setTitle(strTitle);
        c.addComponent(this.pageNavBar);
    }

    private void addVideoComponents(Container c) {
        if (null == this.mData || this.mData.getResult() == null) {
            Label title = new Label(YkUiContext.strMgr.getString("channel_videos_empty"));
            title.getStyle().setFgColor(0);
            title.getStyle().setBgTransparency(0);
            title.setPreferredSize(new Dimension(this.form.getWidth(), this.form.getHeight() / 3));
            title.setAlignment(4);
            c.addComponent(title);
            return;
        }
        this.videos = new VideoInfo[this.mData.getResult().size()];
        this.mData.getResult().copyInto(this.videos);
        this.yBrowser = new YBrowser(this.videos, this);
        ((YForm)this.form).addIndependentComponents(this.yBrowser);
        if (this.videos.length > 0) {
            this.form.setFocused(this.yBrowser.getReal());
        } else {
            this.form.setFocused(this.searchBox);
        }
        c.addComponent(this.yBrowser);
    }

    protected void buildPageContent() {
        this.form.setLayout(new CoordinateLayout(YkPageBase.getScreenWidth(), YkPageBase.getScreenHeight()));
        this.mData = YkUiContext.proxy.getChannelVideos();
        if (null == this.mData) {
            return;
        }
        String[] words = YkUiContext.proxy.getHotKeywords();
        this.searchBox = new SearchBox2(new Dimension(YkPageBase.getScreenWidth(), 0), words);
        this.searchBox.setListener(this);
        Container otherComponents = new Container(new BoxLayout(2));
        this.addTopComponents(otherComponents);
        if (this.mData.getResult().size() > 0) {
            this.addVideoComponents(otherComponents);
            this.pageNavBar.setFocusDown(this.yBrowser.getReal());
        } else {
            Label title = new Label(YkUiContext.strMgr.getString("channel_videos_empty"));
            title.getStyle().setFgColor(0);
            title.getStyle().setBgTransparency(0);
            title.setPreferredSize(new Dimension(this.form.getWidth(), this.form.getHeight() / 3));
            title.setAlignment(4);
            otherComponents.addComponent(title);
            this.pageNavBar.setFocusDown(this.pageNavBar);
        }
        this.pageNavBar.setFocusUp(this.searchBox);
        int searchBoxHeight = YkUiContext.uiConfig.getIntProperty("search_box_height", 40);
        this.searchBox.setY(0);
        ((YForm)this.form).addIndependentComponents(this.searchBox);
        otherComponents.setY(searchBoxHeight);
        this.form.addComponent(otherComponents);
        this.form.addComponent(this.searchBox);
    }

    public void buildPageCommand() {
        this.form.removeAllCommands();
        super.buildPageCommand();
        if (this.yBrowser != null && this.yBrowser.hasFocus()) {
            this.form.addCommand(this.cmdPlay);
        } else if (this.pageNavBar != null && this.pageNavBar.hasFocus()) {
            Command cmdPageNav = new Command(this.pageNavBar.getIndicateString(), 5);
            this.form.addCommand(cmdPageNav);
        }
        this.form.addCommand(this.cmdBack);
        this.form.addCommand(this.cmdHelp);
        this.form.addCommand(this.cmdMyyk);
        if (YkUiContext.proxy.getLoginStatus()) {
            this.form.addCommand(this.cmdLogout);
        }
    }

    public void doActionPerformed(ActionEvent evt) {
        super.doActionPerformed(evt);
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 0: {
                UiContext.pageMgr.changePage(0x10000000);
                break;
            }
            case 1: {
                this.playVideo(this.yBrowser.getCurVideoInfo());
                break;
            }
            case 3: {
                this.doActionMyYoukuOption();
                break;
            }
            case 2: {
                this.doActionLogoutOption();
                break;
            }
            case 4: {
                this.changePage(5);
                break;
            }
            case 5: {
                this.pageNavBar.navigate(evt);
                break;
            }
        }
    }

    public boolean handleEvent(CntEvent event) {
        boolean handle = false;
        if (event == null) {
            return handle;
        }
        int type = event.getEventType();
        switch (type) {
            case 100: {
                if (this.videos == null) break;
                String videoId = event.getAttrString(100);
                for (int i = 0; i < this.videos.length; ++i) {
                    if (!this.videos[i].getId().equals(videoId)) continue;
                    if (this.yBrowser != null) {
                        this.yBrowser.setClip(this.videos[i].getImg(), i);
                    }
                    handle = true;
                }
                this.yBrowser.repaint();
                break;
            }
        }
        return handle;
    }

    public void refresh() {
        super.refresh();
        if (this.yBrowser != null && this.videos != null && this.videos.length > 0) {
            this.yBrowser.refresh();
            this.form.setFocused(this.yBrowser.getReal());
        }
        this.searchBox.refresh();
        this.buildPageCommand();
    }

    public void cleanup() {
        this.searchBox.stopTimer();
    }

    public void focusGained(Component cmp) {
        this.buildPageCommand();
    }

    public void focusLost(Component cmp) {
        this.buildPageCommand();
    }
}

