/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.BoldLabel;
import com.sonyericsson.ykjc.ui.component.EditBox;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.YNotice;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Font;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class PageLogin
extends YkPageBase {
    private static final int COMMAND_LOGIN = 1;
    private EditBox email;
    private EditBox password;
    private Button register;

    public PageLogin(int pageID) {
        super(pageID);
    }

    public void buildPageCommand() {
        Command login = new Command(YkUiContext.strMgr.getString("login"), 1);
        this.form.addCommand(this.cmdBack);
        this.form.addCommand(login);
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        if (cmd != null) {
            switch (cmd.getId()) {
                case 1: {
                    String id = this.email.getEditorText();
                    String pwd = this.password.getEditorText();
                    this.doLogin(id, pwd);
                    break;
                }
                case 0: {
                    this.changePage(0x10000000);
                    break;
                }
                case 300: {
                    if (this.email.editor == this.form.getFocused()) {
                        this.email.editor.handleEditCmd();
                        break;
                    }
                    if (this.password.editor != this.form.getFocused()) break;
                    this.password.editor.handleEditCmd();
                    break;
                }
            }
        } else if (evt.getSource() == this.register) {
            this.changePage(0x8000010);
        }
    }

    protected void buildPageContent() {
        try {
            DefaultLookAndFeel laf = (DefaultLookAndFeel)UIManager.getInstance().getLookAndFeel();
            laf.setCheckBoxImages(YkUiContext.imgMgr.getImage("check"), YkUiContext.imgMgr.getImage("uncheck"));
            this.form.setLayout(new BoxLayout(2));
            BoldLabel title = new BoldLabel(YkUiContext.strMgr.getString("login"));
            Font labelFont = Font.createSystemFont(32, 0, 8);
            Font underLineFont = Font.createSystemFont(32, 4, 8);
            int labelColor = 0;
            this.form.addComponent(title);
            this.form.addComponent(new Seperator());
            this.email = new EditBox(YkUiContext.strMgr.getString("email"), 1);
            this.email.setLabelFont(labelFont, labelColor);
            String id = this.getStoredId();
            if (id != null) {
                this.email.setText(id);
            }
            this.form.addComponent(this.email);
            int maxLen = 16;
            this.password = new EditBox(YkUiContext.strMgr.getString("password"), 65537);
            this.password.setLabelFont(labelFont, labelColor);
            this.password.setMaxLength(maxLen);
            this.form.addComponent(this.password);
            this.register = new Button();
            String s = YkUiContext.strMgr.getString("freeRegister");
            this.register.setText(s);
            this.register.getStyle().setFont(underLineFont);
            this.register.getStyle().setBorder(null);
            this.register.getStyle().setFgSelectionColor(17151);
            this.register.getStyle().setFgColor(0);
            this.register.setAlignment(4);
            this.register.addActionListener(this);
            this.form.addComponent(this.register);
            this.email.getReal().setNextFocusLeft(this.email.getReal());
            this.email.getReal().setNextFocusRight(this.email.getReal());
            this.email.getReal().setNextFocusUp(this.email.getReal());
            this.password.getReal().setNextFocusLeft(this.password.getReal());
            this.password.getReal().setNextFocusRight(this.password.getReal());
            this.register.setNextFocusLeft(this.register);
            this.register.setNextFocusRight(this.register);
            this.register.setNextFocusDown(this.register);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doLogin(String id, String pwd) {
        this.storeIdPwd(id, pwd);
        if (this.checkInput(id, pwd)) {
            IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(0x8000002));
            waiting.setExceptEvent(15);
            YkUiContext.proxy.doLogin(id, pwd);
        }
    }

    private boolean checkInput(String id, String pwd) {
        if (id == null || pwd == null) {
            YNotice.showNotice(3);
            return false;
        }
        if (id.length() < 3 || pwd.length() == 0) {
            YNotice.showNotice(3);
            return false;
        }
        int atCnt = 0;
        for (int i = 0; i < id.length(); ++i) {
            if (id.charAt(i) != '@') continue;
            ++atCnt;
        }
        if (atCnt != 1) {
            YNotice.showNotice(3);
            return false;
        }
        return true;
    }

    private void storeIdPwd(String id, String pwd) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"YKRMS", (boolean)true);
            if (rs.getNumRecords() > 0) {
                RecordEnumeration set = rs.enumerateRecords(null, null, false);
                Vector<Integer> recordIds = new Vector<Integer>();
                while (set.hasNextElement()) {
                    String prefix;
                    int recordId = set.nextRecordId();
                    String str = new String(rs.getRecord(recordId));
                    if (str.length() <= 4 || !(prefix = str.substring(0, 4)).equals("@usr") && !prefix.equals("@pwd")) continue;
                    recordIds.addElement(new Integer(recordId));
                }
                for (int i = 0; i < recordIds.size(); ++i) {
                    rs.deleteRecord(((Integer)recordIds.elementAt(i)).intValue());
                }
            }
            if (id != null && pwd != null) {
                String prefixedId = "@usr" + id;
                String prefixedPwd = "@pwd" + pwd;
                rs.addRecord(prefixedId.getBytes(), 0, prefixedId.getBytes().length);
                rs.addRecord(prefixedPwd.getBytes(), 0, prefixedPwd.getBytes().length);
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    private String getStoredId() {
        String id = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"YKRMS", (boolean)true);
            if (rs.getNumRecords() > 0) {
                RecordEnumeration set = rs.enumerateRecords(null, null, false);
                while (set.hasNextElement()) {
                    String prefix;
                    int recordId = set.nextRecordId();
                    String str = new String(rs.getRecord(recordId));
                    if (str.length() <= 4 || !(prefix = str.substring(0, 4)).equals("@usr")) continue;
                    id = str.substring(4);
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return id;
    }
}

