/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.CntMidlet;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.Device;
import com.fw.j2me.util.PimUtil;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.BoldLabel;
import com.sonyericsson.ykjc.ui.component.YNotice;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;

public class PageUploadNotice
extends YkPageBase {
    private CntLog log = new CntLog("PageUploadNotice");
    private static final int EXIT_COMMAND = 0;
    private static final int CONTINUE_COMMAND = 1;
    private boolean dismiss;
    private static final long MAX_FILE_SIZE = Device.getPropertyInt("uploadMaxSize", 0xC800000);

    public PageUploadNotice(int id) {
        super(id);
    }

    public void buildPageCommand() {
        Command cmdContinue = new Command(YkUiContext.strMgr.getString("continue"), 1);
        Command cmdBack = new Command(YkUiContext.strMgr.getString("exit"), 0);
        this.form.addCommand(cmdContinue);
        this.form.addCommand(cmdBack);
    }

    protected void buildPageContent() {
        this.form.setLayout(new BoxLayout(2));
        this.form.addComponent(new BoldLabel(YkUiContext.strMgr.getString("notice_title")));
        TextArea contentText = new TextArea(YkUiContext.strMgr.getString("upload_agreement"));
        contentText.setEditable(false);
        contentText.setRows(8);
        contentText.getStyle().setBgTransparency(0);
        this.form.addComponent(contentText);
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 0: {
                YkUiContext.removeSendFile();
                if (!YkUiContext.isMainPageShown()) {
                    this.doExitOption();
                    break;
                }
                UiContext.pageMgr.changePage(0x4000001);
                break;
            }
            case 1: {
                if (YkUiContext.proxy.getLoginStatus()) {
                    this.changePage(14);
                } else {
                    this.changePage(0x800000B);
                }
                if (!this.fileSizeTooLarge(YkUiContext.getSendFile())) break;
                YNotice.showNotice(22);
                this.doChangePage();
                break;
            }
        }
    }

    private boolean fileSizeTooLarge(String sendFile) {
        return PimUtil.getFileSize(sendFile) > MAX_FILE_SIZE;
    }

    private synchronized void doChangePage() {
        this.log.debug("in doChangePage()");
        YkUiContext.removeSendFile();
        if (!this.dismiss) {
            this.dismiss = true;
            CntMidlet.getInstance().minimize();
            this.log.debug("in doChangePage()  YkUiContext.isMainPageShown() = " + YkUiContext.isMainPageShown());
            if (!YkUiContext.isMainPageShown()) {
                UiContext.pageMgr.changePage(0x8000000);
                YkUiContext.proxy.doGetChannels();
                YkUiContext.proxy.doGetKeywords();
                YkUiContext.proxy.doGetRecommendVideoList();
            } else {
                UiContext.pageMgr.changePage(0x4000001);
            }
        }
    }
}

