/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.protocolimpl;

import com.fw.j2me.protocol.IReqCreator;
import com.fw.j2me.protocol.ISession;
import com.fw.j2me.protocol.ISessionListener;
import com.fw.j2me.protocolimpl.CntReq;
import com.fw.j2me.protocolimpl.ReqSender;
import com.fw.j2me.protocolimpl.RespHandler;
import com.fw.j2me.protocolimpl.SyncEvent;

public abstract class Session
implements ISession {
    protected ReqSender sender;
    private ISessionListener listener;
    protected IReqCreator reqCreator;

    public Session() {
        this.startSender();
        this.genReqCreator();
    }

    private void startSender() {
        if (this.sender != null) {
            this.sender.stop();
        }
        this.sender = new ReqSender();
        RespHandler handler = new RespHandler(this);
        this.sender.setHandler(handler);
        handler.start();
        this.sender.start();
    }

    public void handleNetworkResp(CntReq req) {
        this.listener.doneJob(req);
    }

    public void doJob(int reqType, Object param) {
        CntReq req = this.reqCreator.createReq(reqType, param);
        this.doJob(req);
    }

    public void doJob(CntReq req) {
        int priority = req.getReqType() >>> 30;
        if (priority == 0) {
            this.listener.syncInform(SyncEvent.genReqIdEvent(req.getReqId()));
        }
        req.removeFlag(1);
        this.sender.queueRequest(req);
    }

    public void setListener(ISessionListener listener) {
        this.listener = listener;
    }

    public void pause() {
        this.sender.pause();
    }

    public void resume() {
        this.sender.resume();
    }

    protected abstract void genReqCreator();
}

