/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.uiimpl;

import com.fw.j2me.protocolimpl.SyncEvent;
import com.fw.j2me.ui.IPage;
import com.fw.j2me.ui.IPageCreator;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.log.CntLog;
import java.util.Hashtable;
import java.util.Vector;

public class PageManager {
    private CntLog log = new CntLog("PageManager");
    protected IPageCreator pc;
    private Hashtable pagesIndex = new Hashtable();
    private Vector pageStack = new Vector();
    private IPage currentPage;
    private SyncEvent syncEvent;
    private Object pageObj = new Object();

    private IPage createPage(int pageID) {
        return this.pc.createPage(pageID);
    }

    private IPage popTopPages(int pageID) {
        IPage retPage = null;
        int index = -1;
        Integer id = new Integer(pageID);
        if (this.pagesIndex.containsKey(id)) {
            index = (Integer)this.pagesIndex.get(id);
        }
        if (index >= 0) {
            int size = this.pageStack.size();
            for (int i = size - 1; i >= index; --i) {
                retPage = (IPage)this.pageStack.elementAt(i);
                this.pageStack.removeElementAt(i);
                this.pagesIndex.remove(new Integer(retPage.getPageID()));
            }
        } else if ((pageID & 0x4000000) == 0x4000000) {
            this.pageStack.removeAllElements();
            this.pagesIndex.clear();
        }
        return retPage;
    }

    private IPage pushPage(IPage p, int pageID) {
        IPage retPage = p;
        if (retPage == null || retPage.testPageFlag(0x20000000)) {
            retPage = this.createPage(pageID);
            if (retPage != null) {
                retPage.init();
            }
        } else {
            retPage.refresh();
        }
        if (retPage != null && !retPage.testPageFlag(0x8000000)) {
            this.pageStack.addElement(retPage);
            this.pagesIndex.put(new Integer(pageID), new Integer(this.pageStack.size() - 1));
        }
        return retPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IPage changePage(int pageID) {
        this.log.debug("in changePage()  pageID = " + pageID);
        IPage oldPage = this.currentPage;
        IPage p = this.currentPage;
        Object object = this.pageObj;
        synchronized (object) {
            this.currentPage = null;
        }
        try {
            if (pageID == 0x10000000 && this.pageStack.size() > 0) {
                do {
                    if (!p.testPageFlag(0xC000000)) {
                        this.pageStack.removeElementAt(this.pageStack.size() - 1);
                        this.pagesIndex.remove(new Integer(p.getPageID()));
                    }
                    p = (IPage)this.pageStack.elementAt(this.pageStack.size() - 1);
                } while (this.pageStack.size() > 0 && p.testPageFlag(0x10000000));
                this.pagesIndex.put(new Integer(p.getPageID()), new Integer(this.pageStack.size() - 1));
                p.refresh();
            } else {
                p = this.popTopPages(pageID);
                p = this.pushPage(p, pageID);
            }
        }
        catch (Exception e) {
            this.log.error("changePage() to ID: " + pageID + "; ", e);
            p = oldPage;
        }
        object = this.pageObj;
        synchronized (object) {
            this.currentPage = p;
        }
        if (oldPage != this.currentPage && oldPage != null) {
            oldPage.cleanup();
        }
        if (p != null) {
            p.show();
        }
        System.gc();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentPageID() {
        Object object = this.pageObj;
        synchronized (object) {
            if (this.currentPage != null) {
                return this.currentPage.getPageID();
            }
            return -1;
        }
    }

    public IPage getCurrentPage() {
        return this.currentPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(CntEvent event) {
        IPage p = null;
        Object object = this.pageObj;
        synchronized (object) {
            p = this.currentPage;
        }
        if (p != null) {
            return p.handleEvent(event);
        }
        return false;
    }

    public SyncEvent getSyncEvent() {
        return this.syncEvent;
    }

    public void setSyncEvent(SyncEvent syncEvent) {
        this.syncEvent = syncEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCurrentPage() {
        IPage p = null;
        Object object = this.pageObj;
        synchronized (object) {
            if (this.currentPage != null) {
                p = this.currentPage;
            }
        }
        if (p != null) {
            p.show();
        }
    }
}

