/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util.video;

import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.PimUtil;
import com.fw.j2me.util.log.CntLog;
import com.fw.j2me.util.video.VideoCanvas;
import com.fw.j2me.util.video.VideoThumbnailListener;
import com.sun.lwuit.Image;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class VideoFile {
    private static CntLog log = new CntLog("VideoFile");
    private String filename;
    private long size;
    private String url;
    private Image thumbnail;
    private Vector listeners = new Vector();

    public VideoFile(final String url) {
        this.url = url;
        this.filename = MiscUtil.getFileNameFromUrl(url);
        this.size = PimUtil.getFileSize(url);
        new Thread(){

            public void run() {
                VideoFile.this.getNail(url);
            }
        }.start();
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public String getUrl() {
        return this.url;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void addListener(VideoThumbnailListener listener) {
        this.removeListener(listener);
        this.listeners.addElement(listener);
    }

    public void removeListener(VideoThumbnailListener listener) {
        this.listeners.removeElement(listener);
    }

    private void notifyListeners() {
        Enumeration enu = this.listeners.elements();
        while (enu.hasMoreElements()) {
            ((VideoThumbnailListener)enu.nextElement()).finishCapture(this);
        }
    }

    private void getNail(String url) {
        try {
            InputStream is = PimUtil.getInputStreamFromFile(url);
            String mime = MiscUtil.guessContentType(url);
            Player player = Manager.createPlayer((InputStream)is, (String)mime);
            player.realize();
            VideoControl videoControl = (VideoControl)player.getControl("VideoControl");
            VideoCanvas canvas = new VideoCanvas(videoControl);
            canvas.getHeight();
            player.start();
            Thread.sleep(100L);
            player.deallocate();
            byte[] raw = videoControl.getSnapshot(null);
            this.thumbnail = Image.createImage(raw, 0, raw.length);
            if (this.thumbnail == null) {
                log.debug("nail is not capture");
            } else {
                log.debug("incapnailwidth" + this.thumbnail.getWidth());
                log.debug("incapnailheight" + this.thumbnail.getHeight());
            }
            player.stop();
            player.close();
            player = null;
            videoControl = null;
            this.notifyListeners();
        }
        catch (Exception e) {
            log.debug("getNail(" + url + ") ", e);
        }
    }
}

