/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.IndependentComponent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.ClipBrowserListener;
import com.sonyericsson.ykjc.ui.component.ClipInformationItem;
import com.sonyericsson.ykjc.ui.component.HorizontalClipBrowser;
import com.sonyericsson.ykjc.ui.component.IndependentComponentCreator;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;

public class YBrowser
extends Container
implements ClipBrowserListener,
FocusListener,
IndependentComponentCreator {
    private YkPageBase page;
    private HorizontalClipBrowser browser;
    private ClipInformationItem clipInfo;
    private VideoInfo[] videos;
    private VideoInfo curVideoInfo;

    public YBrowser(VideoInfo[] videos, YkPageBase page) {
        this.videos = videos;
        this.page = page;
        this.setLayout(new BoxLayout(2));
        Image[] images = new Image[videos.length];
        for (int i = 0; i < videos.length; ++i) {
            images[i] = videos[i].getImg();
        }
        int browserH = 100;
        browserH = YkUiContext.uiConfig.getIntProperty("video_browser_height", browserH);
        this.browser = new HorizontalClipBrowser(images, 0, new Dimension(YkPageBase.getScreenWidth(), browserH));
        this.browser.setHorizontalClipBrowserListener(this);
        this.browser.setEmptyText(YkUiContext.strMgr.getString("emptyRecommendClipText"));
        this.browser.addFocusListener(this);
        this.browser.setFocus(videos.length > 0);
        int clipInfoH = 70;
        clipInfoH = YkUiContext.uiConfig.getIntProperty("video_clip_height", clipInfoH);
        this.clipInfo = new ClipInformationItem(new Dimension(YkPageBase.getScreenWidth(), clipInfoH));
        this.clipInfo.setFocusable(false);
        this.selectClipChanged(this.browser.getCurrentSelectClip());
        this.setFocusable(false);
        this.addComponent(this.browser);
        this.addComponent(this.clipInfo);
    }

    public void selectClipChanged(int selectIndex) {
        if (this.videos == null) {
            return;
        }
        if (this.videos.length < 1) {
            return;
        }
        if (selectIndex < 0 || selectIndex > this.videos.length - 1) {
            return;
        }
        this.curVideoInfo = this.videos[selectIndex];
        if (null == this.curVideoInfo) {
            return;
        }
        this.clipInfo.setClipInformation(this.curVideoInfo.getTitle(), this.curVideoInfo.getSize(), this.curVideoInfo.getPlayTimes(), this.curVideoInfo.getUp(), this.curVideoInfo.getDown(), this.videos[selectIndex].getImg());
        this.clipInfo.repaint();
    }

    public void focusGained(Component c) {
        if (c == this.browser && this.videos.length > 0) {
            this.page.buildPageCommand();
            if (null != this.clipInfo) {
                this.clipInfo.setFocus(true);
            }
        }
    }

    public void focusLost(Component c) {
        if (c == this.browser && this.videos.length > 0) {
            this.page.buildPageCommand();
            if (null != this.clipInfo) {
                this.clipInfo.setFocus(false);
            }
        }
    }

    public int getCurrentSelectClip() {
        return this.browser.getCurrentSelectClip();
    }

    public void setClip(Image clipImage, int position) {
        this.browser.setClip(clipImage, position);
    }

    public VideoInfo getCurVideoInfo() {
        return this.curVideoInfo;
    }

    public boolean hasFocus() {
        return this.browser.hasFocus();
    }

    public IndependentComponent genIndependentComponent() {
        return this.browser.genIndependentComponent();
    }

    public Component getReal() {
        return this.browser;
    }

    public void refresh() {
        this.browser.refresh(this.videos);
    }
}

