/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.util.MiscUtil;
import com.sonyericsson.ykjc.ui.component.YkTabbedTitle;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;

public class YkTabbedPane
extends Container {
    private YkTabbedTitle title;
    private Component[] comps;
    private int index;

    public YkTabbedPane(Dimension d) {
        this.setPreferredSize(d);
        this.setFocusable(true);
    }

    public YkTabbedPane(Dimension d, String[] titles, Component[] comps) {
        this(d);
        if (MiscUtil.isEmpty(titles) || MiscUtil.isEmpty(comps) || titles.length != comps.length) {
            throw new IllegalArgumentException("the length of arguments titles and comps are not equal. ");
        }
        this.title = new YkTabbedTitle(d, titles, this);
        this.title.setFocusable(false);
        this.comps = comps;
        this.buildContent();
    }

    public void setContent(String[] titles, Component[] comps) {
        if (MiscUtil.isEmpty(titles) || MiscUtil.isEmpty(comps) || titles.length != comps.length) {
            throw new IllegalArgumentException("the length of arguments titles and comps are not equal. ");
        }
        this.title = new YkTabbedTitle(this.getPreferredSize(), titles, this);
        this.comps = comps;
        this.buildContent();
    }

    public int getIndex() {
        return this.index;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.index = selectedIndex;
        this.buildContent();
    }

    private void buildContent() {
        this.removeAll();
        this.addComponent(this.title);
        this.comps[this.index].setFocusable(false);
        this.addComponent(this.comps[this.index]);
        this.repaint();
    }

    public void keyPressed(int keyCode) {
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 5 || gameAction == 2) {
            this.title.keyPressed(keyCode);
        } else {
            this.comps[this.index].keyPressed(keyCode);
        }
    }

    Component[] getComps() {
        return this.comps;
    }
}

