/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.CntMidlet;
import com.fw.j2me.ui.IPage;
import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.ui.lwuit.FwCanvas;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.Device;
import com.fw.j2me.util.IoUtil;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.log.CntLog;
import com.nokia.mid.ui.DeviceControl;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.YNotice;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

public class PagePlayer
extends GameCanvas
implements PlayerListener,
Runnable,
IPage {
    private static final int MENU_BAR_H = 19;
    private static final int BUTTON_MARGIN = 18;
    private static final int PROGRESS_BAR_W = 7;
    private static final int PLAYER_WIDTH_FACTOR = 4;
    private static final int PLAYER_HEIGHT_FACTOR = 3;
    private static final int BUFFER_ANIM_FRAME = 9;
    private static CntLog log = new CntLog("PagePlayer");
    private static Player player = null;
    private long duration;
    private long lastTime = 0L;
    private VideoControl vidc;
    private static Font font = Font.getFont((int)0, (int)0, (int)8);
    private static int fontHeight = font.getHeight();
    private static final int FIX_BORDER_W = fontHeight + 8 + 7;
    private int canvasW;
    private int canvasH;
    private int videoW;
    private int videoH;
    private boolean suspended = false;
    private boolean restartOnResume = false;
    private long restartMediaTime;
    private Thread monitor;
    private int verticalB;
    private int horizenB;
    private int frameX;
    private int frameY;
    private int frameW;
    private int frameH;
    private AsistantThread asistantThread;
    private LightThread lightThread = null;
    private Image[] animImage = new Image[9];
    private long startBuffering;
    private static final long BUFFERING_DURATION = YkUiContext.uiConfig.getLongProperty("buffering_time", 10000L);
    private double bufProgressValue;
    private static final long BUFFERING_REFRESH = 100L;
    private Image imageBack;
    private Image imagePause;
    private Image imageStop;
    private Image imagePlay;
    private Image progressBgImg;
    private Image progressBarImg;
    private Image progressFocusImg;
    private Image bg;
    private Image slot;
    private Image progress;
    private Image progressHead;
    private InputStream is;
    private Graphics paintG;
    private Object finishObj = new Object();
    private boolean finished;
    private VideoInfo curInfo;
    private static final String WAITING_STRING = YkUiContext.strMgr.getString("playBuffering");

    public PagePlayer() {
        super(false);
        CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)this);
        this.setFullScreenMode(true);
        this.initDimension();
        this.finished = false;
        try {
            this.imageBack = Image.createImage((String)"/back.png");
            this.imagePause = Image.createImage((String)"/pause.png");
            this.imageStop = Image.createImage((String)"/stop.png");
            this.imagePlay = Image.createImage((String)"/play.png");
            this.bg = Image.createImage((String)"/playbg.png");
            this.slot = Image.createImage((String)"/slot.png");
            this.progress = Image.createImage((String)"/progress.png");
            this.progressHead = Image.createImage((String)"/progressdot.png");
            for (int i = 0; i < 9; ++i) {
                this.animImage[i] = Image.createImage((String)("/" + i + ".png"));
            }
            this.progressBgImg = Image.createImage((String)"/uploadProgressBg.png");
            this.progressBarImg = Image.createImage((String)"/uploadProgressBar.png");
            this.progressFocusImg = Image.createImage((String)"/uploadProgressFocus.png");
        }
        catch (IOException e) {
            log.error("PagePlayer-" + e);
        }
        this.asistantThread = new AsistantThread();
        this.asistantThread.start();
        this.startBuffering = System.currentTimeMillis();
        this.startLightThread();
    }

    private void startLightThread() {
        int forbidScreenSaver = Device.getPropertyInt("ForbidScrennSaverWhenPlayVideo", 1);
        if (forbidScreenSaver == 1) {
            this.lightThread = new LightThread();
            this.lightThread.start();
        }
    }

    private void initDimension() {
        this.canvasW = this.getWidth();
        this.canvasH = this.getHeight();
        this.horizenB = 0;
        this.verticalB = 0;
        if (57 > FIX_BORDER_W * 4) {
            this.verticalB = (this.canvasW - FIX_BORDER_W - (this.canvasH - 19) * 3 / 4) / 2;
        } else {
            this.horizenB = (this.canvasH - 19 - (this.canvasW - FIX_BORDER_W) * 4 / 3) / 2;
        }
        this.videoW = this.canvasW - FIX_BORDER_W - this.verticalB * 2;
        this.videoH = this.canvasH - 19 - this.horizenB * 2;
    }

    public void paint(Graphics g) {
        this.paintG = this.getGraphics();
        try {
            this.paintBg();
            if (this.monitor == null || this.lastTime <= 0L) {
                this.paintBufferProgressBar();
            } else {
                this.paintProgressBar();
                this.paintControlButtons();
            }
        }
        catch (RuntimeException e) {
            log.error("paint(): " + e);
        }
        this.flushGraphics();
    }

    private void paintBufferProgressBar() {
        Font f = Font.getFont((int)0, (int)0, (int)8);
        int totalH = f.getHeight() * 2 + this.progressBgImg.getHeight();
        String waitingString = MiscUtil.replaceString(WAITING_STRING, "%1", "" + (int)this.bufProgressValue);
        int totalW = f.stringWidth(waitingString);
        if (totalW < this.progressBgImg.getWidth()) {
            totalW = this.progressBgImg.getWidth();
        }
        Image img = Image.createImage((int)totalW, (int)totalH);
        Graphics tempG = img.getGraphics();
        tempG.setColor(-1);
        tempG.setFont(f);
        tempG.drawRegion(this.bg, (this.canvasW - totalH) / 2, (this.canvasH - totalW) / 2, totalH, totalW, 5, 0, 0, 0);
        tempG.drawString(waitingString, (totalW - f.stringWidth(waitingString)) / 2, 0, 0);
        int tmpX = totalW - this.progressBgImg.getWidth() >> 1;
        int tmpY = f.getHeight() << 1;
        int allWidth = this.progressBarImg.getWidth();
        tempG.drawImage(this.progressBgImg, tmpX, tmpY, 0);
        tempG.setClip(tmpX += this.progressBgImg.getWidth() - this.progressBarImg.getWidth() >> 1, 0, (int)((double)allWidth * this.bufProgressValue / 100.0), totalH);
        tempG.drawImage(this.progressBarImg, tmpX, tmpY + (this.progressBgImg.getHeight() - this.progressBarImg.getHeight() >> 1), 0);
        tempG.setClip(0, 0, totalW, totalH);
        tempG.drawImage(this.progressFocusImg, tmpX + (int)((double)allWidth * this.bufProgressValue / 100.0) - (this.progressFocusImg.getWidth() >> 1), tmpY + (this.progressBgImg.getHeight() - this.progressFocusImg.getHeight() >> 1), 0);
        this.paintG.drawRegion(img, 0, 0, totalW, totalH, 5, (this.canvasW - totalH) / 2, (this.canvasH - totalW) / 2, 0);
        int buttonSize = this.imageBack.getWidth();
        int buttonY = this.canvasH - 19;
        this.paintG.drawImage(this.imageBack, this.canvasW - buttonSize - 18, buttonY, 0);
    }

    private void paintControlButtons() {
        this.paintG.drawRegion(this.bg, 0, this.frameY + this.frameH, this.bg.getWidth(), this.bg.getHeight() - this.frameY - this.frameH, 0, 0, this.frameY + this.frameH, 0);
        int buttonSize = this.imageBack.getWidth();
        int buttonY = this.canvasH - 19;
        this.paintG.drawImage(this.imageBack, this.canvasW - buttonSize - 18, buttonY, 0);
        this.paintG.drawImage(this.imageStop, 18, buttonY, 0);
        this.paintG.drawImage(this.suspended ? this.imagePlay : this.imagePause, this.canvasW / 2, buttonY, 17);
    }

    private void paintBar(Image barImg, int x, int y, int length) {
        int roundRadius = 3;
        if (length == 0) {
            return;
        }
        int half = length / 2;
        if (half == 0) {
            this.paintG.drawRegion(barImg, 0, 0, 7, 1, 0, x, y, 0);
        } else if (half <= 3) {
            this.paintG.drawRegion(barImg, 0, 0, 7, half, 0, x, y, 0);
            this.paintG.drawRegion(barImg, 0, barImg.getHeight() - (length - half), 7, length - half, 0, x, y + half, 0);
        } else {
            this.paintG.drawRegion(barImg, 0, 0, 7, 3, 0, x, y, 0);
            this.paintG.drawRegion(barImg, 0, barImg.getHeight() - 3, 7, 3, 0, x, y + length - 3, 0);
            this.paintG.drawRegion(barImg, 0, 3, 7, length - 6, 0, x, y + 3, 0);
        }
    }

    private void paintProgressBar() {
        this.paintG.drawRegion(this.bg, 0, 0, FIX_BORDER_W + this.verticalB, this.canvasH - 19 - this.horizenB, 0, 0, 0, 0);
        int x = this.frameX - 7 - 6;
        int p = this.time2pix(this.lastTime);
        this.paintBar(this.slot, x, this.frameY, this.frameH);
        this.paintBar(this.progress, x, this.frameY, p);
        this.paintProgressHead(x + (this.slot.getWidth() - this.progressHead.getWidth()) / 2, this.frameY + p - this.progressHead.getHeight() / 2);
        String timeInfo = MiscUtil.duratioin2String(this.lastTime) + "/" + MiscUtil.duratioin2String(this.duration);
        Image img = Image.createImage((int)font.stringWidth(timeInfo), (int)fontHeight);
        Graphics buffG = img.getGraphics();
        buffG.drawRegion(this.bg, 0, this.frameY + this.frameH - img.getWidth(), img.getHeight(), img.getWidth(), 5, 0, 0, 0);
        buffG.setFont(font);
        buffG.setColor(-1);
        buffG.drawString(timeInfo, 0, 0, 0);
        this.paintG.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), 5, 0, this.frameY + this.frameH - img.getWidth(), 0);
    }

    private void paintProgressHead(int x, int y) {
        this.paintG.drawImage(this.progressHead, x, y, 0);
    }

    private void paintBg() {
        this.paintG.drawImage(this.bg, 0, 0, 0);
    }

    private int time2pix(long time) {
        int result = (int)(time * (long)this.frameH / this.duration);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public void openPlayer(VideoInfo info) {
        this.curInfo = info;
        YkUiContext.proxy.setCurrentVideo(info);
        YkUiContext.proxy.freeze4PlayVideo();
        String url = info.getVideoUrl();
        this.lastTime = 0L;
        this.restartMediaTime = 0L;
        log.debug("play url = " + url);
        try {
            this.stopPlayer();
            if (player != null) {
                System.gc();
                System.gc();
            }
            if (url.startsWith("rtsp")) {
                player = Manager.createPlayer((String)url);
            } else if (url.startsWith("file:///")) {
                this.is = IoUtil.getInputStreamFromFile(url);
                player = Manager.createPlayer((InputStream)this.is, (String)MiscUtil.guessContentType(url));
            } else {
                this.is = url.getClass().getResourceAsStream(url);
                player = Manager.createPlayer((InputStream)this.is, (String)MiscUtil.guessContentType(url));
            }
            player.addPlayerListener((PlayerListener)this);
            log.debug("openPlayer: 1");
            player.realize();
            log.debug("openPlayer: 2");
            this.vidc = (VideoControl)player.getControl("VideoControl");
            if (null != this.vidc) {
                log.debug("openPlayer: 3");
                this.vidc.initDisplayMode(81, (Object)this);
                this.vidc.setVisible(false);
                this.frameW = this.vidc.getSourceHeight();
                this.frameH = this.vidc.getSourceWidth();
                if (this.frameW * 4 > this.frameH * 3) {
                    this.frameH = this.frameH * this.videoW / this.frameW;
                    this.frameW = this.videoW;
                } else {
                    this.frameW = this.frameW * this.videoH / this.frameH;
                    this.frameH = this.videoH;
                }
                this.frameX = FIX_BORDER_W + this.verticalB + (this.videoW - this.frameW) / 2;
                this.frameY = this.horizenB + (this.videoH - this.frameH) / 2;
                this.vidc.setDisplayLocation(this.frameX, this.frameY);
                this.vidc.setDisplaySize(this.frameW, this.frameH);
                log.debug("openPlayer: 4");
            }
            player.prefetch();
        }
        catch (Exception e) {
            log.error("openPlayer(): " + e);
            this.frameW = this.videoW;
            this.frameH = this.videoH;
            this.frameX = FIX_BORDER_W + this.verticalB + (this.videoW - this.frameW) / 2;
            this.frameY = this.horizenB + (this.videoH - this.frameH) / 2;
            this.finish(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlayer() {
        try {
            if (player != null) {
                player.stop();
                player.deallocate();
                player.close();
            }
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception e) {
            log.error("close Player: " + e);
        }
        finally {
            player = null;
            this.is = null;
            System.gc();
            System.gc();
        }
    }

    public void playerUpdate(Player plyr, String evt, Object evtData) {
        log.debug("playerUpdate: " + evt);
        if (evt == "endOfMedia") {
            this.lastTime = this.duration;
            this.repaint();
            this.finish(false, false);
        } else if (evt == "started") {
            this.lastTime = player.getMediaTime();
            log.debug("lastTime: " + this.lastTime);
            if (this.restartMediaTime <= 0L) {
                if (this.lastTime > 0L) {
                    this.lastTime = this.restartMediaTime;
                }
                this.lastTime = 1L;
            }
            try {
                this.vidc.setVisible(true);
            }
            catch (RuntimeException e) {
                log.error("playerUpdate(): " + evt);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean prev, boolean fail) {
        Object object = this.finishObj;
        synchronized (object) {
            if (!this.finished) {
                this.finished = true;
                try {
                    this.asistantThread.close();
                    if (this.lightThread != null) {
                        this.lightThread.close();
                    }
                    this.vidc.setVisible(false);
                    log.debug("before stopPlayer: " + System.currentTimeMillis());
                    this.stopPlayer();
                    log.debug("after stopPlayer: " + System.currentTimeMillis());
                }
                catch (Exception e) {
                    log.error("finish():", e);
                }
                YkUiContext.proxy.meltAfterPlayVideo();
                CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)FwCanvas.getInstance());
                FwCanvas.getInstance().flushGraphics();
                if (prev) {
                    UiContext.pageMgr.changePage(0x10000000);
                } else if (fail) {
                    UiContext.pageMgr.changePage(134217754);
                    YNotice.showNotice(9);
                    IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217749));
                    waiting.setExceptEvent(9);
                    YkUiContext.proxy.doGetRelateVideoList();
                } else {
                    IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217749));
                    waiting.setExceptEvent(9);
                    YkUiContext.proxy.doGetRelateVideoList();
                }
                System.gc();
            }
        }
    }

    public void keyPressed(int keyCode) {
        int curPageId = UiContext.pageMgr.getCurrentPageID();
        if (curPageId != 0x8000009) {
            UiContext.pageMgr.showCurrentPage();
            return;
        }
        switch (keyCode) {
            case -5: {
                this.repaint(0, this.frameY + this.frameH, this.canvasW, this.canvasH - this.frameY - this.frameH);
                if (this.suspended) {
                    this.startApp();
                    break;
                }
                this.pauseApp();
                break;
            }
            case -6: {
                if (this.lastTime <= 0L) break;
                this.finish(false, false);
                break;
            }
            case -7: {
                this.finish(true, false);
                break;
            }
        }
    }

    public synchronized void pauseApp() {
        if (player != null && player.getState() >= 400) {
            this.suspended = true;
            try {
                this.restartMediaTime = player.getMediaTime();
                if (this.restartMediaTime <= 0L) {
                    log.debug("before stop: ");
                    player.stop();
                    log.debug("after stop: ");
                    this.restartOnResume = true;
                } else {
                    player.deallocate();
                }
            }
            catch (MediaException e) {
                log.error("PagePlayer: pauseApp(): " + (Object)((Object)e));
                this.finish(false, true);
            }
            this.restartOnResume = true;
        } else {
            this.restartOnResume = false;
        }
    }

    public synchronized void startApp() {
        this.suspended = false;
        if (player != null && this.restartOnResume) {
            try {
                if (this.restartMediaTime > 0L) {
                    player.prefetch();
                    player.setMediaTime(this.restartMediaTime);
                }
                log.debug("before start: ");
                player.start();
                log.debug("after start: ");
            }
            catch (MediaException me) {
                log.error("PagePlayer: startApp(): " + (Object)((Object)me));
                this.finish(false, true);
            }
        }
        this.restartOnResume = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (player != null && player.getState() != 0 && !this.finished) {
            try {
                long time = 0L;
                PagePlayer pagePlayer = this;
                synchronized (pagePlayer) {
                    time = player.getMediaTime();
                }
                if (this.time2pix(time) != this.time2pix(this.lastTime)) {
                    this.lastTime = time;
                    this.repaint();
                    if (null != this.asistantThread && !this.asistantThread.isStop()) {
                        this.asistantThread.close();
                    }
                }
                do {
                    Thread.sleep(500L);
                } while (player != null && this.suspended);
            }
            catch (Exception e) {
                log.error("run(): " + e);
                this.finish(false, false);
                break;
            }
        }
    }

    public int getPageID() {
        return 0x8000009;
    }

    public boolean handleEvent(CntEvent event) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        try {
            log.debug("player: " + player);
            Object object = this.finishObj;
            synchronized (object) {
                if (player != null && !this.finished) {
                    CntMidlet.getInstance().getJDisplay().setCurrent((Displayable)this);
                    this.duration = player.getDuration();
                    if (this.duration <= 0L) {
                        String strDuration = this.curInfo.getDuration();
                        this.duration = MiscUtil.string2Duration(strDuration);
                    }
                    log.debug("duration: " + this.duration);
                    player.start();
                    if (this.duration != -1L) {
                        log.debug("monitor start");
                        this.monitor = new Thread(this);
                        this.monitor.start();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("show(): " + e);
            this.finish(false, true);
        }
    }

    public boolean testPageFlag(int flag) {
        return (0x8000009 & flag) != 0;
    }

    public void init() {
        log.error("Not implements");
    }

    public void refresh() {
        log.error("Not implements");
    }

    public String getPageName() {
        return "PagePlayer";
    }

    public void cleanup() {
    }

    protected void hideNotify() {
        log.debug("hideNotify");
        this.lastTime = 0L;
        this.pauseApp();
        if (this.lightThread != null) {
            this.lightThread.close();
        }
        super.hideNotify();
    }

    protected void showNotify() {
        log.debug("showNotify");
        this.startApp();
        this.startLightThread();
        this.repaint();
        super.showNotify();
    }

    class LightThread
    extends CntThread {
        public LightThread() {
            super("LightThread of PagePlayer");
        }

        protected void closeMe() {
        }

        public void runMe() {
            while (!this.stop) {
                DeviceControl.setLights((int)0, (int)100);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public class AsistantThread
    extends CntThread {
        public AsistantThread() {
            super("AsistantThread of PagePlayer");
        }

        protected void closeMe() {
        }

        protected void runMe() {
            while (!this.stop) {
                PagePlayer.this.repaint();
                try {
                    Thread.sleep(100L);
                    long past = System.currentTimeMillis() - PagePlayer.this.startBuffering;
                    if (past < BUFFERING_DURATION * 4L / 5L) {
                        PagePlayer.this.bufProgressValue = past * 100L / BUFFERING_DURATION;
                    } else {
                        PagePlayer.this.bufProgressValue += (100.0 - PagePlayer.this.bufProgressValue) / 100.0;
                    }
                    if (!(PagePlayer.this.bufProgressValue >= 96.0)) continue;
                    PagePlayer.this.bufProgressValue = 96.0;
                }
                catch (InterruptedException e) {
                    log.error("paint buff Animation" + e);
                }
            }
        }
    }
}

