/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.ChannelsBar;
import com.sonyericsson.ykjc.ui.component.FinishedVideoRender;
import com.sonyericsson.ykjc.ui.component.LoadingAnimation;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.pages.PageWaiting;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;

public class PageRelativeWaiting
extends PageWaiting {
    private VideoInfo seedVideo;
    private FinishedVideoRender fr;
    private ChannelsBar chsBar;

    public PageRelativeWaiting(int id, VideoInfo seed) {
        super(id);
        this.seedVideo = seed;
    }

    public void buildPageCommand() {
        this.form.removeAllCommands();
        this.form.addCommand(this.cmdNull);
        this.form.addCommand(this.cmdBack);
    }

    protected void buildPageContent() {
        this.form.setLayout(new BoxLayout(2));
        this.form.getStyle().setBgImage(YkUiContext.imgMgr.getImage("relateVideoBg"));
        Channel[] channels = YkUiContext.proxy.listChannel();
        int barHeight = 25;
        this.chsBar = new ChannelsBar(new Dimension(YkPageBase.getScreenWidth(), barHeight), channels, this);
        this.chsBar.setFocusable(false);
        this.chsBar.setDisable(true);
        this.form.addComponent(this.chsBar);
        this.form.addComponent(new Seperator());
        this.fr = new FinishedVideoRender(this.seedVideo, this.form);
        this.fr.setFocusable(false);
        this.form.addComponent(this.fr);
        this.form.addComponent(new Seperator());
        Label relative = new Label(YkUiContext.strMgr.getString("relative"));
        relative.setFocusable(false);
        relative.getStyle().setPadding(0, 0, 0, 0);
        Font labelFont = Font.createSystemFont(32, 0, 8);
        relative.getStyle().setFont(labelFont);
        this.form.addComponent(relative);
        LoadingAnimation splashLabel = new LoadingAnimation();
        splashLabel.setPreferredSize(new Dimension(this.form.getWidth(), splashLabel.getPreferredH()));
        this.form.addComponent(splashLabel);
        this.form.registerAnimated(splashLabel);
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 0: {
                this.cancel();
                break;
            }
        }
    }

    protected void gotoNextPage() {
        UiContext.pageMgr.changePage(0x2000000C);
    }

    protected void handleFail() {
        int curPageId = UiContext.pageMgr.getCurrentPageID();
        if (curPageId == this.getPageID()) {
            if (!this.canceled) {
                UiContext.pageMgr.changePage(0x2000000C);
                this.popWarningDialog();
            } else {
                UiContext.pageMgr.changePage(0x10000000);
            }
        }
    }

    protected void refreshVideoImage(CntEvent event) {
        String videoId = event.getAttrString(100);
        if (this.seedVideo.getId().equals(videoId)) {
            this.fr.setImage(this.seedVideo.getImg());
            this.fr.repaint();
        }
    }
}

