/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public abstract class Button
extends Widget {
    protected int _title;
    protected int _subtitle;
    protected Font _font1;
    protected Font _font2;
    protected int _titleX = 0;
    protected int _subtitleX = 0;
    protected int _subtitleY = 0;
    protected int _titleW = 0;
    protected int _subtitleW = 0;
    protected int _titleH;

    public Button(Window parent, int id, int title, int subtitle, Font f1, Font f2) {
        super(parent, id);
        this._selectable = true;
        this._title = title;
        this._subtitle = subtitle;
        this._font1 = f1;
        this._font2 = f2;
        this._titleH = this._subtitleY = f1.getHeight();
        this._subtitleY += 4;
        this._minH = subtitle >= 0 ? (f2 != null ? this._titleH + f2.getHeight() : this._titleH + f1.getHeight()) : this._titleH;
        this._h = this._minH;
        if (title >= 0) {
            this._titleW = f1.stringWidth(UI.getString(title));
            if (subtitle >= 0) {
                this._subtitleW = this._font2 != null ? f2.stringWidth(UI.getString(subtitle)) : f1.stringWidth(UI.getString(subtitle));
            }
            this._minW = this._titleW < this._subtitleW ? this._subtitleW + 10 : this._titleW + 10;
            this._w = this._minW;
            this._titleX = (this._minW - this._titleW) / 2;
            this._subtitleX = (this._minW - this._subtitleW) / 2;
        }
    }

    public void activate() {
        this._active = true;
    }

    public void deactivate() {
        this._active = false;
    }

    public boolean handleKeyDown(int key) {
        return false;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    protected void paintBackground(Graphics g, int x, int y) {
        if (this._active) {
            g.setColor(this._backgroundColor);
            g.fillRect(this._x + x, this._y + y, this._w, this._h);
            g.setColor(this._borderColor);
            g.drawRect(this._x + x, this._y + y, this._w, this._h);
        } else {
            g.setColor(this._inactiveBackgroundColor);
            g.fillRect(this._x + x, this._y + y, this._w, this._h);
            g.setColor(this._borderColor);
            g.drawRect(this._x + x, this._y + y, this._w, this._h);
            g.setColor(this._inactiveColor);
        }
    }

    public void paint(Graphics g, int x, int y) {
        this.paintBackground(g, x, y);
        if (this._active) {
            g.setColor(this._activeColor);
            g.setFont(this._font1);
            g.drawString(UI.getString(this._title), x + this._x + this._titleX, y + this._y + 4, 0);
            if (this._subtitle > 0) {
                if (this._font2 != null) {
                    g.setFont(this._font2);
                }
                g.drawString(UI.getString(this._subtitle), x + this._x + this._subtitleX, y + this._y + this._subtitleY, 0);
            }
        } else {
            g.setColor(this._inactiveColor);
            g.setFont(this._font1);
            g.drawString(UI.getString(this._title), x + this._x + this._titleX, y + this._y + 4, 0);
            if (this._subtitle > 0) {
                if (this._font2 != null) {
                    g.setFont(this._font2);
                }
                g.drawString(UI.getString(this._subtitle), x + this._x + this._subtitleX, y + this._y + this._subtitleY, 0);
            }
        }
    }

    public void setDimensions(int w, int h) {
        super.setDimensions(w, h);
        this._titleX = (this._w - this._titleW) / 2;
        this._subtitleX = (this._w - this._subtitleW) / 2;
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public void setFont(Font f) {
    }

    public boolean setSkin(String s) {
        return false;
    }

    public void update() {
    }

    public void select() {
        this._parent.widgetEvent(this._id, Integer.MIN_VALUE);
    }

    public void reCenter() {
    }
}

