/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.map.MapLV2;

import com.loboltd.javamap.map.MapLV2.MapBlock;
import com.loboltd.javamap.map.MapLV2.MapBlockLoader;
import com.loboltd.javamap.map.MapLV2.MapIndexer;
import com.loboltd.javamap.util.DataLoader;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class MapBlockMgr {
    private int halfScreenWidth;
    private int halfScreenHeight;
    private int mapBlockWidth;
    private int mapBlockHeight;
    private int maxBlockX;
    private int maxBlockY;
    private String area;
    private Hashtable imageBuff;
    private Hashtable preImageBuff;
    private MapIndexer mapIndexer;
    private int lv;
    private Vector loadingThreads = new Vector();

    public MapBlockMgr(String area, int lv) {
        this.imageBuff = new Hashtable(4);
        this.preImageBuff = new Hashtable(4);
        this.area = area;
        this.lv = lv;
        this.mapIndexer = this.getMapIndexer();
    }

    public MapBlock[] getMapBlocks(int x, int y) {
        int halfScreenX = this.halfScreenWidth;
        int westBlock = this.getMapBlockX(x - halfScreenX);
        int eastBlock = this.getMapBlockX(x + halfScreenX);
        int halfScreenY = this.halfScreenHeight;
        int northBlock = this.getMapBlockY(y - halfScreenY);
        int southBlock = this.getMapBlockY(y + halfScreenY);
        int xCount = westBlock == eastBlock ? 1 : 2;
        int yCount = northBlock == southBlock ? 1 : 2;
        int westBlockX = (westBlock - 1) * this.mapBlockWidth;
        int northBlockY = (northBlock - 1) * this.mapBlockHeight;
        int eastBlockX = westBlockX + this.mapBlockWidth;
        int southBlockY = northBlockY + this.mapBlockHeight;
        Hashtable imageBuff = this.imageBuff;
        Image N_WBlockImage = (Image)imageBuff.get(String.valueOf(westBlock) + "_" + northBlock);
        Image N_EBlockImage = (Image)imageBuff.get(String.valueOf(eastBlock) + "_" + northBlock);
        Image S_WBlockImage = (Image)imageBuff.get(String.valueOf(westBlock) + "_" + southBlock);
        Image S_EBlockImage = (Image)imageBuff.get(String.valueOf(eastBlock) + "_" + southBlock);
        imageBuff.clear();
        MapBlock[] mapBlocks = new MapBlock[xCount * yCount];
        if (xCount == 1) {
            mapBlocks[0] = new MapBlock();
            mapBlocks[0].setCoordinateX(westBlockX);
            mapBlocks[0].setCoordinateY(northBlockY);
            if (N_WBlockImage == null) {
                N_WBlockImage = this.loadImage(westBlock, northBlock);
            }
            imageBuff.put(String.valueOf(westBlock) + "_" + northBlock, N_WBlockImage);
            mapBlocks[0].setImage(N_WBlockImage);
            if (yCount == 2) {
                mapBlocks[1] = new MapBlock();
                mapBlocks[1].setCoordinateX(westBlockX);
                mapBlocks[1].setCoordinateY(southBlockY);
                if (S_WBlockImage == null) {
                    S_WBlockImage = this.loadImage(westBlock, southBlock);
                }
                imageBuff.put(String.valueOf(westBlock) + "_" + southBlock, S_WBlockImage);
                mapBlocks[1].setImage(S_WBlockImage);
            }
        } else {
            mapBlocks[0] = new MapBlock();
            mapBlocks[0].setCoordinateX(westBlockX);
            mapBlocks[0].setCoordinateY(northBlockY);
            if (N_WBlockImage == null) {
                N_WBlockImage = this.loadImage(westBlock, northBlock);
            }
            imageBuff.put(String.valueOf(westBlock) + "_" + northBlock, N_WBlockImage);
            mapBlocks[0].setImage(N_WBlockImage);
            mapBlocks[1] = new MapBlock();
            mapBlocks[1].setCoordinateX(eastBlockX);
            mapBlocks[1].setCoordinateY(northBlockY);
            if (N_EBlockImage == null) {
                N_EBlockImage = this.loadImage(eastBlock, northBlock);
            }
            imageBuff.put(String.valueOf(eastBlock) + "_" + northBlock, N_EBlockImage);
            mapBlocks[1].setImage(N_EBlockImage);
            if (yCount == 2) {
                mapBlocks[2] = new MapBlock();
                mapBlocks[2].setCoordinateX(westBlockX);
                mapBlocks[2].setCoordinateY(southBlockY);
                if (S_WBlockImage == null) {
                    S_WBlockImage = this.loadImage(westBlock, southBlock);
                }
                imageBuff.put(String.valueOf(westBlock) + "_" + southBlock, S_WBlockImage);
                mapBlocks[2].setImage(S_WBlockImage);
                mapBlocks[3] = new MapBlock();
                mapBlocks[3].setCoordinateX(eastBlockX);
                mapBlocks[3].setCoordinateY(southBlockY);
                if (S_EBlockImage == null) {
                    S_EBlockImage = this.loadImage(eastBlock, southBlock);
                }
                imageBuff.put(String.valueOf(eastBlock) + "_" + southBlock, S_EBlockImage);
                mapBlocks[3].setImage(S_EBlockImage);
            }
        }
        return mapBlocks;
    }

    public void getMapDataBlocks(int x, int y) {
        int halfScreenX = this.halfScreenWidth;
        int westBlock = this.getMapBlockX(x - halfScreenX);
        int eastBlock = this.getMapBlockX(x + halfScreenX);
        int halfScreenY = this.halfScreenHeight;
        int northBlock = this.getMapBlockY(y - halfScreenY);
        int southBlock = this.getMapBlockY(y + halfScreenY);
        System.out.println(String.valueOf(westBlock) + "_" + northBlock);
        System.out.println(String.valueOf(eastBlock) + "_" + northBlock);
        System.out.println(String.valueOf(westBlock) + "_" + southBlock);
        System.out.println(String.valueOf(eastBlock) + "_" + southBlock);
    }

    private Image loadImage(int blockIndexX, int blockIndexY) {
        Object obj;
        String fileName = String.valueOf(blockIndexX) + "_" + blockIndexY;
        if (this.preImageBuff.containsKey(fileName) && (obj = this.preImageBuff.get(fileName)) instanceof Image) {
            return (Image)obj;
        }
        if (this.area == null) {
            throw new RuntimeException("The type is not setted!");
        }
        String x = String.valueOf(blockIndexX);
        while (x.length() < 3) {
            x = "0" + x;
        }
        String y = String.valueOf(blockIndexY);
        while (y.length() < 3) {
            y = "0" + y;
        }
        MapIndexer indexer = this.getMapIndexer();
        char type = indexer.checkType((blockIndexX - 1) * this.maxBlockY + blockIndexY - 1);
        String path = null;
        switch (type) {
            case 'S': {
                path = "IMAGES/sea.map";
                break;
            }
            case 'L': {
                path = "IMAGES/land.map";
                break;
            }
            case '#': {
                path = "IMAGES/" + this.area + "/" + this.lv + "/" + x + "/" + x + "_" + y + ".map";
            }
        }
        Image image = null;
        if (path != null) {
            image = ((DataLoader)DataLoader.getInstance()).loadImage(path);
        }
        return image;
    }

    private int getMapBlockX(int x) {
        if (x == 0) {
            return 1;
        }
        int block = x / this.mapBlockWidth + (x % this.mapBlockWidth == 0 ? 0 : 1);
        if (block > this.maxBlockX) {
            return this.maxBlockX;
        }
        return block;
    }

    private int getMapBlockY(int y) {
        if (y == 0) {
            return 1;
        }
        int block = y / this.mapBlockHeight + (y % this.mapBlockHeight == 0 ? 0 : 1);
        if (block > this.maxBlockY) {
            return this.maxBlockY;
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapIndexer getMapIndexer() {
        MapBlockMgr mapBlockMgr = this;
        synchronized (mapBlockMgr) {
            if (this.mapIndexer == null) {
                if (this.area == null) {
                    throw new RuntimeException(this.getClass() + "-The type is not setted!");
                }
                this.mapIndexer = new MapIndexer("/IMAGES/" + this.area + "/" + this.lv + "/mapIndex.txt");
            }
        }
        return this.mapIndexer;
    }

    public int getMaxBlockX() {
        return this.maxBlockX;
    }

    public int getMaxBlockY() {
        return this.maxBlockY;
    }

    public void setMaxBlockX(int maxBlockX) {
        this.maxBlockX = maxBlockX;
    }

    public void setMaxBlockY(int maxBlockY) {
        this.maxBlockY = maxBlockY;
    }

    public int getMaxMapHeight() {
        return this.maxBlockY * this.mapBlockHeight;
    }

    public int getMaxMapWidth() {
        return this.maxBlockX * this.mapBlockWidth;
    }

    public void setScreenWidth(int screenWidth) {
        this.halfScreenWidth = screenWidth / 2;
    }

    public void setScreenHeight(int screenHeight) {
        this.halfScreenHeight = screenHeight / 2;
    }

    public void clearData() {
        if (this.imageBuff != null) {
            this.imageBuff.clear();
        }
        if (this.preImageBuff != null) {
            this.preImageBuff.clear();
        }
        Runtime.getRuntime().gc();
    }

    public void loading(int x, int y) {
        int blockX = this.getMapBlockX(x);
        int blockY = this.getMapBlockY(y);
        String fileName = String.valueOf(blockX) + "_" + blockY;
        if (this.imageBuff.containsKey(fileName)) {
            return;
        }
        if (this.preImageBuff.containsKey(fileName)) {
            return;
        }
        if (this.preImageBuff.size() > 4) {
            this.preImageBuff.clear();
            int i = 0;
            while (i < this.loadingThreads.size()) {
                MapBlockLoader mbl = (MapBlockLoader)this.loadingThreads.elementAt(i);
                mbl.setStoped(true);
                ++i;
            }
            this.loadingThreads.removeAllElements();
            System.gc();
        }
        char type = this.mapIndexer.checkType((blockX - 1) * this.maxBlockY + blockY - 1);
        switch (type) {
            case 'S': {
                return;
            }
            case 'L': {
                return;
            }
        }
        String xStr = String.valueOf(blockX);
        while (xStr.length() < 3) {
            xStr = "0" + xStr;
        }
        String yStr = String.valueOf(blockY);
        while (yStr.length() < 3) {
            yStr = "0" + yStr;
        }
        String path = "IMAGES/" + this.area + "/" + this.lv + "/" + xStr + "/" + xStr + "_" + yStr + ".map";
        MapBlockLoader mapBlockLoader = new MapBlockLoader();
        this.loadingThreads.addElement(mapBlockLoader);
        mapBlockLoader.setImageBuff(this.preImageBuff);
        mapBlockLoader.loading(fileName, path);
    }

    public int getMapBlockWidth() {
        return this.mapBlockWidth;
    }

    public int getMapBlockHeight() {
        return this.mapBlockHeight;
    }

    public void setMapBlockWidth(int mapBlockWidth) {
        this.mapBlockWidth = mapBlockWidth;
    }

    public void setMapBlockHeight(int mapBlockHeight) {
        this.mapBlockHeight = mapBlockHeight;
    }

    public static void main(String[] args) {
        MapBlockMgr mgr = new MapBlockMgr("HK", 3);
        mgr.setMapBlockWidth(400);
        mgr.setMapBlockHeight(400);
        mgr.setScreenWidth(200);
        mgr.setScreenHeight(300);
        mgr.setMaxBlockX(4);
        mgr.setMaxBlockY(4);
        mgr.getMapDataBlocks(1000, 1000);
    }
}

