/*
 * Decompiled with CFR 0.152.
 */
package actions.mapActions;

import com.loboltd.javamap.action.cmd.GotoMapAction;
import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV2.MapLV2Canvas;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.DataPool;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import net.kbox.Action;
import net.kbox.ActionForward;
import net.kbox.component.KCommand;
import search.Address;
import search.HSBCSearcher;

public class OriginAction
implements Action {
    public void execute(KCommand cmd, Item item, Displayable dis, ActionForward forward, Hashtable parameters) throws Exception {
        Object pObject = DataPool.getAttribute("firstPoint");
        if (pObject == null) {
            String msg = "[ERROR]Null firstPoint in GotoMapAction:\n";
            throw new NullPointerException(msg);
        }
        Point p = (Point)pObject;
        double ln1 = ((MapCanvas)dis).getCurrentLn();
        double lat1 = ((MapCanvas)dis).getCurrentLat();
        double ln2 = p.getLn();
        double lat2 = p.getLat();
        double lnStep = (ln2 - ln1) / 20.0;
        double latStep = (lat2 - lat1) / 20.0;
        MapCanvas mc = (MapCanvas)dis;
        final Vector buildings = mc.getShowOnMap();
        mc.setShowOnMap(null);
        int i = 0;
        while (i < 10) {
            mc.showMapBy84(ln1 += lnStep, lat1 += latStep);
            ++i;
        }
        if (mc.getLV() == 3) {
            final MapLV2Canvas mcl2 = (MapLV2Canvas)mc;
            Thread t = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1.toString());
                    }
                    Address[] as = new HSBCSearcher().searchAddressByCoordinate(mcl2.getCurrentLn(), mcl2.getCurrentLat(), 0.0036);
                    Vector<Address> showOnMap = new Vector<Address>();
                    if (as != null) {
                        int i = 0;
                        while (i < as.length) {
                            Address building = new Address();
                            building.setName(as[i].getName());
                            building.setAddress(as[i].getAddress());
                            building.setLat(as[i].getLat());
                            building.setLn(as[i].getLn());
                            building.setAddressId(as[i].getAddressId());
                            showOnMap.addElement(building);
                            ++i;
                        }
                        mcl2.setShowOnMap(showOnMap);
                    } else {
                        mcl2.setShowOnMap(buildings);
                    }
                    double currentLn = mcl2.getCurrentLn();
                    double currentLat = mcl2.getCurrentLat();
                    Vector buildings2 = mcl2.getShowOnMap();
                    if (buildings2 != null) {
                        Vector<Integer> selectedBuildingIndexs = new Vector<Integer>();
                        int i = 0;
                        while (i < buildings2.size()) {
                            Building building = (Building)buildings2.elementAt(i);
                            double addLn = Math.abs(building.getLn() - currentLn);
                            double addLat = Math.abs(building.getLat() - currentLat);
                            if (addLn < 4.5E-5 && addLat < 4.5E-5) {
                                selectedBuildingIndexs.addElement(new Integer(i));
                            }
                            ++i;
                        }
                        mcl2.setSelectedBuildingIndex(selectedBuildingIndexs);
                    }
                    try {
                        mcl2.reflash();
                    }
                    catch (NullAreaException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            };
            DataPool.setAttribute("LoadingBuildingThread", t);
            t.setPriority(1);
            t.start();
        }
        mc.setShowOnMap(buildings);
        Hashtable<String, Point> parametersOfOrigin = new Hashtable<String, Point>();
        parametersOfOrigin.put("point", p);
        parametersOfOrigin.put("mapCanvas", (Point)dis);
        cmd.setParameters(parametersOfOrigin);
        new GotoMapAction().execute(cmd, null, dis, forward, null);
    }
}

