/*
 * Decompiled with CFR 0.152.
 */
package search;

import java.util.Vector;
import query.QueryFactoryOfPromotion;
import query.QueryPromotion2;
import search.Address;
import search.HSBCSearcher;
import search.Promotion;
import search.Searcher;

public class HSBCSearcher2
implements Searcher {
    protected String district;
    protected String lang;

    public HSBCSearcher2() {
        this.district = "HK";
        this.lang = "EN";
    }

    public HSBCSearcher2(String district, String lang) {
        this.district = district;
        this.lang = lang;
    }

    public Promotion[] searchPromotionByKeyWord(String keyword) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setKeyWord(keyword);
        Vector v = qp.findFile(keyword);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector promotions = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            qp.searchPromotionByKeyword((String)fileNames[i], promotions);
            ++i;
        }
        if (promotions.size() == 0) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i2 = 0;
        while (i2 < promotion.length) {
            ++i2;
        }
        promotions.removeAllElements();
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionByFulName(String keyword) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setKeyWord(keyword);
        Vector promotions = new Vector();
        String fileName = "0001";
        if (qp.searchPromotionByName(fileName, promotions) == 0) {
            return null;
        }
        Promotion[] promotion = new Promotion[promotions.size()];
        int i = 0;
        while (i < promotion.length) {
            promotion[i] = (Promotion)promotions.elementAt(i);
            ++i;
        }
        return promotion;
    }

    public Promotion[] searchPromotionByCoordinate(double ln, double lat) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setLn(ln);
        qp.setLat(lat);
        String fileName = "0001";
        String[] addressIds = qp.getAddressIdsByCoordinate(fileName);
        if (addressIds == null) {
            return null;
        }
        String[] promotionIds = qp.getPromotionIdsByAddressIds(fileName, addressIds);
        if (promotionIds == null) {
            return null;
        }
        Vector promotions = new Vector();
        qp.searchPromotionByPromotionIds(fileName, promotions, promotionIds);
        if (promotions.size() == 0) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i = 0;
        while (i < promotion.length) {
            ++i;
        }
        addressIds = null;
        promotionIds = null;
        promotions.removeAllElements();
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionByCoordinates(double ltln, double ltlat, double rbln, double rblat) {
        String fileName;
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        String[] addressIds = qp.getAddressIdsByCoordinates(fileName = "0001", ltln, ltlat, rbln, rblat);
        if (addressIds == null) {
            return null;
        }
        String[] promotionIds = qp.getPromotionIdsByAddressIds(fileName, addressIds);
        if (promotionIds == null) {
            return null;
        }
        Vector promotions = new Vector();
        qp.searchPromotionByPromotionIds(fileName, promotions, promotionIds);
        if (promotions.size() == 0) {
            return null;
        }
        Promotion[] promotion = new Promotion[promotions.size()];
        int i = 0;
        while (i < promotion.length) {
            promotion[i] = (Promotion)promotions.elementAt(i);
            ++i;
        }
        addressIds = null;
        promotionIds = null;
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionByFoodType(String foodType) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = qp.findFoodTypeFile(foodType);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector promotions = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            qp.searchPromotionByFoodType((String)fileNames[i], promotions);
            ++i;
        }
        if (promotions == null) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i2 = 0;
        while (i2 < promotion.length) {
            ++i2;
        }
        v.removeAllElements();
        v = null;
        promotions.removeAllElements();
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionByDistrict(String mainDistrict, String subDistrict) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = qp.findProDistrictFile(mainDistrict);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector promotions = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            if (subDistrict.equals("\u5168\u90e8") || subDistrict.equals("ALL")) {
                qp.searchPromotionByMainDistrict((String)fileNames[i], promotions);
            } else {
                qp.searchPromotionBySubDistrict((String)fileNames[i], promotions, subDistrict);
            }
            ++i;
        }
        if (promotions == null) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i2 = 0;
        while (i2 < promotion.length) {
            ++i2;
        }
        promotions.removeAllElements();
        promotions = null;
        v.removeAllElements();
        v = null;
        fileNames = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionByPromotionIds(String[] promotionIds) {
        Vector promotions;
        String fileName;
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        if (qp.searchPromotionByPromotionIds(fileName = "0001", promotions = new Vector(), promotionIds) == 0) {
            return null;
        }
        Promotion[] promotion = new Promotion[promotions.size()];
        int i = 0;
        while (i < promotion.length) {
            promotion[i] = (Promotion)promotions.elementAt(i);
            ++i;
        }
        return promotion;
    }

    public Promotion[] searchPromotionByAddressId(String addressId) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = qp.findRTOPFile(addressId);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector promotions = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            qp.searchPromotionByAddressId((String)fileNames[i], promotions, addressId);
            ++i;
        }
        if (promotions.size() == 0) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i2 = 0;
        while (i2 < promotion.length) {
            ++i2;
        }
        v.removeAllElements();
        v = null;
        promotions.removeAllElements();
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionByAddressIds(String[] addressIds) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = new Vector();
        qp.findRTOPFiles(addressIds, v);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector promotions = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            qp.searchPromotionByAddressIds((String)fileNames[i], promotions, addressIds);
            ++i;
        }
        if (promotions.size() == 0) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i2 = 0;
        while (i2 < promotion.length) {
            ++i2;
        }
        v.removeAllElements();
        v = null;
        promotions.removeAllElements();
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Promotion[] searchPromotionDetailByPromotionIds(String promotionId) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = qp.findDetailFile(promotionId);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector promotions = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            qp.searchPromotionDetailByPromotionId((String)fileNames[i], promotions, promotionId);
            ++i;
        }
        if (promotions.size() == 0) {
            return null;
        }
        Object[] promotion = new Promotion[promotions.size()];
        promotions.copyInto(promotion);
        int i2 = 0;
        while (i2 < promotion.length) {
            ++i2;
        }
        v.removeAllElements();
        v = null;
        promotions.removeAllElements();
        promotions = null;
        Runtime.getRuntime().gc();
        return promotion;
    }

    public Address[] searchAddressByCoordinate(double ln, double lat, double offset) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setLn(ln);
        qp.setLat(lat);
        String fileName = "0001";
        Vector addresses = new Vector();
        if (qp.searchNearByAddressByCoordinate(fileName, addresses, offset) == 0) {
            return null;
        }
        Object[] address = new Address[addresses.size()];
        addresses.copyInto(address);
        int i = 0;
        while (i < address.length) {
            ++i;
        }
        addresses.removeAllElements();
        addresses = null;
        Runtime.getRuntime().gc();
        return address;
    }

    public Address[] searchAddressByDistrict(String mainDistrict, String subDistrict) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = qp.findRstDistrictFile(mainDistrict);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector addresses = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            if (subDistrict.equals("\u5168\u90e8") || subDistrict.equals("ALL")) {
                qp.searchAddressByMainDistrict((String)fileNames[i], addresses);
            } else {
                qp.searchAddressBySubDistrict((String)fileNames[i], addresses, subDistrict);
            }
            ++i;
        }
        if (addresses == null) {
            return null;
        }
        Object[] address = new Address[addresses.size()];
        addresses.copyInto(address);
        int i2 = 0;
        while (i2 < address.length) {
            ++i2;
        }
        addresses.removeAllElements();
        addresses = null;
        v.removeAllElements();
        v = null;
        fileNames = null;
        Runtime.getRuntime().gc();
        return address;
    }

    public Address[] searchAddressBypromotionId(String promotionId) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        Vector v = qp.findPTORFile(promotionId);
        Object[] fileNames = new String[v.size()];
        v.copyInto(fileNames);
        Vector addresses = new Vector();
        int i = 0;
        while (i < fileNames.length) {
            qp.searchAddressByPromotionId((String)fileNames[i], addresses, promotionId);
            ++i;
        }
        if (addresses.size() == 0) {
            return null;
        }
        Object[] address = new Address[addresses.size()];
        addresses.copyInto(address);
        int i2 = 0;
        while (i2 < address.length) {
            ++i2;
        }
        v.removeAllElements();
        v = null;
        addresses.removeAllElements();
        addresses = null;
        Runtime.getRuntime().gc();
        return address;
    }

    public Address[] searchAddressByAddressIds(String[] addressIds) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setDistrict(this.district);
        String fileName = "0001";
        Vector addresses = new Vector();
        if (qp.searchAddressByAddressIds(fileName, addresses, addressIds) == 0) {
            return null;
        }
        Address[] address = new Address[addresses.size()];
        int i = 0;
        while (i < address.length) {
            address[i] = (Address)addresses.elementAt(i);
            ++i;
        }
        return address;
    }

    public String[] getAddressIdsByPromotionId(String promotionId) {
        String fileName;
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        String[] addresses = qp.getAddressIdsByPromotionId(fileName = "0001", promotionId);
        if (addresses == null) {
            addresses = new String[1];
        }
        return addresses;
    }

    public String[] getPromotionIdsByAddressId(String addressId) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        String fileName = "0001";
        String[] addresses = qp.getPromotionIdsByAddressId(fileName, addressId);
        return addresses;
    }

    public String[] getPromotionIdsByAddressIds(String[] addressIds) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        String fileName = "0001";
        String[] addresses = qp.getPromotionIdsByAddressIds(fileName, addressIds);
        return addresses;
    }

    public String getAddressIdByCoordinate(double ln, double lat) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setLn(ln);
        qp.setLat(lat);
        String fileName = "0001";
        String addressId = qp.getAddressIdByCoordinate(fileName);
        return addressId;
    }

    public String[] getAddressIdByDistrict(String district) {
        QueryPromotion2 qp = (QueryPromotion2)new QueryFactoryOfPromotion().createQuery(this.district, true, this.lang);
        qp.setDistrict(district);
        String fileName = "0001";
        String[] addressIds = qp.getAddressIdsByDistrict(fileName);
        int i = 0;
        while (i < addressIds.length) {
            ++i;
        }
        return addressIds;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public static void main(String[] args) {
        HSBCSearcher searcher = new HSBCSearcher();
        searcher.setDistrict("HK");
        searcher.setLang("CN");
        searcher.searchPromotionByFulName("\u80af\u5fb7\u57fa");
    }
}

