/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.Canvas;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public abstract class Dialog
extends Window {
    protected int _w;
    protected int _h;

    public Dialog(Canvas canvas, Window parent) {
        super(canvas, parent);
    }

    public void setDimensions(int w, int h) {
        this._w = w;
        this._h = h;
        for (int i = 0; i < this._widgets.size(); ++i) {
            Widget widget = (Widget)this._widgets.elementAt(i);
            widget._parent._w = this._w;
            widget.adjustWidth();
        }
    }

    public void moveDialog(int x, int y) {
        this._x = x;
        this._y = y;
    }

    protected void drawBackground(Graphics g, int x, int y) {
        g.setColor(0xFFFFFF);
        g.fillRect(this._x + x, this._y + y, this._w, this._h);
        g.setColor(0);
        g.drawRect(this._x + x, this._y + y, this._w, this._h);
        g.setClip(this._x + x, this._y + y, this._w, this._h);
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public int width() {
        return this._w;
    }

    public boolean handleKeyDown(int key) {
        if (key == -7) {
            if (this._parent != null) {
                Canvas.setActiveWindow(this._parent);
                return true;
            }
        } else if (key == -3 || key == -4) {
            return true;
        }
        return super.handleKeyDown(key);
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    public void handlePointerDown(int x, int y) {
    }

    public void paint(Graphics g) {
        this.paint(g, true);
    }

    public void paint(Graphics g, boolean drawParent) {
        if (this._parent != null && drawParent) {
            this._parent.paint(g);
            g.setClip(0, 0, UI.SCREEN_WIDTH, UI.SCREEN_HEIGHT);
            this.drawBackground(g, this._x, this._y);
            for (int i = 0; i < this._widgets.size(); ++i) {
                ((Widget)this._widgets.elementAt(i)).paint(g, this._x, this._y);
            }
        } else {
            g.setClip(0, 0, UI.SCREEN_WIDTH, UI.SCREEN_HEIGHT);
            this.drawBackground(g, this._x, this._y);
            for (int i = 0; i < this._widgets.size(); ++i) {
                ((Widget)this._widgets.elementAt(i)).paint(g, this._x, this._y);
            }
        }
    }

    public abstract void activate();

    public abstract void languageUpdate();
}

