/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Displayable;

class PlayerProfile {
    static int NUM_PROFILES = 2;
    static final int PROFILE_ID_1 = 0;
    static final int PROFILE_ID_2 = 1;
    static final int PROFILE_ID_3 = 2;
    static String[] profileName = new String[NUM_PROFILES];
    static String[] profileOnlineSerialKey = new String[NUM_PROFILES];
    public static int[] gamesPlayed = new int[NUM_PROFILES];
    public static int[] totalWins = new int[NUM_PROFILES];
    public static int[] totalCash = new int[NUM_PROFILES];
    public static int[] correctQuestionsInRow = new int[NUM_PROFILES];
    public static int[] highestScoreEarned = new int[NUM_PROFILES];
    public static int[] totalScore = new int[NUM_PROFILES];
    public static int[] averageTimePerQuestion = new int[NUM_PROFILES];
    public static int[] averageCashPerGame = new int[NUM_PROFILES];
    public static int[] totalMoneyForfeited = new int[NUM_PROFILES];
    public static int[] highestScoreFastestFingerFirstRound = new int[NUM_PROFILES];
    public static int[] currAnswerTime = new int[NUM_PROFILES];
    public static int[] correctAnswersInRow = new int[NUM_PROFILES];
    public static int currProfile = 0;
    public static MenuStage profileForm;

    PlayerProfile() {
        NUM_PROFILES = 2;
    }

    public static void loadProfilesFromRMS() {
        try {
            byte[] byArray = Engine.readBytes(Engine.text[122] + "profiles");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            PlayerProfile.loadAllProfilesFromRMS(dataInputStream);
            dataInputStream.close();
            byteArrayInputStream.close();
            dataInputStream = null;
            byteArrayInputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveProfilesToRMS() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            PlayerProfile.saveAllProfilesToRMS(dataOutputStream);
            Engine.writeBytes(Engine.text[122] + "profiles", byteArrayOutputStream.toByteArray());
            dataOutputStream.close();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadAllProfilesFromRMS(DataInputStream dataInputStream) {
        try {
            currProfile = dataInputStream.readInt();
            for (int i = 0; i < NUM_PROFILES; ++i) {
                PlayerProfile.profileName[i] = dataInputStream.readUTF();
                PlayerProfile.profileOnlineSerialKey[i] = dataInputStream.readUTF();
                PlayerProfile.gamesPlayed[i] = dataInputStream.readInt();
                PlayerProfile.totalWins[i] = dataInputStream.readInt();
                PlayerProfile.totalCash[i] = dataInputStream.readInt();
                PlayerProfile.correctQuestionsInRow[i] = dataInputStream.readInt();
                PlayerProfile.highestScoreEarned[i] = dataInputStream.readInt();
                PlayerProfile.totalScore[i] = dataInputStream.readInt();
                PlayerProfile.averageTimePerQuestion[i] = dataInputStream.readInt();
                PlayerProfile.averageCashPerGame[i] = dataInputStream.readInt();
                PlayerProfile.totalMoneyForfeited[i] = dataInputStream.readInt();
                PlayerProfile.highestScoreFastestFingerFirstRound[i] = dataInputStream.readInt();
                PlayerProfile.correctAnswersInRow[i] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeProfileToDataStream(int n, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeUTF(profileName[n]);
            dataOutputStream.writeUTF(profileOnlineSerialKey[n]);
            dataOutputStream.writeInt(gamesPlayed[n]);
            dataOutputStream.writeInt(totalWins[n]);
            dataOutputStream.writeInt(totalCash[n]);
            dataOutputStream.writeInt(correctQuestionsInRow[n]);
            dataOutputStream.writeInt(highestScoreEarned[n]);
            dataOutputStream.writeInt(totalScore[n]);
            dataOutputStream.writeInt(averageTimePerQuestion[n]);
            if (gamesPlayed[n] != 0) {
                PlayerProfile.averageCashPerGame[n] = totalCash[n] / gamesPlayed[n];
            }
            dataOutputStream.writeInt(averageCashPerGame[n]);
            dataOutputStream.writeInt(totalMoneyForfeited[n]);
            dataOutputStream.writeInt(highestScoreFastestFingerFirstRound[n]);
            dataOutputStream.writeInt(correctAnswersInRow[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getProfileAsByteArray(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            PlayerProfile.writeProfileToDataStream(n, dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void saveAllProfilesToRMS(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(currProfile);
            for (int i = 0; i < NUM_PROFILES; ++i) {
                PlayerProfile.writeProfileToDataStream(i, dataOutputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String currProfileName() {
        return profileName[currProfile];
    }

    public static String currProfileShort() {
        return "" + currProfile;
    }

    public static void resetAllProfiles() {
        currProfile = 0;
        for (int i = 0; i < NUM_PROFILES; ++i) {
            PlayerProfile.resetProfile(i);
        }
    }

    public static void resetProfile(int n) {
        currProfile = n;
        Engine.deleteBytes(Engine.text[122] + "save" + PlayerProfile.currProfileName());
        PlayerProfile.profileName[PlayerProfile.currProfile] = Engine.text[192];
        PlayerProfile.profileOnlineSerialKey[PlayerProfile.currProfile] = "";
        PlayerProfile.gamesPlayed[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalWins[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalCash[PlayerProfile.currProfile] = 0;
        PlayerProfile.highestScoreEarned[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalScore[PlayerProfile.currProfile] = 0;
        PlayerProfile.averageCashPerGame[PlayerProfile.currProfile] = 0;
        PlayerProfile.highestScoreFastestFingerFirstRound[PlayerProfile.currProfile] = 0;
        PlayerProfile.averageTimePerQuestion[PlayerProfile.currProfile] = 1000;
        PlayerProfile.totalMoneyForfeited[PlayerProfile.currProfile] = 0;
        PlayerProfile.currAnswerTime[PlayerProfile.currProfile] = 0;
        PlayerProfile.correctQuestionsInRow[PlayerProfile.currProfile] = 0;
    }

    public static void showProfileForm(int n, MenuStage menuStage) {
        profileForm = new MenuStage(Main.instance.engine);
        String string = Engine.text[207] + "\n" + gamesPlayed[currProfile] + "\n" + Engine.text[208] + "\n" + totalWins[currProfile] + "\n" + Engine.text[209] + "\n" + Engine.text[47] + totalCash[currProfile] + "\n" + Engine.text[211] + "\n" + highestScoreEarned[currProfile] + "\n" + Engine.text[212] + "\n" + totalScore[currProfile] + "\n" + Engine.text[213] + "\n" + averageTimePerQuestion[currProfile] + " " + (averageTimePerQuestion[currProfile] == 1 ? Engine.text[228] : Engine.text[229]) + "\n" + Engine.text[214] + "\n" + Engine.text[47] + averageCashPerGame[currProfile] + "\n" + Engine.text[216] + "\n" + highestScoreFastestFingerFirstRound[currProfile];
        Engine cfr_ignored_0 = Main.instance.engine;
        profileForm.initTextBox(profileName[n], string, Engine.newStage);
        profileForm.setMenuAction((byte)0, false);
        profileForm.setCallback(menuStage, (Displayable)Main.instance.engine);
        Engine cfr_ignored_1 = Main.instance.engine;
        Engine.setCurrentGameStage(profileForm);
    }

    public static void showOnlineProfileForm(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            int n8 = dataInputStream.readInt();
            int n9 = dataInputStream.readInt();
            int n10 = dataInputStream.readInt();
            profileForm = new MenuStage(Main.instance.engine);
            String string3 = Engine.text[207] + "\n" + n + "\n" + Engine.text[208] + "\n" + n2 + "\n" + Engine.text[209] + "\n" + Engine.text[47] + n3 + "\n" + Engine.text[211] + "\n" + n5 + "\n" + Engine.text[212] + "\n" + n6 + "\n" + Engine.text[213] + "\n" + n7 + " " + (n7 == 1 ? Engine.text[228] : Engine.text[229]) + "\n" + Engine.text[214] + "\n" + Engine.text[47] + n8 + "\n" + Engine.text[216] + "\n" + n10;
            Engine cfr_ignored_0 = Main.instance.engine;
            profileForm.initTextBox(string, string3, Engine.newStage);
            profileForm.setMenuAction((byte)0, false);
            Engine cfr_ignored_1 = Main.instance.engine;
            profileForm.setCallback(Engine.downloadedProfileListMenu, (Displayable)Main.instance.engine);
            Engine cfr_ignored_2 = Main.instance.engine;
            Engine.setCurrentGameStage(profileForm);
            Engine.state = 100;
            dataInputStream.close();
            byteArrayInputStream.close();
            dataInputStream = null;
            byteArrayInputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

