/*
 * Decompiled with CFR 0.152.
 */
public class S3dObject {
    S3dResource resource;
    S3dTransform xform;
    boolean inUse = false;
    public int depth;
    private static S3dObject[] cache;
    private static int nextCacheID;
    private static int numUsedCacheSlots;
    private static int highestUsedCacheSlots;

    public static S3dObject create() {
        int n;
        for (n = nextCacheID; n < cache.length; ++n) {
            if (S3dObject.cache[n].inUse) continue;
            S3dObject.cache[n].inUse = true;
            nextCacheID = n + 1;
            return cache[n];
        }
        for (n = 0; n < nextCacheID; ++n) {
            if (S3dObject.cache[n].inUse) continue;
            S3dObject.cache[n].inUse = true;
            nextCacheID = n + 1;
            return cache[n];
        }
        return null;
    }

    public static void release() {
        for (int i = 0; i < cache.length; ++i) {
            S3dObject.cache[i].inUse = false;
        }
        nextCacheID = 0;
    }

    public static void createCache(int n) {
        cache = new S3dObject[n];
        for (int i = 0; i < cache.length; ++i) {
            S3dObject.cache[i] = new S3dObject();
        }
    }

    public void destroy() {
        this.resource = null;
        this.xform = null;
        this.inUse = false;
    }

    public static String getReportStats() {
        return "";
    }

    public S3dObject() {
    }

    public S3dObject(S3dResource s3dResource, S3dTransform s3dTransform) {
        this();
        this.xform = s3dTransform;
        this.resource = s3dResource;
    }

    public void paint3D() {
        this.resource.paint3D(this.xform);
    }

    public void paint3D(S3dTransform s3dTransform) {
        this.resource.paint3D(s3dTransform);
    }

    public void paint3DMesh(S3dTransform s3dTransform) {
        S3dResource.paint3DMesh(this.resource, s3dTransform);
    }

    public void paint3DMesh() {
        S3dResource.paint3DMesh(this.resource, this.xform);
    }
}

