/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LinkedText {
    private String text;
    private Image textImage;
    private Vector links;
    private int selectedLink = -1;
    private Vector cutVec;
    private int rowHeight = 0;
    private int actualWidth = 0;
    private String tokens = " \u00a4%\u00a3$\u20ac{[]}\\;^\"";
    private String userTokens = ":/?&#$-.+!*'(),";

    public LinkedText(String text, int textColor, int selectionColor, int selectedTextColor, int size, int width, int maxLines, boolean centered, boolean arabic, boolean atLinks) {
        int A;
        int i;
        int j;
        this.text = text;
        this.cleanText();
        this.findLinks(atLinks);
        Font f = Font.getFont((int)64, (int)0, (int)size);
        if (maxLines == 1 && f.stringWidth(this.text) > 2 * width) {
            this.links.removeAllElements();
            int index = this.text.length() - 1;
            while (f.stringWidth(this.text.substring(0, index) + "...") > 2 * width) {
                --index;
            }
            this.text = this.text.substring(0, index) + "...";
        }
        this.cutVec = new Vector(10, 10);
        String[] textLines = this.splitText(this.text, 2 * width, f, false);
        if (maxLines == -1 || textLines.length < maxLines) {
            maxLines = textLines.length;
        }
        this.cutVec.removeAllElements();
        this.cutVec = null;
        int cHeight = f.getHeight();
        if ((cHeight & 1) == 1) {
            ++cHeight;
        }
        int fh = cHeight * maxLines;
        int fw = 2 * width;
        boolean multi = false;
        if (this.links.size() != 0) {
            int[] startpositions = new int[maxLines];
            for (int i2 = 0; i2 < maxLines; ++i2) {
                startpositions[i2] = i2 == 0 ? 0 : startpositions[i2 - 1] + textLines[i2 - 1].length();
            }
            int index = 0;
            int row = 0;
            int prevLen = 0;
            for (int i3 = 0; i3 < this.links.size(); ++i3) {
                int xw;
                int j2;
                Link currentLink = (Link)this.links.elementAt(i3);
                index = this.text.indexOf(currentLink.link, index + prevLen);
                prevLen = currentLink.link.length();
                for (j2 = row; j2 < maxLines - 1 && index >= startpositions[j2 + 1]; ++j2) {
                }
                currentLink.row = j2;
                currentLink.pos = index - startpositions[j2];
                while (j2 < maxLines - 1 && index + currentLink.link.length() >= startpositions[j2 + 1]) {
                    ++j2;
                }
                currentLink.endrow = j2;
                currentLink.endpos = index + currentLink.link.length() - startpositions[j2];
                row = j2;
                if (currentLink.row == currentLink.endrow) {
                    currentLink.x = centered ? f.stringWidth(textLines[currentLink.row].substring(0, currentLink.pos)) + (fh - f.stringWidth(textLines[currentLink.row])) / 2 : (arabic ? f.stringWidth(textLines[currentLink.row].substring(0, currentLink.pos)) + (fh - f.stringWidth(textLines[currentLink.row])) : f.stringWidth(textLines[currentLink.row].substring(0, currentLink.pos)));
                    currentLink.y = cHeight * currentLink.row;
                    currentLink.height = cHeight;
                    currentLink.width = f.stringWidth(currentLink.link);
                    if ((currentLink.width & 1) != 1) continue;
                    ++currentLink.width;
                    continue;
                }
                multi = true;
                if (centered) {
                    xw = fh - f.stringWidth(textLines[currentLink.row]);
                    currentLink.x = f.stringWidth(textLines[currentLink.row].substring(0, currentLink.pos)) + xw / 2;
                    currentLink.x2 = f.stringWidth(textLines[currentLink.endrow].substring(0, currentLink.endpos)) + xw / 2;
                } else if (arabic) {
                    xw = fh - f.stringWidth(textLines[currentLink.row]);
                    currentLink.x = f.stringWidth(textLines[currentLink.row].substring(0, currentLink.pos)) + xw;
                    currentLink.x2 = f.stringWidth(textLines[currentLink.endrow].substring(0, currentLink.endpos)) + xw;
                } else {
                    currentLink.x = f.stringWidth(textLines[currentLink.row].substring(0, currentLink.pos));
                    currentLink.x2 = f.stringWidth(textLines[currentLink.endrow].substring(0, currentLink.endpos));
                }
                currentLink.y = cHeight * currentLink.row;
                currentLink.height = cHeight * (currentLink.endrow - currentLink.row + 1);
                currentLink.width = fw;
            }
        }
        if (centered) {
            this.actualWidth = fw / 2;
        } else {
            this.actualWidth = 0;
            for (int i4 = 0; i4 < maxLines; ++i4) {
                if (f.stringWidth(textLines[i4]) <= this.actualWidth) continue;
                this.actualWidth = f.stringWidth(textLines[i4]);
            }
            this.actualWidth /= 2;
        }
        int oh = fh;
        int ow = fw;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fw / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, ow, oh);
        g.setColor(0xFFFFFF);
        g.setFont(f);
        for (int i5 = 0; i5 < maxLines; ++i5) {
            g.drawString(textLines[i5], centered ? ow / 2 : (arabic ? ow : 0), cHeight * i5, centered ? 17 : (arabic ? 24 : 0));
        }
        if (this.links.size() > 0) {
            g.setColor(0);
            for (int i6 = 0; i6 < this.links.size(); ++i6) {
                Link currentLink = (Link)this.links.elementAt(i6);
                if (currentLink.row == currentLink.endrow) {
                    g.fillRect(currentLink.x, currentLink.y, currentLink.width, currentLink.height);
                    continue;
                }
                g.fillRect(currentLink.x, currentLink.y, ow - currentLink.x, cHeight);
                for (j = currentLink.row + 1; j < currentLink.endrow; ++j) {
                    g.fillRect(0, cHeight * j, fw, cHeight);
                }
                g.fillRect(0, cHeight * currentLink.endrow, currentLink.x2, cHeight);
            }
        }
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        j = 0;
        int l = nw - 1;
        textColor &= 0xFFFFFF;
        selectedTextColor &= 0xFFFFFF;
        for (i = 0; i < ns; ++i) {
            A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
            newimg[i] = (A <<= 24) | textColor;
            j += 2;
            if (i % nw != l) continue;
            j += ow;
        }
        this.textImage = Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (boolean)true);
        newimg = null;
        oldimg = null;
        if (this.links.size() > 0) {
            g.setColor(0);
            g.fillRect(0, 0, ow, oh);
            g.setColor(0xFFFFFF);
            f = Font.getFont((int)64, (int)4, (int)size);
            g.setFont(f);
            for (i = 0; i < maxLines; ++i) {
                g.drawString(textLines[i], centered ? ow / 2 : (arabic ? ow : 0), cHeight * i, centered ? 17 : (arabic ? 24 : 0));
            }
            Image img2 = null;
            Graphics g2 = null;
            if (multi) {
                img2 = Image.createImage((int)ow, (int)oh);
                g2 = img2.getGraphics();
            }
            for (int i7 = 0; i7 < this.links.size(); ++i7) {
                int B;
                int G;
                int R;
                int nsize;
                selectionColor &= 0xFFFFFF;
                Link currentLink = (Link)this.links.elementAt(i7);
                if (currentLink.row == currentLink.endrow) {
                    int width2 = currentLink.x;
                    if (currentLink.width + currentLink.x > img.getWidth()) {
                        width2 = img.getWidth() - currentLink.width;
                    }
                    int osize = currentLink.height * currentLink.width;
                    oldimg = new int[osize];
                    nsize = osize / 4;
                    img.getRGB(oldimg, 0, currentLink.width, width2, currentLink.y, currentLink.width, currentLink.height);
                    ow = currentLink.width;
                    newimg = new int[nsize];
                    currentLink.x /= 2;
                    currentLink.y /= 2;
                    currentLink.width /= 2;
                    currentLink.height /= 2;
                    j = 0;
                    nw = currentLink.width;
                    l = nw - 1;
                } else {
                    g2.drawImage(img, 0, 0, 0);
                    g2.setColor(0);
                    g2.fillRect(0, cHeight * currentLink.row, currentLink.x, cHeight);
                    g2.fillRect(currentLink.x2, cHeight * currentLink.endrow, fw - currentLink.x2, cHeight);
                    int osize = currentLink.height * currentLink.width;
                    nsize = osize / 4;
                    oldimg = new int[osize];
                    img2.getRGB(oldimg, 0, fw, 0, currentLink.y, currentLink.width, currentLink.height);
                    ow = currentLink.width;
                    newimg = new int[nsize];
                    currentLink.x /= 2;
                    currentLink.x2 /= 2;
                    currentLink.y /= 2;
                    currentLink.width /= 2;
                    currentLink.height /= 2;
                    j = 0;
                    nw = currentLink.width;
                    l = nw - 1;
                }
                for (int k = 0; k < nsize; ++k) {
                    A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
                    newimg[k] = (A <<= 24) | textColor;
                    j += 2;
                    if (k % nw != l) continue;
                    j += ow;
                }
                currentLink.unselectedImage = Image.createRGBImage((int[])newimg, (int)currentLink.width, (int)currentLink.height, (boolean)true);
                if (currentLink.row == currentLink.endrow) {
                    for (int k = 0; k < nsize; ++k) {
                        A = (newimg[k] & 0xFF000000) >>> 24;
                        R = ((selectedTextColor & 0xFF0000) >> 16) * A + (selectionColor >> 16) * (255 - A) >> 8 << 16;
                        G = ((selectedTextColor & 0xFF00) >> 8) * A + ((selectionColor & 0xFF00) >> 8) * (255 - A) >> 8 << 8;
                        B = (selectedTextColor & 0xFF) * A + (selectionColor & 0xFF) * (255 - A) >> 8;
                        newimg[k] = R | G | B;
                    }
                } else {
                    int ch = cHeight / 2;
                    int lines = nsize / nw;
                    for (int k = 0; k < nsize; ++k) {
                        if (k / nw < ch && k % nw < currentLink.x || k / nw >= lines - ch && k % nw > currentLink.x2) {
                            newimg[k] = 0;
                            continue;
                        }
                        A = (newimg[k] & 0xFF000000) >>> 24;
                        R = ((selectedTextColor & 0xFF0000) >> 16) * A + (selectionColor >> 16) * (255 - A) >> 8 << 16;
                        G = ((selectedTextColor & 0xFF00) >> 8) * A + ((selectionColor & 0xFF00) >> 8) * (255 - A) >> 8 << 8;
                        B = (selectedTextColor & 0xFF) * A + (selectionColor & 0xFF) * (255 - A) >> 8;
                        newimg[k] = 0xFF000000 | R | G | B;
                    }
                    currentLink.x = 0;
                }
                currentLink.selectedImage = Image.createRGBImage((int[])newimg, (int)currentLink.width, (int)currentLink.height, (currentLink.row != currentLink.endrow ? 1 : 0) != 0);
            }
        }
        this.rowHeight = cHeight / 2;
    }

    private void cleanText() {
        this.text = this.text.replace('\n', ' ');
        this.text = this.text.replace('\r', ' ');
        this.text = this.text.replace('\u2029', ' ');
        this.text = this.spaceClean(this.text);
    }

    private String spaceClean(String in) {
        StringBuffer sb = new StringBuffer(in.length());
        int lastChar = -1;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c != ' ' || lastChar != 32) {
                sb.append(c);
            }
            lastChar = c;
        }
        return sb.toString();
    }

    private void findLinks(boolean atLink) {
        this.links = new Vector(1, 1);
        boolean legalstart = true;
        boolean linkgrab = false;
        boolean _user = false;
        int linkstart = 0;
        int linkend = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (linkgrab) {
                if (this.tokens.indexOf(ch) < 0 && (!_user || this.userTokens.indexOf(ch) < 0) && (ch < '\u4e00' || ch > '\ua48f')) continue;
                linkgrab = false;
                linkend = i;
                legalstart = true;
                if (linkend <= linkstart + 1) continue;
                this.links.addElement(new Link(this.text.substring(linkstart, linkend)));
                continue;
            }
            if (legalstart) {
                if (ch == '@' && atLink && i + 1 < this.text.length() || i + 3 < this.text.length() && this.text.substring(i, i + 4).compareTo("www.") == 0 || i + 6 < this.text.length() && this.text.substring(i, i + 7).compareTo("http://") == 0) {
                    linkgrab = true;
                    linkstart = i;
                    _user = ch == '@';
                    continue;
                }
                if (this.tokens.indexOf(ch) >= 0 || _user && this.userTokens.indexOf(ch) >= 0 || ch >= '\u4e00' && ch <= '\ua48f') continue;
                legalstart = false;
                continue;
            }
            if (this.tokens.indexOf(ch) < 0 && (!_user || this.userTokens.indexOf(ch) < 0) && (ch < '\u4e00' || ch > '\ua48f')) continue;
            legalstart = true;
        }
        if (linkgrab) {
            linkend = this.text.length();
            this.links.addElement(new Link(this.text.substring(linkstart, linkend)));
        }
    }

    private String[] splitText(String s, int w, Font f, boolean continued) {
        int i;
        int t;
        if (!continued) {
            if (f.stringWidth(s) <= w) {
                String[] out = new String[]{s};
                return out;
            }
            this.cutVec.removeAllElements();
        }
        int b = 0;
        int space = f.stringWidth(" ");
        int p = s.indexOf(" ");
        if (p == -1 || p == s.length() - 1) {
            t = 0;
            for (i = 0; i <= s.length(); ++i) {
                if (f.stringWidth(s.substring(t, i)) <= w) continue;
                this.cutVec.addElement(s.substring(t, i - 1));
                t = i - 1;
            }
            this.cutVec.addElement(s.substring(t));
        } else {
            block1: while (b != -1) {
                String s2 = "";
                int currX = 0;
                while (true) {
                    if ((b = s.indexOf(" ")) == -1) {
                        t = f.stringWidth(s);
                        if (currX + t > w) {
                            if (currX == 0) {
                                this.splitText(s, w, f, true);
                                continue block1;
                            }
                            if (t > w) {
                                i = 0;
                                while (currX + f.stringWidth(s.substring(0, i)) < w) {
                                    ++i;
                                }
                                if (i < 2) {
                                    this.cutVec.addElement(s2);
                                    this.splitText(s, w, f, true);
                                    continue block1;
                                }
                                this.cutVec.addElement(s2 + s.substring(0, i - 1));
                                this.splitText(s.substring(i - 1), w, f, true);
                                continue block1;
                            }
                            this.cutVec.addElement(s2);
                            this.cutVec.addElement(s);
                            continue block1;
                        }
                        this.cutVec.addElement(s2 + s);
                        continue block1;
                    }
                    t = f.stringWidth(s.substring(0, b + 1));
                    if (currX + t > w + space) {
                        if (currX == 0) {
                            s2 = this.cutVec.isEmpty() ? "" : (String)this.cutVec.lastElement();
                            currX = f.stringWidth(s2);
                            i = 0;
                            while (currX + f.stringWidth(s.substring(0, i)) < w) {
                                ++i;
                            }
                            if (i <= 1) {
                                this.splitText(s.substring(0, b + 1), w, f, true);
                                s = (String)this.cutVec.lastElement() + s.substring(b + 1);
                                this.cutVec.removeElementAt(this.cutVec.size() - 1);
                                continue block1;
                            }
                            if (this.cutVec.isEmpty()) {
                                this.cutVec.addElement(s2 + s.substring(0, i - 1));
                            } else {
                                this.cutVec.setElementAt(s2 + s.substring(0, i - 1), this.cutVec.size() - 1);
                            }
                            s = s.substring(i - 1);
                            continue block1;
                        }
                        this.cutVec.addElement(s2);
                        continue block1;
                    }
                    currX += t;
                    s2 = s2 + s.substring(0, b + 1);
                    s = s.substring(b + 1);
                }
            }
        }
        if (continued) {
            return null;
        }
        String[] out = new String[this.cutVec.size()];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (String)this.cutVec.elementAt(i2);
        }
        this.cutVec.removeAllElements();
        return out;
    }

    public void drawText(Graphics g, int x, int y) {
        g.drawImage(this.textImage, x, y, 0);
        for (int i = 0; i < this.links.size(); ++i) {
            Link currentLink = (Link)this.links.elementAt(i);
            if (i == this.selectedLink) {
                g.drawImage(currentLink.selectedImage, x + currentLink.x, y + currentLink.y, 0);
                continue;
            }
            g.drawImage(currentLink.unselectedImage, x + currentLink.x, y + currentLink.y, 0);
        }
    }

    public void drawLinklessTextCentered(Graphics g, int y) {
        g.drawImage(this.textImage, 120, y, 17);
    }

    public int getNumberOfLinks() {
        return this.links.size();
    }

    public String getSelectedLinkURL() {
        if (this.selectedLink == -1) {
            return null;
        }
        return ((Link)this.links.elementAt((int)this.selectedLink)).link;
    }

    public int getSelection() {
        return this.selectedLink;
    }

    public boolean selectNext() {
        if (this.selectedLink < this.links.size() - 1) {
            ++this.selectedLink;
            return true;
        }
        this.selectedLink = -1;
        return false;
    }

    public boolean selectPrev() {
        if (this.selectedLink > 0) {
            --this.selectedLink;
            return true;
        }
        if (this.selectedLink == -1) {
            this.selectedLink = this.links.size() - 1;
            return true;
        }
        this.selectedLink = -1;
        return false;
    }

    public boolean setSelected(int i) {
        if (i >= 0 && i < this.links.size()) {
            this.selectedLink = i;
            return true;
        }
        this.selectedLink = -1;
        return false;
    }

    public boolean touchSelected(int x, int y) {
        for (int i = 0; i < this.links.size(); ++i) {
            Link currentLink = (Link)this.links.elementAt(i);
            if (x < currentLink.x || x > currentLink.x + currentLink.width || y < currentLink.y || y > currentLink.y + currentLink.height || currentLink.row != currentLink.endrow && y > currentLink.y + currentLink.height - this.rowHeight && x > currentLink.x2) continue;
            this.selectedLink = i;
            return true;
        }
        return false;
    }

    public int getHeight() {
        return this.textImage.getHeight();
    }

    public int getWidth() {
        return this.actualWidth;
    }

    private static class Link {
        public String link;
        public Image selectedImage;
        public Image unselectedImage;
        public int x;
        public int x2;
        public int y;
        public int width;
        public int height;
        public int row;
        public int pos;
        public int endrow;
        public int endpos;

        public Link(String link) {
            this.link = link;
        }
    }
}

