/*
 * Decompiled with CFR 0.152.
 */
public class S3dObjExporter {
    static int vertexIndex;
    static boolean suportUVFaces;

    public static void begin() {
        S3dObjExporter.write("# PGR track data");
        S3dObjExporter.write("mtllib master.mtl");
        vertexIndex = 1;
    }

    public static void end() {
        S3dObjExporter.write("# End of data");
    }

    public static void exportVertices(short[] sArray) {
        S3dObjExporter.write("# Num vertices = " + sArray.length / 3);
        for (int i = 0; i < sArray.length; i += 3) {
            S3dObjExporter.write("v " + sArray[i] + " " + sArray[i + 1] + " " + sArray[i + 2]);
        }
    }

    public static void exportVertices(int[] nArray) {
        S3dObjExporter.write("# Num vertices = " + nArray.length / 3);
        for (int i = 0; i < nArray.length; i += 3) {
            S3dObjExporter.write("v " + nArray[i] + " " + nArray[i + 1] + " " + nArray[i + 2]);
        }
    }

    public static void exportTextureCoordinates(S3dResource s3dResource, short[] sArray) {
        if (suportUVFaces) {
            S3dObjExporter.write("# Num UV vertices = " + sArray.length / 8);
            float f = s3dResource.getTextureWidth();
            float f2 = s3dResource.getTextureHeight();
            for (int i = 0; i < sArray.length; i += 8) {
                S3dObjExporter.write("# info " + GluFloat.value(sArray[i + 0]) + " " + GluFloat.value(sArray[i + 1]) + "    " + GluFloat.value(sArray[i + 2]) + " " + GluFloat.value(sArray[i + 3]) + "    " + GluFloat.value(sArray[i + 4]) + " " + GluFloat.value(sArray[i + 5]) + "    " + GluFloat.value(sArray[i + 6]) + " " + GluFloat.value(sArray[i + 7]));
                S3dObjExporter.write("# info " + GluFloat.value(f2) + " , h-uv5 " + GluFloat.value(f2 - (float)sArray[i + 5]));
                S3dObjExporter.write("vt " + GluFloat.value((float)sArray[i + 0] / f) + " " + GluFloat.value((f2 - (float)sArray[i + 1]) / f2) + " 0");
                S3dObjExporter.write("vt " + GluFloat.value((float)sArray[i + 2] / f) + " " + GluFloat.value((f2 - (float)sArray[i + 3]) / f2) + " 0");
                S3dObjExporter.write("vt " + GluFloat.value((float)sArray[i + 4] / f) + " " + GluFloat.value((f2 - (float)sArray[i + 5]) / f2) + " 0");
                S3dObjExporter.write("vt " + GluFloat.value((float)sArray[i + 6] / f) + " " + GluFloat.value((f2 - (float)sArray[i + 7]) / f2) + " 0");
            }
        }
    }

    public static void exportTextureCoordinates(S3dResource s3dResource, int[] nArray) {
        if (suportUVFaces) {
            S3dObjExporter.write("# Num UV vertices = " + nArray.length / 8);
            float f = s3dResource.getTextureWidth();
            float f2 = s3dResource.getTextureHeight();
            for (int i = 0; i < nArray.length; i += 8) {
                S3dObjExporter.write("# info " + GluFloat.value(nArray[i + 0]) + " " + GluFloat.value(nArray[i + 1]) + "    " + GluFloat.value(nArray[i + 2]) + " " + GluFloat.value(nArray[i + 3]) + "    " + GluFloat.value(nArray[i + 4]) + " " + GluFloat.value(nArray[i + 5]) + "    " + GluFloat.value(nArray[i + 6]) + " " + GluFloat.value(nArray[i + 7]));
                S3dObjExporter.write("# info " + GluFloat.value(f2) + " , h-uv5 " + GluFloat.value(f2 - (float)nArray[i + 5]));
                S3dObjExporter.write("vt " + GluFloat.value((float)nArray[i + 0] / f) + " " + GluFloat.value((f2 - (float)nArray[i + 1]) / f2) + " 0");
                S3dObjExporter.write("vt " + GluFloat.value((float)nArray[i + 2] / f) + " " + GluFloat.value((f2 - (float)nArray[i + 3]) / f2) + " 0");
                S3dObjExporter.write("vt " + GluFloat.value((float)nArray[i + 4] / f) + " " + GluFloat.value((f2 - (float)nArray[i + 5]) / f2) + " 0");
                S3dObjExporter.write("vt " + GluFloat.value((float)nArray[i + 6] / f) + " " + GluFloat.value((f2 - (float)nArray[i + 7]) / f2) + " 0");
            }
        }
    }

    public static void exportMaterial(boolean bl) {
        S3dObjExporter.write("usemtl " + (bl ? "opaque" : "alpha"));
    }

    public static void exportFaceList(int[] nArray) {
        S3dObjExporter.exportFaceIndices(nArray.length);
    }

    public static void exportFaceList(short[] sArray) {
        S3dObjExporter.exportFaceIndices(sArray.length);
    }

    static void exportFaceIndices(int n) {
        S3dObjExporter.write("# vertexIndex count = " + vertexIndex);
        for (int i = 0; i < n; i += 12) {
            if (suportUVFaces) {
                S3dObjExporter.write("f " + (vertexIndex + 0) + "/" + (vertexIndex + 0) + " " + (vertexIndex + 3) + "/" + (vertexIndex + 3) + " " + (vertexIndex + 1) + "/" + (vertexIndex + 1));
                S3dObjExporter.write("f " + (vertexIndex + 1) + "/" + (vertexIndex + 1) + " " + (vertexIndex + 3) + "/" + (vertexIndex + 3) + " " + (vertexIndex + 2) + "/" + (vertexIndex + 2));
            } else {
                S3dObjExporter.write("f " + (vertexIndex + 0) + " " + (vertexIndex + 3) + " " + (vertexIndex + 1));
                S3dObjExporter.write("f " + (vertexIndex + 1) + " " + (vertexIndex + 3) + " " + (vertexIndex + 2));
            }
            vertexIndex += 4;
        }
    }

    public static void write(String string) {
        System.out.println(string);
    }

    static {
        suportUVFaces = true;
    }
}

