/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.io;

import com.fw.j2me.io.CntConnection;
import com.fw.j2me.util.LinkedHashtable;
import com.fw.j2me.util.log.CntLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;

public class CntHttpConnection
implements CntConnection {
    private static CntLog log = new CntLog("CntHttpConnection");
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String VERSION = "1.1";
    private static final String STR_RETURN = "\r\n";
    private static final int LINE_END_INDEX = 2;
    private static final char HEADER_END_INDEX = '\u0004';
    private static final String STR_CONTENT_LENGTH = "Content-Length";
    private SocketConnection socket;
    private String server = "";
    private String port = ":80";
    private String path = "";
    private String reqMethod = "GET";
    private LinkedHashtable properties = new LinkedHashtable();
    private int respCode = 200;
    private String respMessage = "";
    private LinkedHashtable respHeader = new LinkedHashtable();
    private InputStream is;
    private OutputStream os;

    CntHttpConnection(String url) throws IOException {
        if (!url.startsWith(HTTP_PROTOCOL)) {
            throw new IOException("Not http protocol");
        }
        url = url.substring(HTTP_PROTOCOL.length());
        int firstSlash = url.indexOf("/");
        if (firstSlash < 0) {
            this.server = url;
            this.path = "/";
        } else {
            this.server = url.substring(0, firstSlash);
            this.path = url.substring(firstSlash);
        }
        int portStart = this.server.indexOf(":");
        if (portStart > 0) {
            this.port = this.server.substring(portStart);
            this.server = this.server.substring(0, portStart);
        }
        this.properties.put("Host", this.server + this.port);
        log.debug("before Connector.open(socket://" + this.server + this.port + ", Connector.READ_WRITE, true)");
        this.socket = (SocketConnection)Connector.open((String)("socket://" + this.server + this.port), (int)3, (boolean)true);
        log.debug("after Connector.open");
    }

    public OutputStream openOutputStream() throws IOException {
        if (null != this.os) {
            return this.os;
        }
        this.os = this.socket.openOutputStream();
        String headerStr = this.reqMethod + " " + this.path + " HTTP/" + VERSION + STR_RETURN;
        String key = "";
        String value = "";
        Enumeration enu = this.properties.keys();
        while (enu.hasMoreElements()) {
            key = (String)enu.nextElement();
            headerStr = headerStr + key + ": ";
            value = (String)this.properties.get(key);
            headerStr = headerStr + value + STR_RETURN;
        }
        headerStr = headerStr + STR_RETURN;
        this.os.write(headerStr.getBytes());
        log.debug("Http Header = " + headerStr);
        return this.os;
    }

    public InputStream openInputStream() throws IOException {
        this.initRead();
        return this.is;
    }

    public void setRequestProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setRequestMethod(String method) {
        this.reqMethod = POST.equals(method) ? POST : GET;
    }

    public String getURL() {
        return HTTP_PROTOCOL + this.server + this.path;
    }

    public int getResponseCode() throws IOException {
        this.openInputStream();
        return this.respCode;
    }

    public String getResponseMessage() throws IOException {
        this.openInputStream();
        return this.respMessage;
    }

    public long getLength() throws IOException {
        this.openInputStream();
        long length = -1L;
        try {
            String lenStr = (String)this.respHeader.get(STR_CONTENT_LENGTH);
            if (null != lenStr) {
                length = Long.parseLong(lenStr);
            }
        }
        catch (NumberFormatException e) {
            log.debug("getLength() ", e);
        }
        return length;
    }

    private void initRead() throws IOException {
        if (null != this.is) {
            return;
        }
        log.debug("before flush outputStream()");
        this.os.flush();
        log.debug("before read inputStream()");
        this.is = this.socket.openInputStream();
        this.readRespHeader();
    }

    private void readRespHeader() throws IOException {
        log.debug("reading status");
        StringBuffer sb = new StringBuffer();
        int end = 0;
        int curChar = 0;
        end = 0;
        curChar = this.is.read();
        while (!this.isEndChar(curChar)) {
            end = STR_RETURN.charAt(end % STR_RETURN.length()) == curChar ? ++end : 0;
            if (end == 2) {
                sb.deleteCharAt(sb.length() - 1);
                break;
            }
            sb.append((char)curChar);
            curChar = this.is.read();
        }
        String statusLine = sb.toString();
        log.debug("Server response status : " + statusLine);
        int s1 = statusLine.indexOf(" ");
        int s2 = statusLine.indexOf(" ", s1 + 1);
        if (-1 == s1 || -1 == s2) {
            throw new IOException("Invalid status.");
        }
        this.respCode = Integer.parseInt(statusLine.substring(s1 + 1, s2));
        this.respMessage = statusLine.substring(s2 + 1);
        log.debug("reading response header properties");
        end = 0;
        curChar = this.is.read();
        while (!this.isEndChar(curChar)) {
            end = STR_RETURN.charAt(end % STR_RETURN.length()) == curChar ? ++end : 0;
            if (2 == end) {
                sb.deleteCharAt(sb.length() - 1);
                String headerLine = sb.toString();
                int divider = headerLine.indexOf(":");
                if (divider > 0) {
                    String key = headerLine.substring(0, divider);
                    String value = headerLine.substring(divider + 1);
                    this.respHeader.put(key, value.trim());
                }
                sb = new StringBuffer();
            } else {
                if (4 == end) break;
                sb.append((char)curChar);
            }
            curChar = this.is.read();
        }
    }

    private boolean isEndChar(int character) {
        return -1 == character;
    }

    public String read() throws IOException {
        this.openInputStream();
        StringBuffer buffer = new StringBuffer();
        int current = 0;
        while ((current = this.is.read()) != -1) {
            buffer.append((char)current);
        }
        return buffer.toString();
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }
}

