/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util.xml;

import com.fw.j2me.util.log.CntLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XmlNode {
    private static CntLog log = new CntLog("XmlNode");
    private String nodeName;
    private String nodeValue;
    private XmlNode parent;
    private Vector subNodes;

    protected XmlNode() {
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(String nodeValue) {
        this.nodeValue = nodeValue;
    }

    public XmlNode getParent() {
        return this.parent;
    }

    public void setParent(XmlNode parent) {
        this.parent = parent;
    }

    public Vector getSubNodes() {
        return this.subNodes;
    }

    public void setSubNodes(Vector subNodes) {
        this.subNodes = subNodes;
    }

    public void trace(int level) {
        String tabs = "";
        for (int i = 0; i < level; ++i) {
            tabs = tabs + "\t";
        }
        log.debug(tabs + "<" + this.getNodeName() + ">" + this.getNodeValue() + "</" + this.getNodeName() + ">");
        if (this.getSubNodes() != null) {
            Enumeration sub = this.getSubNodes().elements();
            while (sub.hasMoreElements()) {
                ((XmlNode)sub.nextElement()).trace(level + 1);
            }
        }
    }

    public Hashtable traceNameValue() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (this.subNodes != null) {
            Enumeration sub = this.subNodes.elements();
            while (sub.hasMoreElements()) {
                XmlNode n = (XmlNode)sub.nextElement();
                String value = n.getNodeValue();
                if (value == null) continue;
                h.put(n.getNodeName(), n.getNodeValue());
            }
        }
        return h;
    }

    public void getNodeValueByName(String nodeName, Vector nodeValues) {
        if (this.getNodeName().equals(nodeName)) {
            nodeValues.addElement(this.getNodeValue());
        }
        if (this.getSubNodes() != null) {
            Enumeration sub = this.getSubNodes().elements();
            while (sub.hasMoreElements()) {
                ((XmlNode)sub.nextElement()).getNodeValueByName(nodeName, nodeValues);
            }
        }
    }

    public void getNodesByName(String nodeName, Vector nodes) {
        if (this.getNodeName().equals(nodeName)) {
            nodes.addElement(this);
        }
        if (this.getSubNodes() != null) {
            Enumeration sub = this.getSubNodes().elements();
            while (sub.hasMoreElements()) {
                ((XmlNode)sub.nextElement()).getNodesByName(nodeName, nodes);
            }
        }
    }

    public XmlNode getChild(String nodeName) {
        if (this.getSubNodes() != null) {
            Enumeration sub = this.getSubNodes().elements();
            while (sub.hasMoreElements()) {
                XmlNode ret = (XmlNode)sub.nextElement();
                if (!ret.nodeName.equalsIgnoreCase(nodeName)) continue;
                return ret;
            }
        }
        return null;
    }
}

