/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util.xml;

import com.fw.j2me.util.log.CntLog;
import com.fw.j2me.util.xml.XmlHandler;
import com.fw.j2me.util.xml.XmlNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private static CntLog log = new CntLog("XmlParser");
    public static SAXParserFactory factory = SAXParserFactory.newInstance();
    public static SAXParser saxParser;

    private XmlParser() {
    }

    public static XmlNode parseXmlByString(String xmlStr) {
        return XmlParser.parseXmlByInputStream(new ByteArrayInputStream(xmlStr.getBytes()));
    }

    public static XmlNode parseXmlByByteArray(byte[] xmlArray) {
        return XmlParser.parseXmlByInputStream(new ByteArrayInputStream(xmlArray));
    }

    public static XmlNode parseXmlByInputStream(InputStream xmlIs) {
        XmlHandler dcdXmlHandler = new XmlHandler();
        XmlNode root = null;
        try {
            saxParser.parse(xmlIs, (DefaultHandler)dcdXmlHandler);
            root = dcdXmlHandler.getRoot();
        }
        catch (SAXException e) {
            log.debug("parseXmlByInputStream ", e);
        }
        catch (IOException e) {
            log.debug("parseXmlByInputStream ", e);
        }
        return root;
    }

    static {
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            log.debug("static ", e);
        }
        catch (SAXException e) {
            log.debug("static ", e);
        }
    }
}

