/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.IndependentComponent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.AnimatePos;
import com.sonyericsson.ykjc.ui.component.ClipBrowserListener;
import com.sonyericsson.ykjc.ui.component.ClipInfo;
import com.sonyericsson.ykjc.ui.component.IndependentComponentCreator;
import com.sonyericsson.ykjc.ui.component.KeyConsumer;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class HorizontalClipBrowser
extends Container
implements KeyConsumer,
IndependentComponentCreator {
    private Image playImage = null;
    private int focusIndex = 0;
    private ClipInfo[] clips = null;
    private ClipInfo tempClip = null;
    private Dimension bigImageSize = null;
    private Dimension middleImageSize = null;
    private Dimension smallImageSize = null;
    private boolean isInitialized = false;
    private Timer timer = new Timer();
    private int state = 1;
    private ClipBrowserListener listener = null;
    private static final int STATE_NORMAL_DRAW = 1;
    private static final int STATE_MOVING_DRAW = 2;
    private static final int PERIODIC_INTERVAL = 100;
    private static final int RENDER_CLIPS_NUM = 5;
    private Vector animatePosLeftMoving = new Vector();
    private Vector animatePosRightMoving = new Vector();
    private Vector animateImages = new Vector();
    private Image tempAnimateImage = null;
    private int frameNum = 5;
    private int spaceUnit = 0;
    private int animateCount = 0;
    private int animateMovingDirection;
    private boolean isPrepareClipInfo = false;
    private boolean isDrawing = false;
    private String emptyText = null;
    private Image defaultImage = null;
    private Image shadowImage = null;
    private int shadowDiffY = 8;
    private int initFocusItem;
    private int startDrawPosition = 0;
    private Image[] normalBuffer;

    private void calcImageSizeParam() {
        int unit = this.getWidth() / 12;
        int bigWidth = unit * 6;
        int bigHeight = bigWidth * 3 / 4;
        int middleWidth = unit * 4;
        int middleHeight = middleWidth * 3 / 4;
        int smallWidth = unit * 2;
        int smallHeight = smallWidth * 3 / 4;
        this.bigImageSize = new Dimension(bigWidth, bigHeight);
        this.middleImageSize = new Dimension(middleWidth, middleHeight);
        this.smallImageSize = new Dimension(smallWidth, smallHeight);
        this.spaceUnit = unit;
    }

    private void calcAnimatePosLeftMoving() {
        int baseX = this.getX();
        int baseY = this.getY();
        int height = this.getHeight();
        int xStep1 = this.spaceUnit / this.frameNum;
        int xStep2 = 2 * this.spaceUnit / this.frameNum;
        int xStep3 = 4 * this.spaceUnit / this.frameNum;
        int xStep4 = 3 * this.spaceUnit / this.frameNum;
        int yStep1 = (this.middleImageSize.getHeight() - this.smallImageSize.getHeight()) / (2 * this.frameNum);
        int yStep2 = (this.bigImageSize.getHeight() - this.middleImageSize.getHeight()) / (2 * this.frameNum);
        int sizeStepW1 = (this.middleImageSize.getWidth() - this.smallImageSize.getWidth()) / this.frameNum;
        int sizeStepH1 = (this.middleImageSize.getHeight() - this.smallImageSize.getHeight()) / this.frameNum;
        int sizeStepW2 = (this.bigImageSize.getWidth() - this.middleImageSize.getWidth()) / this.frameNum;
        int sizeStepH2 = (this.bigImageSize.getHeight() - this.middleImageSize.getHeight()) / this.frameNum;
        int x0 = baseX;
        int y0 = baseY + (height - this.smallImageSize.getHeight() - this.shadowDiffY) / 2;
        int x1 = baseX + this.spaceUnit;
        int y1 = baseY + (height - this.middleImageSize.getHeight() - this.shadowDiffY) / 2;
        int x2 = baseX + 3 * this.spaceUnit;
        int y2 = baseY + (height - this.bigImageSize.getHeight() - this.shadowDiffY) / 2;
        int x3 = baseX + 7 * this.spaceUnit;
        int y3 = baseY + (height - this.middleImageSize.getHeight() - this.shadowDiffY) / 2;
        int x4 = baseX + 10 * this.spaceUnit;
        int y4 = baseY + (height - this.smallImageSize.getHeight() - this.shadowDiffY) / 2;
        for (int i = 0; i < this.frameNum + 1; ++i) {
            Rectangle rect = new Rectangle(x0 + xStep1 * i, y0, this.smallImageSize);
            rect = new Rectangle(x1 - xStep1 * i, y1 + yStep1 * i, new Dimension(this.middleImageSize.getWidth() - sizeStepW1 * i, this.middleImageSize.getHeight() - sizeStepH1 * i));
            Rectangle[] array = new Rectangle[]{rect, rect, rect = new Rectangle(x2 - xStep2 * i, y2 + yStep2 * i, new Dimension(this.bigImageSize.getWidth() - sizeStepW2 * i, this.bigImageSize.getHeight() - sizeStepH2 * i)), rect = new Rectangle(x3 - xStep3 * i, y3 - yStep2 * i, new Dimension(this.middleImageSize.getWidth() + sizeStepW2 * i, this.middleImageSize.getHeight() + sizeStepH2 * i)), rect = new Rectangle(x4 - xStep4 * i, y4 - yStep1 * i, new Dimension(this.smallImageSize.getWidth() + sizeStepW1 * i, this.smallImageSize.getHeight() + sizeStepH1 * i))};
            rect = new Rectangle(x4 - this.spaceUnit + xStep1 * i, y4, this.smallImageSize);
            AnimatePos pos = new AnimatePos();
            pos.framePos = array;
            pos.tempFramePos = rect;
            this.animatePosLeftMoving.addElement(pos);
        }
    }

    private void calcAnimatePosRightMoving() {
        int baseX = this.getX();
        int baseY = this.getY();
        int height = this.getHeight();
        int xStep1 = this.spaceUnit / this.frameNum;
        int xStep2 = 2 * this.spaceUnit / this.frameNum;
        int xStep3 = 4 * this.spaceUnit / this.frameNum;
        int xStep4 = 3 * this.spaceUnit / this.frameNum;
        int yStep1 = (this.middleImageSize.getHeight() - this.smallImageSize.getHeight()) / (2 * this.frameNum);
        int yStep2 = (this.bigImageSize.getHeight() - this.middleImageSize.getHeight()) / (2 * this.frameNum);
        int sizeStepW1 = (this.middleImageSize.getWidth() - this.smallImageSize.getWidth()) / this.frameNum;
        int sizeStepH1 = (this.middleImageSize.getHeight() - this.smallImageSize.getHeight()) / this.frameNum;
        int sizeStepW2 = (this.bigImageSize.getWidth() - this.middleImageSize.getWidth()) / this.frameNum;
        int sizeStepH2 = (this.bigImageSize.getHeight() - this.middleImageSize.getHeight()) / this.frameNum;
        int x0 = baseX;
        int y0 = baseY + (height - this.smallImageSize.getHeight() - this.shadowDiffY) / 2;
        int x1 = baseX + this.spaceUnit;
        int y1 = baseY + (height - this.middleImageSize.getHeight() - this.shadowDiffY) / 2;
        int x2 = baseX + 3 * this.spaceUnit;
        int y2 = baseY + (height - this.bigImageSize.getHeight() - this.shadowDiffY) / 2;
        int x3 = baseX + 7 * this.spaceUnit;
        int y3 = baseY + (height - this.middleImageSize.getHeight() - this.shadowDiffY) / 2;
        int x4 = baseX + 10 * this.spaceUnit;
        int y4 = baseY + (height - this.smallImageSize.getHeight() - this.shadowDiffY) / 2;
        for (int i = 0; i < this.frameNum + 1; ++i) {
            Rectangle rect = new Rectangle(x0 + xStep1 * i, y0 - yStep1 * i, new Dimension(this.smallImageSize.getWidth() + sizeStepW1 * i, this.smallImageSize.getHeight() + sizeStepH1 * i));
            Rectangle[] array = new Rectangle[]{rect, rect = new Rectangle(x1 + xStep2 * i, y1 - yStep2 * i, new Dimension(this.middleImageSize.getWidth() + sizeStepW2 * i, this.middleImageSize.getHeight() + sizeStepH2 * i)), rect = new Rectangle(x2 + xStep3 * i, y2 + yStep2 * i, new Dimension(this.bigImageSize.getWidth() - sizeStepW2 * i, this.bigImageSize.getHeight() - sizeStepH2 * i)), rect = new Rectangle(x3 + xStep4 * i, y3 + yStep1 * i, new Dimension(this.middleImageSize.getWidth() - sizeStepW1 * i, this.middleImageSize.getHeight() - sizeStepH1 * i)), rect = new Rectangle(x4 - xStep1 * i, y4, this.smallImageSize)};
            rect = new Rectangle(x0 + this.spaceUnit - xStep1 * i, y0, this.smallImageSize);
            AnimatePos pos = new AnimatePos();
            pos.framePos = array;
            pos.tempFramePos = rect;
            this.animatePosRightMoving.addElement(pos);
        }
    }

    public HorizontalClipBrowser(Image[] clipImages, int initFocusItem, Dimension preferredSize) {
        this.playImage = YkUiContext.imgMgr.getImage("videoplay");
        this.defaultImage = YkUiContext.imgMgr.getImage("defaultClipImage");
        this.shadowImage = YkUiContext.imgMgr.getImage("clipShadow");
        this.initClipInfos(clipImages, initFocusItem);
        this.setPreferredSize(preferredSize);
        this.setFocusable(clipImages.length > 0);
    }

    public void setHorizontalClipBrowserListener(ClipBrowserListener l) {
        this.listener = l;
    }

    private void prepareRenderMoving(int direction) {
        if (this.animateCount != 0) {
            return;
        }
        this.tempClip = null;
        if (direction == 2) {
            this.tempClip = new ClipInfo();
            this.tempClip.id = this.clips[this.clips.length - 1].id;
            this.tempClip.image = this.clips[this.clips.length - 1].image;
        } else {
            this.tempClip = new ClipInfo();
            this.tempClip.id = this.clips[0].id;
            this.tempClip.image = this.clips[0].image;
        }
        if (this.tempClip != null) {
            this.tempAnimateImage = this.tempClip.image.scaled(this.smallImageSize.getWidth(), this.smallImageSize.getHeight());
        }
        this.animateImages.removeAllElements();
        Vector animatePos = null;
        animatePos = this.animateMovingDirection == 1 ? this.animatePosLeftMoving : this.animatePosRightMoving;
        this.animateImages.addElement(null);
        for (int j = 1; j < this.frameNum + 1; ++j) {
            AnimatePos pos = (AnimatePos)animatePos.elementAt(j);
            Rectangle[] array = pos.framePos;
            int len = this.clips.length;
            if (array.length < this.clips.length) {
                len = array.length;
            }
            Image[] images = new Image[len];
            for (int i = 0; i < len; ++i) {
                Image image;
                images[i] = this.clips[i].image != null ? (image = this.clips[i].image.scaled(array[i + this.startDrawPosition].getSize().getWidth(), array[i + this.startDrawPosition].getSize().getHeight())) : null;
            }
            this.animateImages.addElement(images);
        }
    }

    private void resetClipsInfoAfterMoving(int direction) {
        if (this.clips.length == 2) {
            return;
        }
        if (this.tempClip == null) {
            return;
        }
        if (direction == 2) {
            for (int i = this.clips.length - 1; i > 0; --i) {
                this.clips[i] = this.clips[i - 1];
            }
            this.clips[0] = this.tempClip;
        } else {
            for (int i = 0; i < this.clips.length - 1; ++i) {
                this.clips[i] = this.clips[i + 1];
            }
            this.clips[this.clips.length - 1] = this.tempClip;
        }
        this.tempClip = null;
    }

    private void initClipInfos(Image[] images, int initFocusItem) {
        int loop;
        if (images == null) {
            return;
        }
        if (images.length < 1) {
            return;
        }
        switch (images.length) {
            case 1: {
                this.focusIndex = 0;
                break;
            }
            case 2: {
                this.focusIndex = 0;
                break;
            }
            case 3: {
                this.focusIndex = 1;
                break;
            }
            case 4: {
                this.focusIndex = 1;
                break;
            }
            default: {
                this.focusIndex = 2;
            }
        }
        this.normalBuffer = new Image[images.length];
        this.clips = new ClipInfo[images.length];
        for (int i = 0; i < this.clips.length; ++i) {
            this.clips[i] = new ClipInfo();
            this.clips[i].id = i;
            if (images[i] != null) {
                this.clips[i].image = images[i];
                this.clips[i].isRealImg = true;
                continue;
            }
            this.clips[i].image = this.defaultImage;
        }
        this.initFocusItem = this.focusIndex;
        if (initFocusItem >= 0 && initFocusItem < this.clips.length) {
            this.initFocusItem = initFocusItem;
        }
        if ((loop = this.focusIndex - this.initFocusItem) < 0) {
            loop += this.clips.length;
        }
        for (int l = 0; l < loop; ++l) {
            ClipInfo tmp = this.clips[this.clips.length - 1];
            for (int j = this.clips.length - 1; j > 0; --j) {
                this.clips[j] = this.clips[j - 1];
            }
            this.clips[0] = tmp;
        }
    }

    public void keyPressed(int keyCode) {
        if (this.state != 1) {
            return;
        }
        if (this.isPrepareClipInfo) {
            return;
        }
        if (this.clips == null) {
            return;
        }
        if (this.clips.length < 2) {
            return;
        }
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 5) {
            this.timer.cancel();
            this.timer = new Timer();
            MovingDrawTask task = new MovingDrawTask();
            task.setDirection(1, this.frameNum);
            this.timer.schedule((TimerTask)task, 0L, 100L);
            this.state = 2;
            this.animateMovingDirection = 1;
        } else if (gameAction == 2) {
            this.timer.cancel();
            this.timer = new Timer();
            MovingDrawTask task = new MovingDrawTask();
            task.setDirection(2, this.frameNum);
            this.timer.schedule((TimerTask)task, 0L, 100L);
            this.state = 2;
            this.animateMovingDirection = 2;
        }
    }

    public void paint(Graphics g) {
        int j;
        Rectangle[] array;
        AnimatePos pos;
        if (!this.isInitialized) {
            this.calcImageSizeParam();
            this.calcAnimatePosLeftMoving();
            this.calcAnimatePosRightMoving();
            this.calStartDrawPosition();
            this.isInitialized = true;
        }
        if (this.clips == null) {
            if (this.emptyText != null) {
                g.setColor(0);
                Font f = Font.createSystemFont(32, 0, 8);
                g.setFont(f);
                g.drawString(this.emptyText, this.getX() + (this.getWidth() - g.getFont().stringWidth(this.emptyText)) / 2, this.getY() + (this.getHeight() - g.getFont().getHeight()) / 2);
            }
            return;
        }
        if (this.isPrepareClipInfo) {
            return;
        }
        int theState = this.state;
        if (this.state != 1 && this.animateCount == 0) {
            theState = 1;
        }
        this.isDrawing = true;
        Image[] images = null;
        if (theState == 1) {
            pos = (AnimatePos)this.animatePosLeftMoving.elementAt(0);
            array = pos.framePos;
        } else if (this.animateMovingDirection == 1) {
            pos = (AnimatePos)this.animatePosLeftMoving.elementAt(this.animateCount);
            array = pos.framePos;
            images = (Image[])this.animateImages.elementAt(this.animateCount);
        } else {
            pos = (AnimatePos)this.animatePosRightMoving.elementAt(this.animateCount);
            array = pos.framePos;
            images = (Image[])this.animateImages.elementAt(this.animateCount);
        }
        if (this.tempClip != null && this.clips.length >= 5) {
            if (theState == 1) {
                Image image = this.tempClip.image.scaled(pos.tempFramePos.getSize().getWidth(), pos.tempFramePos.getSize().getHeight());
                g.drawImage(image, pos.tempFramePos.getX(), pos.tempFramePos.getY());
            } else {
                g.drawImage(this.tempAnimateImage, pos.tempFramePos.getX(), pos.tempFramePos.getY());
            }
            this.borderDraw(g, pos.tempFramePos, false);
        }
        for (int i = 0; i < this.focusIndex && i < array.length; ++i) {
            j = i + this.startDrawPosition;
            if (theState == 1) {
                if (this.normalBuffer[i] == null) {
                    this.normalBuffer[i] = this.clips[i].image.scaled(array[j].getSize().getWidth(), array[j].getSize().getHeight());
                }
                g.drawImage(this.normalBuffer[i], array[j].getX(), array[j].getY());
            } else {
                g.drawImage(images[i], array[j].getX(), array[j].getY());
            }
            this.borderDraw(g, array[j], false);
        }
        int index = this.clips.length - 1;
        if (index > array.length - 1) {
            index = array.length - 1;
        }
        for (int i = index; i > this.focusIndex; --i) {
            int j2 = i + this.startDrawPosition;
            if (theState == 1) {
                if (this.clips[i].image != null) {
                    if (this.normalBuffer[i] == null) {
                        this.normalBuffer[i] = this.clips[i].image.scaled(array[j2].getSize().getWidth(), array[j2].getSize().getHeight());
                    }
                    g.drawImage(this.normalBuffer[i], array[j2].getX(), array[j2].getY());
                }
            } else {
                g.drawImage(images[i], array[j2].getX(), array[j2].getY());
            }
            this.borderDraw(g, array[j2], false);
        }
        j = this.focusIndex + this.startDrawPosition;
        if (theState == 1) {
            this.shadowDraw(g, array[j]);
            if (this.clips[this.focusIndex].image != null) {
                if (this.normalBuffer[this.focusIndex] == null) {
                    this.normalBuffer[this.focusIndex] = this.clips[this.focusIndex].image.scaled(array[j].getSize().getWidth(), array[j].getSize().getHeight());
                }
                g.drawImage(this.normalBuffer[this.focusIndex], array[j].getX(), array[j].getY());
            }
        } else {
            g.drawImage(images[this.focusIndex], array[j].getX(), array[j].getY());
        }
        this.borderDraw(g, array[j], true);
        if (this.hasFocus() && theState == 1) {
            Rectangle rect = array[j];
            if (this.playImage != null) {
                int x = rect.getX() + (rect.getSize().getWidth() - this.playImage.getWidth()) / 2;
                int y = rect.getY() + (rect.getSize().getHeight() - this.playImage.getHeight()) / 2;
                g.drawImage(this.playImage, x, y);
            }
        }
        this.isDrawing = false;
    }

    public int getCurrentSelectClip() {
        if (this.clips != null) {
            return this.clips[this.focusIndex].id;
        }
        return -1;
    }

    public void setEmptyText(String str) {
        this.emptyText = str;
    }

    public void setClips(Image[] clipImages) {
        this.initClipInfos(clipImages, this.clips[this.focusIndex].id);
        this.isInitialized = false;
    }

    public void setClip(Image clipImage, int position) {
        if (clipImage != null && this.clips != null) {
            for (int i = 0; i < this.clips.length; ++i) {
                if (this.clips[i].id != position || this.clips[i].isRealImg) continue;
                this.clips[i].image = clipImage;
                this.clips[i].isRealImg = true;
                this.normalBuffer[i] = null;
                break;
            }
        }
    }

    private void borderDraw(Graphics g, Rectangle rect, boolean focus) {
        int i;
        int baseX = rect.getX();
        int baseY = rect.getY();
        int lineWidth1 = 1;
        int color1 = 0;
        int lineWidth2 = 1;
        int color2 = 6325915;
        if (focus && this.hasFocus()) {
            lineWidth2 = 2;
            color2 = 12313076;
        }
        int lineWidth3 = 1;
        int color3 = 3026219;
        if (focus && this.hasFocus()) {
            color3 = 1210536;
        }
        int diff = lineWidth3 + lineWidth2 + lineWidth1 - 1;
        int x = baseX + diff;
        int y = baseY + diff;
        int width = rect.getSize().getWidth() - 2 * diff - 1;
        int height = rect.getSize().getHeight() - 2 * diff;
        g.setColor(color1);
        for (i = 0; i < lineWidth1; ++i) {
            g.drawRect(x--, y--, width, height);
            width += 2;
            height += 2;
        }
        g.setColor(color2);
        for (i = 0; i < lineWidth2; ++i) {
            g.drawRect(x--, y--, width, height);
            width += 2;
            height += 2;
        }
        g.setColor(color3);
        for (i = 0; i < lineWidth3; ++i) {
            g.drawRect(x--, y--, width, height);
            width += 2;
            height += 2;
        }
    }

    private void shadowDraw(Graphics g, Rectangle rect) {
        if (this.shadowImage != null) {
            g.drawImage(this.shadowImage, rect.getX(), rect.getY() + rect.getSize().getHeight() + 2);
        }
    }

    private void calStartDrawPosition() {
        if (this.clips == null) {
            return;
        }
        switch (this.clips.length) {
            case 1: {
                this.startDrawPosition = 2;
                break;
            }
            case 2: {
                this.startDrawPosition = 2;
                break;
            }
            case 3: {
                this.startDrawPosition = 1;
                break;
            }
            case 4: {
                this.startDrawPosition = 1;
                break;
            }
            default: {
                this.startDrawPosition = 0;
            }
        }
    }

    public boolean consumeKey(int keyCode) {
        this.keyPressed(keyCode);
        return true;
    }

    public IndependentComponent genIndependentComponent() {
        int[] actions = new int[]{5, 2, 6};
        IndependentComponent ic = new IndependentComponent(this, actions);
        return ic;
    }

    public void refresh(VideoInfo[] videos) {
        if (this.clips != null && videos != null && this.clips.length == videos.length) {
            for (int i = 0; i < this.clips.length; ++i) {
                if (this.clips[i].isRealImg || videos[this.clips[i].id].getImg() == null) continue;
                this.clips[i].image = videos[this.clips[i].id].getImg();
                this.clips[i].isRealImg = true;
                this.normalBuffer[i] = null;
            }
            this.repaint();
        }
    }

    private class MovingDrawTask
    extends TimerTask {
        private int movingDirection;
        private int count = 0;
        private int totalCnt = 0;
        private boolean focusChangedDuringMoving = false;

        private MovingDrawTask() {
        }

        public void setDirection(int direction, int totalCount) {
            for (int i = 0; i < HorizontalClipBrowser.this.normalBuffer.length; ++i) {
                ((HorizontalClipBrowser)HorizontalClipBrowser.this).normalBuffer[i] = null;
            }
            this.movingDirection = direction;
            this.count = totalCount;
            this.totalCnt = totalCount;
            HorizontalClipBrowser.this.animateCount = 0;
            this.focusChangedDuringMoving = false;
        }

        public synchronized void run() {
            if (HorizontalClipBrowser.this.isDrawing) {
                return;
            }
            if (this.count > 0) {
                HorizontalClipBrowser.this.isPrepareClipInfo = true;
                HorizontalClipBrowser.this.prepareRenderMoving(this.movingDirection);
                HorizontalClipBrowser.this.animateCount++;
                if (HorizontalClipBrowser.this.animateCount == this.totalCnt / 2) {
                    this.focusChangedDuringMoving = false;
                    if (this.movingDirection == 1 && HorizontalClipBrowser.this.focusIndex < HorizontalClipBrowser.this.clips.length - 1) {
                        HorizontalClipBrowser.this.focusIndex++;
                        this.focusChangedDuringMoving = true;
                    } else if (this.movingDirection == 2 && HorizontalClipBrowser.this.focusIndex > 0) {
                        HorizontalClipBrowser.this.focusIndex--;
                        this.focusChangedDuringMoving = true;
                    }
                }
                HorizontalClipBrowser.this.isPrepareClipInfo = false;
                HorizontalClipBrowser.this.repaint();
                --this.count;
            } else {
                HorizontalClipBrowser.this.animateImages.removeAllElements();
                if (this.focusChangedDuringMoving && HorizontalClipBrowser.this.clips.length != 2) {
                    if (this.movingDirection == 1) {
                        HorizontalClipBrowser.this.focusIndex--;
                    } else {
                        HorizontalClipBrowser.this.focusIndex++;
                    }
                }
                HorizontalClipBrowser.this.isPrepareClipInfo = true;
                HorizontalClipBrowser.this.timer.cancel();
                HorizontalClipBrowser.this.animateCount = 0;
                HorizontalClipBrowser.this.state = 1;
                HorizontalClipBrowser.this.resetClipsInfoAfterMoving(this.movingDirection);
                HorizontalClipBrowser.this.isPrepareClipInfo = false;
                if (HorizontalClipBrowser.this.clips.length == 2) {
                    if (HorizontalClipBrowser.this.focusIndex == 0) {
                        HorizontalClipBrowser.this.startDrawPosition = 2;
                    } else {
                        HorizontalClipBrowser.this.startDrawPosition = 1;
                    }
                }
                HorizontalClipBrowser.this.repaint();
                if (HorizontalClipBrowser.this.listener != null) {
                    HorizontalClipBrowser.this.listener.selectClipChanged(((HorizontalClipBrowser)HorizontalClipBrowser.this).clips[((HorizontalClipBrowser)HorizontalClipBrowser.this).focusIndex].id);
                }
            }
        }
    }
}

