/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.ui.IndependentComponent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.IndependentComponentCreator;
import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Border;
import java.util.Enumeration;
import java.util.Vector;

public class YForm
extends Form {
    private CntLog log = new CntLog("YForm");
    private Vector independentComponents = new Vector();
    private static final int COMMAND_BAD = -1999;
    private int pageID;
    private static boolean isMenuShowing;
    private Object menuLock = new Object();
    static int leftSK;
    static int rightSK;
    static int rightSK2;
    static int backSK;
    static int clearSK;
    static int backspaceSK;

    public YForm(String title, int pageID) {
        super(title);
        this.pageID = pageID;
        Label titleComponent = this.getTitleComponent();
        titleComponent.setPreferredSize(new Dimension(titleComponent.getWidth(), 31));
        this.setScrollable(false);
    }

    public YForm() {
        isMenuShowing = false;
        this.setScrollable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(int keyCode) {
        Object object = this.menuLock;
        synchronized (object) {
            if (!isMenuShowing) {
                Component focusedComponent = this.getFocused();
                boolean consumed = false;
                Enumeration it = this.independentComponents.elements();
                while (it.hasMoreElements()) {
                    IndependentComponent ic = (IndependentComponent)it.nextElement();
                    if (ic.getComponent() != focusedComponent) continue;
                    consumed = ic.consumeAction(keyCode);
                    break;
                }
                if (!consumed) {
                    super.keyPressed(keyCode);
                }
            }
        }
    }

    public void keyRepeated(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK || keyCode == backspaceSK || Display.getInstance().isThirdSoftButton() && game == 8) {
            return;
        }
        super.keyRepeated(keyCode);
    }

    public void addIndependentComponents(Component c) {
        IndependentComponentCreator icc = (IndependentComponentCreator)((Object)c);
        IndependentComponent ic = icc.genIndependentComponent();
        if (ic != null && !this.independentComponents.contains(ic)) {
            this.independentComponents.addElement(ic);
        }
    }

    protected List createCommandList(Vector commands) {
        Vector cmds = new Vector();
        int number = commands.size();
        for (int i = 0; i < number - 2; ++i) {
            cmds.addElement(commands.elementAt(i));
        }
        List l = new List(cmds);
        l.getStyle().setBorder(null);
        l.setFixedSelection(1);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command showMenuDialog(Dialog menu) {
        Command badCmd = new Command("Bad command", -1999);
        Object object = this.menuLock;
        synchronized (object) {
            Command cmd;
            isMenuShowing = true;
            int pageID = UiContext.pageMgr.getCurrentPageID();
            try {
                if (pageID != this.pageID) {
                    Command command = badCmd;
                    return command;
                }
                int cnt = this.getCommandCount();
                int marginLeft = (int)((float)this.getWidth() * 0.25f);
                int marginRight = 0;
                if (this.isReverseSoftButtons()) {
                    marginRight = marginLeft;
                    marginLeft = 0;
                }
                Component c = menu.getComponentAt(0);
                int h = c.getStyle().getFont().getHeight() + c.getStyle().getMargin(0) + c.getStyle().getMargin(2) + c.getStyle().getPadding(0) + c.getStyle().getPadding(2);
                int height = Math.min((cnt - 3) * h, this.getHeight() / 2);
                int top = this.getContentPane().getHeight() - height;
                menu.getSoftButtonStyle().setMargin(0, 0, 0, 0);
                menu.getSoftButtonStyle().setPadding(0, 0, 0, 0);
                for (int i = 0; i < menu.getSoftButtonCount(); ++i) {
                    Button b = menu.getSoftButton(i);
                    b.getStyle().setMargin(0, 0, 0, 0);
                    b.getStyle().setPadding(5, 5, 5, 5);
                    String text = b.getText();
                    if (text == null || text.length() <= 0) continue;
                    Image topI = YkUiContext.imgMgr.getImage("borderTop");
                    Image topLeft = YkUiContext.imgMgr.getImage("borderTopLeft");
                    Image center = YkUiContext.imgMgr.getImage("borderCenter");
                    Border border = Border.createEmpty();
                    border.setPressedInstance(Border.createImageBorder(topI, topLeft, center));
                    b.getStyle().setBorder(border);
                }
                cmd = menu.show(top, 0, marginLeft, marginRight, true);
                if (cmd == null) {
                    cmd = badCmd;
                }
            }
            catch (RuntimeException e) {
                this.log.error("showMenuDialog:" + e);
                e.printStackTrace();
                cmd = badCmd;
            }
            finally {
                isMenuShowing = false;
            }
            return cmd;
        }
    }

    static {
        leftSK = -6;
        rightSK = -7;
        rightSK2 = -7;
        backSK = -11;
        clearSK = -8;
        backspaceSK = -8;
    }
}

