/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.ui.IWaiting;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.ChannelsBar;
import com.sonyericsson.ykjc.ui.component.SearchBox2;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.YBrowser;
import com.sonyericsson.ykjc.ui.component.YForm;
import com.sonyericsson.ykjc.ui.pages.PageSearchBase;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class PageMain
extends PageSearchBase {
    private CntLog log = new CntLog("PageMain");
    private static final int COMMAND_PLAY = 1;
    private static final int COMMAND_EXIT = 2;
    private static final int COMMAND_LOGOUT = 3;
    private static final int COMMAND_MY_YOUKU = 4;
    private static final int COMMAND_HELP = 5;
    private static final int COMMAND_SELECT = 6;
    private Command play = new Command(YkUiContext.strMgr.getString("play"), 1);
    private Command select = new Command(YkUiContext.strMgr.getString("select"), 6);
    private Command exit = new Command(YkUiContext.strMgr.getString("exit"), 2);
    private Command help = new Command(YkUiContext.strMgr.getString("help"), 5);
    private Command myYouku = new Command(YkUiContext.strMgr.getString("myYouku"), 4);
    private Command logout = new Command(YkUiContext.strMgr.getString("logout"), 3);
    private VideoInfo[] recommendList;
    private Vector channelButtons = new Vector();
    private YBrowser yBrowser;
    private ChannelsBar chsBar;
    private Channel[] channels = null;

    public PageMain(int pageID) {
        super(pageID);
        YkUiContext.setMainPageShown(true);
    }

    public void doActionPerformed(ActionEvent evt) {
        super.doActionPerformed(evt);
        Command cmd = evt.getCommand();
        if (cmd != null) {
            int id = cmd.getId();
            switch (id) {
                case 1: {
                    this.playVideo(this.yBrowser.getCurVideoInfo());
                    break;
                }
                case 2: {
                    this.doExitOption();
                    break;
                }
                case 5: {
                    this.changePage(5);
                    break;
                }
                case 4: {
                    this.doActionMyYoukuOption();
                    break;
                }
                case 3: {
                    this.doActionLogoutOption();
                    break;
                }
            }
        } else if (evt.getSource() != null) {
            for (int i = 0; i < this.channelButtons.size(); ++i) {
                if (evt.getSource() != this.channelButtons.elementAt(i)) continue;
                this.doOpenChannel(this.channels[i]);
                break;
            }
        }
    }

    public void buildPageCommand() {
        this.form.removeAllCommands();
        if (this.yBrowser.hasFocus() && this.recommendList.length > 0) {
            this.form.addCommand(this.play);
        } else if (this.chsBar != null && this.chsBar.hasFocus()) {
            this.form.addCommand(this.select);
        }
        super.buildPageCommand();
        this.form.addCommand(this.exit);
        this.form.addCommand(this.help);
        this.form.addCommand(this.myYouku);
        if (YkUiContext.proxy.getLoginStatus()) {
            this.form.addCommand(this.logout);
        }
    }

    protected void buildPageContent() {
        try {
            this.recommendList = YkUiContext.proxy.getRecommendVideoList();
            this.form.setLayout(new CoordinateLayout(YkPageBase.getScreenWidth(), YkPageBase.getScreenHeight()));
            Font font2 = Font.createSystemFont(32, 1, 8);
            String[] words = YkUiContext.proxy.getHotKeywords();
            this.searchBox = new SearchBox2(new Dimension(YkPageBase.getScreenWidth(), 32), words);
            this.searchBox.setListener(this);
            Container otherComponents = new Container(new BoxLayout(2));
            this.channels = YkUiContext.proxy.listChannel();
            int barHeight = 25;
            this.chsBar = new ChannelsBar(new Dimension(YkPageBase.getScreenWidth(), barHeight), this.channels, this);
            this.chsBar.setFocusable(this.channels.length > 0);
            ((YForm)this.form).addIndependentComponents(this.chsBar);
            otherComponents.addComponent(this.chsBar);
            otherComponents.addComponent(new Seperator());
            Label rLabel = new Label(YkUiContext.strMgr.getString("SERecommend"));
            rLabel.setAlignment(4);
            otherComponents.addComponent(rLabel);
            rLabel.getStyle().setFont(font2);
            rLabel.getStyle().setFgColor(0);
            rLabel.getStyle().setMargin(0, 2, 0, 0);
            this.yBrowser = new YBrowser(this.recommendList, this);
            ((YForm)this.form).addIndependentComponents(this.yBrowser);
            otherComponents.addComponent(this.yBrowser);
            if (this.recommendList.length > 0) {
                this.form.setFocused(this.yBrowser.getReal());
            } else {
                this.form.setFocused(this.searchBox);
            }
            int searchBoxHeight = YkUiContext.uiConfig.getIntProperty("search_box_height", 40);
            this.searchBox.setY(0);
            ((YForm)this.form).addIndependentComponents(this.searchBox);
            otherComponents.setY(searchBoxHeight);
            this.form.addComponent(otherComponents);
            this.form.addComponent(this.searchBox);
        }
        catch (Exception e) {
            this.log.debug("PageMain: ", e);
        }
    }

    public boolean handleEvent(CntEvent event) {
        boolean handle = false;
        if (event == null) {
            return handle;
        }
        int type = event.getEventType();
        switch (type) {
            case 100: {
                if (this.recommendList == null) break;
                String videoId = event.getAttrString(100);
                for (int i = 0; i < this.recommendList.length; ++i) {
                    if (!this.recommendList[i].getId().equals(videoId)) continue;
                    if (this.yBrowser != null) {
                        this.yBrowser.setClip(this.recommendList[i].getImg(), i);
                    }
                    handle = true;
                }
                this.yBrowser.repaint();
                break;
            }
        }
        return handle;
    }

    public void doOpenChannel(Channel c) {
        if (c == null) {
            return;
        }
        YkUiContext.proxy.setCurrentChannel(c);
        IWaiting waiting = (IWaiting)((Object)UiContext.pageMgr.changePage(134217751));
        waiting.setExceptEvent(11);
        YkUiContext.proxy.doGetChannelVideos(c.getId(), 1);
    }

    public void refresh() {
        super.refresh();
        this.searchBox.refresh();
        if (this.yBrowser != null && this.recommendList != null && this.recommendList.length > 0) {
            this.yBrowser.refresh();
            this.form.setFocused(this.yBrowser.getReal());
        } else {
            this.form.setFocused(this.searchBox);
        }
        this.chsBar.startTimer();
        this.buildPageCommand();
    }

    public void cleanup() {
        this.searchBox.stopTimer();
        this.chsBar.stopTimer();
    }
}

