/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.io.MultipartPostArgItem;
import com.fw.j2me.io.ProgressListener;
import com.fw.j2me.ui.IPage;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.Device;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.PimUtil;
import com.fw.j2me.util.log.CntLog;
import com.fw.j2me.util.video.VideoCanvas;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.BoldLabel;
import com.sonyericsson.ykjc.ui.component.EditBox;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.YNotice;
import com.sonyericsson.ykjc.ui.pages.PageUploadProgress;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sonyericsson.ykjc.util.YkUploadFileUtil;
import com.sun.lwuit.Command;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;
import com.youku.util.MD5;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class PageUploadEdit
extends YkPageBase {
    private static CntLog log = new CntLog("PageUploadEdit");
    private static final Image BG_IMG = YkUiContext.imgMgr.getImage("uploadDialogBg");
    private static final int UPLOAD_SUCCESS = 0;
    private static final int UPLOAD_FAIL = Integer.MAX_VALUE;
    private static final int DST_W = 120;
    private static final int DST_H = 90;
    private static final int COMMAND_BACK = 1;
    private static final int COMMAND_SEND = 2;
    private String file = YkUiContext.getSendFile();
    private long size = PimUtil.getFileSize(this.file);
    private Player player;
    private VideoControl videoControl;
    private Image thumbnail;
    private Label nailLabel;
    private Label filetitleLabel;
    private EditBox filetitleValue;
    private Object progressPage;

    public PageUploadEdit(int pageID) {
        super(pageID);
    }

    public void buildPageCommand() {
        Command center = new Command(YkUiContext.strMgr.getString("send"), 2);
        Command right = new Command(YkUiContext.strMgr.getString("back"), 1);
        this.form.addCommand(right);
        this.form.addCommand(center);
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 2: {
                if (!this.checkInput(this.filetitleValue.getEditorText())) break;
                YkUiContext.setUploadingFlag(true);
                this.progressPage = UiContext.pageMgr.changePage(134217748);
                ((PageUploadProgress)this.progressPage).setThumbnail(this.thumbnail);
                new Thread(){

                    public void run() {
                        PageUploadEdit.this.doUpload(PageUploadEdit.this.progressPage);
                    }
                }.start();
                break;
            }
            case 1: {
                this.changePage(25);
                break;
            }
            case 300: {
                if (this.filetitleValue.editor != this.form.getFocused()) break;
                this.filetitleValue.editor.handleEditCmd();
                break;
            }
        }
    }

    protected void buildPageContent() {
        try {
            this.form.setTitle(" ");
            this.form.setLayout(new BoxLayout(2));
            Font labelFont = Font.createSystemFont(32, 1, 8);
            int labelColor = 26265;
            BoldLabel pageTitle = new BoldLabel(YkUiContext.strMgr.getString("uploadEditTitle"));
            this.form.addComponent(pageTitle);
            this.form.addComponent(new Seperator());
            this.drawVideoThumbnail(this.file);
            Label filenameLabel = new Label(YkUiContext.strMgr.getString("filename") + " " + MiscUtil.decodeUrl(MiscUtil.getFileNameFromUrl(this.file)));
            int space = this.form.getWidth() - BG_IMG.getWidth();
            filenameLabel.getStyle().setMargin(0, 0, space >> 1, space >> 1);
            filenameLabel.getStyle().setFgColor(0);
            this.form.addComponent(filenameLabel);
            Label filesizeLabel = new Label(YkUiContext.strMgr.getString("filesize") + " " + MiscUtil.getSizeStr(this.size));
            filesizeLabel.getStyle().setMargin(0, 0, space >> 1, space >> 1);
            filesizeLabel.getStyle().setFgColor(0);
            this.form.addComponent(filesizeLabel);
            this.filetitleLabel = new Label(YkUiContext.strMgr.getString("filetitle"));
            this.filetitleLabel.getStyle().setMargin(0, 0, space >> 1, space >> 1);
            this.filetitleLabel.getStyle().setFgColor(0);
            this.form.addComponent(this.filetitleLabel);
            this.filetitleValue = new EditBox("", 0);
            this.filetitleValue.setMaxLength(50);
            this.filetitleValue.getStyle().setMargin(0, 0, space >> 1, space >> 1);
            this.filetitleValue.setLabelFont(labelFont, labelColor);
            this.form.addComponent(this.filetitleValue);
        }
        catch (Exception e) {
            log.debug("buildPageContent ", e);
        }
    }

    public void drawVideoThumbnail(final String url) {
        this.nailLabel = new Label("");
        this.nailLabel.setIcon(YkUiContext.imgMgr.getImage("defaultClipImage"));
        new Thread(){

            public void run() {
                PageUploadEdit.this.getNail(url);
            }
        }.start();
        this.nailLabel.setAlignment(4);
        if (this.thumbnail == null) {
            log.debug("in drawbideonail is not capture");
        } else {
            log.debug("nailwidth = " + this.thumbnail.getWidth());
            log.debug("nailheight = " + this.thumbnail.getHeight());
        }
        this.form.addComponent(this.nailLabel);
    }

    public synchronized void getNail(String url) {
        try {
            IPage page;
            InputStream is = PimUtil.getInputStreamFromFile(url);
            String mime = MiscUtil.guessContentType(url);
            this.player = Manager.createPlayer((InputStream)is, (String)mime);
            this.player.realize();
            this.videoControl = (VideoControl)this.player.getControl("VideoControl");
            VolumeControl speaker = (VolumeControl)this.player.getControl("VolumeControl");
            speaker.setMute(true);
            VideoCanvas canvas = new VideoCanvas(this.videoControl);
            canvas.getHeight();
            this.player.start();
            Thread.sleep(100L);
            this.player.deallocate();
            this.captureVideo();
            if (null != this.thumbnail) {
                this.nailLabel.setIcon(this.thumbnail);
                if (null != this.progressPage) {
                    ((PageUploadProgress)this.progressPage).setThumbnail(this.thumbnail);
                }
            }
            if ((page = UiContext.pageMgr.getCurrentPage()) != null) {
                if (page instanceof PageUploadEdit) {
                    this.nailLabel.repaint();
                }
                if (page instanceof PageUploadProgress) {
                    page.show();
                }
            }
        }
        catch (Exception e) {
            log.error("getNail(" + url + ") ", e);
        }
    }

    public Image captureVideo() {
        Image image = null;
        try {
            byte[] raw = this.videoControl.getSnapshot(null);
            log.debug("raw=" + raw);
            if (MiscUtil.isEmpty(raw)) {
                String encoding = System.getProperty("video.snapshot.encodings");
                log.debug("encoding=" + encoding);
                String[] encodings = this.getEncodings(encoding);
                for (int i = 0; MiscUtil.isEmpty(raw) && i < encodings.length; ++i) {
                    raw = this.videoControl.getSnapshot(encodings[i]);
                    log.debug("encodings[" + i + "]=" + encodings[i] + " raw=" + raw);
                }
            }
            if (!MiscUtil.isEmpty(raw)) {
                image = Image.createImage(raw, 0, raw.length);
                this.thumbnail = this.createThumbnail(image);
                if (this.thumbnail == null) {
                    log.debug("nail is not capture");
                } else {
                    log.debug("incapnailwidth" + this.thumbnail.getWidth());
                    log.debug("incapnailheight" + this.thumbnail.getHeight());
                }
            }
            this.player.stop();
            this.player.close();
            this.player = null;
            this.videoControl = null;
        }
        catch (MediaException me) {
            log.debug("in captureVideo() ", me);
        }
        return this.thumbnail;
    }

    private String[] getEncodings(String encoding) {
        Object[] ret = new String[]{};
        Vector<String> v = new Vector<String>();
        if (MiscUtil.isEmpty(encoding)) {
            return ret;
        }
        int index = encoding.indexOf(32);
        while (index > 0) {
            v.addElement(encoding.substring(0, index).trim());
            encoding = encoding.substring(index + 1);
            index = encoding.indexOf(32);
        }
        v.addElement(encoding.trim());
        ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public Image createThumbnail(Image image) {
        int dstH;
        int srcW = image.getWidth();
        int dstW = 120;
        int srcH = image.getHeight();
        if (dstW * srcH != (dstH = 90) * srcW) {
            if (dstW * srcH / srcW < dstH) {
                dstH = dstW * srcH / srcW;
            } else {
                dstW = dstH * srcW / srcH;
            }
        }
        Image thumb = Image.createImage(dstW, dstH);
        Graphics g = thumb.getGraphics();
        for (int y = 0; y < dstH; ++y) {
            for (int x = 0; x < dstW; ++x) {
                g.setClip(x, y, 1, 1);
                int dx = x * srcW / dstW;
                int dy = y * srcH / dstH;
                g.drawImage(image, x - dx, y - dy);
            }
        }
        Image ret = Image.createImage(120, 90);
        g = ret.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, 120, 90);
        g.drawImage(thumb, 120 - dstW >> 1, 90 - dstH >> 1);
        g.setColor(3026219);
        g.drawRect(0, 0, 119, 89);
        g.setColor(6325915);
        g.drawRect(1, 1, 117, 87);
        g.setColor(0);
        g.drawRect(2, 2, 115, 85);
        return ret;
    }

    public void doUpload(Object progressObj) {
        log.debug("file = " + this.file);
        int ret = Integer.MAX_VALUE;
        try {
            Vector<MultipartPostArgItem> args = new Vector<MultipartPostArgItem>();
            args.addElement(new MultipartPostArgItem("partnerid", Device.getProperty("PID")));
            args.addElement(new MultipartPostArgItem("publicType", "0"));
            args.addElement(new MultipartPostArgItem("catIds", "92"));
            args.addElement(new MultipartPostArgItem("tags", YkUiContext.strMgr.getString("upload_tags")));
            args.addElement(new MultipartPostArgItem("title", this.filetitleValue.getEditorText(), "UTF-8"));
            args.addElement(new MultipartPostArgItem("username", MD5.get15bitUsername(YkUiContext.proxy.getUserInfo().getUserId())));
            args.addElement(new MultipartPostArgItem("password", YkUiContext.proxy.getUserInfo().getPassword()));
            Hashtable<String, String> binaryArgs = new Hashtable<String, String>();
            binaryArgs.put(this.file, MiscUtil.guessContentType(this.file));
            YkUploadFileUtil uploader = new YkUploadFileUtil();
            ((PageUploadProgress)progressObj).setUploader(uploader);
            ret = uploader.callMethod(args, binaryArgs, (ProgressListener)progressObj);
        }
        catch (Exception e) {
            log.debug("Could not upload. ", e);
            ret = Integer.MAX_VALUE;
        }
        if (ret != 0) {
            ((ProgressListener)this.progressPage).progressError();
        }
    }

    private boolean checkInput(String title) {
        log.debug("title = " + title);
        if (MiscUtil.isEmpty(title) || title.length() > 50 || MiscUtil.isNumeric(title)) {
            YNotice.showNotice(20);
            return false;
        }
        return true;
    }
}

