/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.CntMidlet;
import com.fw.j2me.io.ProgressListener;
import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.BoldLabel;
import com.sonyericsson.ykjc.ui.component.ProgressBar;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sonyericsson.ykjc.util.YkUploadFileUtil;
import com.sun.lwuit.Command;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Timer;
import java.util.TimerTask;

public class PageUploadProgress
extends YkPageBase
implements ProgressListener {
    private static CntLog log = new CntLog("PageUploadProgress");
    private static final Image PB_IMG = ProgressBar.PROGRESS_BG_IMG;
    private static final int COMMAND_CANCEL = 2;
    private static final int COMMAND_HIDE = 8;
    private static final int COMMAND_OK = 9;
    private Image thumbnail;
    private Label nailLabel;
    private Label fl;
    private ProgressBar pb;
    private Timer timer;
    private long cur;
    private long total;
    private boolean finished;
    private boolean success;
    private boolean dismiss;
    private boolean canceled;
    private YkUploadFileUtil uploader;

    public PageUploadProgress(int pageID) {
        super(pageID);
    }

    public void buildPageCommand() {
        if (this.finished) {
            Command right = new Command(YkUiContext.strMgr.getString("ok"), 9);
            this.form.addCommand(right);
        } else {
            Command hide = new Command(YkUiContext.strMgr.getString("hide"), 8);
            this.form.addCommand(hide);
            Command right = new Command(YkUiContext.strMgr.getString("cancel"), 2);
            this.form.addCommand(right);
        }
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 8: {
                CntMidlet.getInstance().minimize();
                break;
            }
            case 2: {
                this.canceled = true;
                this.uploader.cancel();
                this.doFinish(false);
                YkUiContext.setUploadingFlag(false);
                break;
            }
            case 9: {
                this.doChangePage();
                break;
            }
        }
    }

    protected void buildPageContent() {
        try {
            this.form.setTitle(" ");
            this.form.setLayout(new BoxLayout(2));
            BoldLabel pageTitle = new BoldLabel(YkUiContext.strMgr.getString("uploadEditTitle"));
            this.form.addComponent(pageTitle);
            this.form.addComponent(new Seperator());
            if (null == this.nailLabel) {
                this.nailLabel = new Label("");
                Image img = null == this.thumbnail ? YkUiContext.imgMgr.getImage("defaultClipImage") : this.thumbnail;
                this.nailLabel.setIcon(img);
                this.nailLabel.setAlignment(4);
            }
            this.form.addComponent(this.nailLabel);
            this.addSubTitle();
            if (this.finished) {
                this.addResult();
            } else {
                this.addAnimation();
            }
        }
        catch (Exception e) {
            log.debug("in buildPageContent()", e);
        }
    }

    private void addSubTitle() {
        Label uploadingLabel = new Label(this.finished ? " " : YkUiContext.strMgr.getString("uploadingSubTitle"));
        uploadingLabel.setAlignment(4);
        int space = this.form.getWidth() - PB_IMG.getWidth();
        uploadingLabel.getStyle().setMargin(0, 0, space >> 1, space >> 1);
        uploadingLabel.getStyle().setFgColor(0);
        this.form.addComponent(uploadingLabel);
    }

    private void addResult() {
        this.fl = new Label();
        this.fl.setPreferredSize(new Dimension(this.fl.getWidth(), 80));
        int space = this.form.getWidth() - PB_IMG.getWidth();
        this.fl.getStyle().setMargin(0, 0, space >> 1, space >> 1);
        this.fl.setText(YkUiContext.strMgr.getString(this.success ? "upload_success" : "upload_fail"));
        this.fl.setAlignment(4);
        this.form.addComponent(this.fl);
    }

    private void addAnimation() {
        this.pb = new ProgressBar();
        this.form.addComponent(this.pb);
    }

    public void setThumbnail(Image thumbnail) {
        log.debug("thumbnail = " + thumbnail);
        if (null != thumbnail) {
            this.thumbnail = thumbnail;
            if (null != this.nailLabel) {
                this.nailLabel.setIcon(thumbnail);
            }
            this.form.show();
        }
    }

    public void setUploader(YkUploadFileUtil uploader) {
        this.uploader = uploader;
    }

    private synchronized void doChangePage() {
        log.debug("in doChangePage()");
        YkUiContext.removeSendFile();
        if (!this.dismiss) {
            this.dismiss = true;
            CntMidlet.getInstance().minimize();
            log.debug("in doChangePage()  YkUiContext.isMainPageShown() = " + YkUiContext.isMainPageShown());
            if (!YkUiContext.isMainPageShown()) {
                UiContext.pageMgr.changePage(0x8000000);
                YkUiContext.proxy.doGetChannels();
                YkUiContext.proxy.doGetKeywords();
                YkUiContext.proxy.doGetRecommendVideoList();
            } else {
                UiContext.pageMgr.changePage(0x4000001);
            }
        }
    }

    private void addProgress(long bytes) {
        if (null != this.pb) {
            this.cur += bytes;
            this.pb.setValue((int)(this.cur / this.total));
        }
    }

    public void progress(long bytes) {
        this.addProgress(bytes);
    }

    public void progressError() {
        this.doFinish(false);
    }

    public void progressFinished() {
        this.doFinish(true);
    }

    public void progressStarted(long totalSize) {
        log.debug("totalSize = " + totalSize);
        this.total = totalSize / 100L;
    }

    public synchronized void doFinish(boolean successed) {
        if (this.finished && (!this.success || successed)) {
            return;
        }
        if (!this.finished) {
            this.success = successed && !this.canceled;
            this.finished = true;
            this.form.removeAll();
            this.form.removeAllCommands();
            this.buildPageCommand();
            this.buildPageContent();
            this.form.show();
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                public void run() {
                    PageUploadProgress.this.doChangePage();
                }
            }, 5000L);
        } else {
            this.fl.setText(YkUiContext.strMgr.getString(successed ? "upload_success" : "upload_fail"));
            this.fl.repaint();
        }
        YkUiContext.setUploadingFlag(false);
    }
}

