/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.protocolimpl;

import com.fw.j2me.protocolimpl.AsyncPostThread;
import com.fw.j2me.protocolimpl.CntReq;
import com.fw.j2me.protocolimpl.HttpAsyncPost;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.log.CntLog;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;

public abstract class AsyncPost {
    private static CntLog log = new CntLog("AsyncPost");
    public static final int TRY_TIMES = 1;
    public static final int TRY_DELAY = 20;
    private Object respLock = new Object();
    private boolean finished = false;
    protected CntReq req;
    protected Connection conn = null;
    protected OutputStream os = null;
    protected InputStream is = null;

    protected AsyncPost(CntReq req) {
        this.req = req;
    }

    public static AsyncPost newInstance(CntReq req) {
        log.debug("newInstance req.request:" + req.toString());
        return new HttpAsyncPost(req);
    }

    public final void doJob() {
        for (int i = 0; i <= 1; ++i) {
            this.req.setErrCode(0);
            if (this.postNetworkRequest()) break;
            log.error("Try " + i + " times, response is null, retry after 1 seconds");
            MiscUtil.sleep(20L);
        }
        this.notifyWaiter();
    }

    protected void processResp(CntReq req) {
    }

    protected void closeConnection() {
        MiscUtil.close(this.is);
        MiscUtil.close(this.os);
        MiscUtil.close(this.conn);
    }

    public void execute() {
        AsyncPostThread.excute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResult() {
        log.debug("waitForResult");
        try {
            Object object = this.respLock;
            synchronized (object) {
                if (this.finished) {
                    return;
                }
                this.respLock.wait(this.req.getTimeout());
            }
        }
        catch (Exception e) {
            log.error("waitForResult failed", e);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiter() {
        log.debug("NotifyWaiter");
        Object object = this.respLock;
        synchronized (object) {
            this.finished = true;
            this.respLock.notifyAll();
        }
    }

    protected abstract boolean postNetworkRequest();
}

