/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.protocolimpl;

import com.fw.j2me.util.Deserializable;

public abstract class CntReq {
    public static final int FLAG_RETRY = 1;
    public static final int REQUEST_PRIORITY_HIGH = 0;
    public static final int REQUEST_PRIORITY_MIDIUM = 0x40000000;
    public static final int REQUEST_PRIORITY_LOW = Integer.MIN_VALUE;
    public static final int POST = 0x20000000;
    public static final long TIMEOUT = 50000L;
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int ERR_CONN_TIMEOUT = 7;
    private int reqType = -1;
    private String request = null;
    private int reqId = CntReq.assignReqId();
    private int flag;
    private Deserializable replayReader;
    private Object response;
    private long timeout = 50000L;
    private String errMsg;
    private int errCode = 1;
    private static int lastReqId = 0;

    public CntReq(int type) {
        this.reqType = type;
    }

    public CntReq(int type, String request) {
        this(type);
        this.request = request;
    }

    private static synchronized int assignReqId() {
        return ++lastReqId;
    }

    public int getReqType() {
        return this.reqType;
    }

    public String getRequest() {
        return this.request;
    }

    public int getReqId() {
        return this.reqId;
    }

    public void setErrCode(int code) {
        this.errCode = code;
    }

    public Object getResponse() {
        return this.response;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String message) {
        this.errMsg = message;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public boolean isSucceed() {
        return this.errCode == 0;
    }

    public Deserializable getReplayReader() {
        return this.replayReader;
    }

    public void setReplayReader(Deserializable reader) {
        this.replayReader = reader;
    }

    public boolean testFlag(int flag) {
        return (this.flag & flag) == flag;
    }

    public void setFlag(int flag) {
        this.flag |= flag;
    }

    public void removeFlag(int flag) {
        this.flag &= ~flag;
    }
}

