/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.protocolimpl;

import com.fw.j2me.protocolimpl.AsyncPost;
import com.fw.j2me.protocolimpl.AsyncPostThread;
import com.fw.j2me.protocolimpl.CntReq;
import com.fw.j2me.protocolimpl.RespHandler;
import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.SyncQueue;
import com.fw.j2me.util.log.CntLog;

public class ReqSender
extends CntThread {
    private static CntLog log = new CntLog("ReqSender");
    private RespHandler handler;
    private SyncQueue queue = new SyncQueue(2);
    private boolean pause;
    private Object pauseObject = new Object();

    public ReqSender() {
        super("ISender-");
    }

    public int getQueueSize() {
        return this.queue.getSize();
    }

    public void clearQueue() {
        this.queue.clearQueue();
    }

    public void flushRequests() {
        log.debug("flushRequests");
        this.queue.doNotifyAll();
    }

    public void queueRequest(CntReq req) {
        int priority = req.getReqType() >>> 30;
        this.queue.put2Tail(req, priority);
    }

    private void processRequest(CntReq req) {
        this.postNetworkRequest(req);
        this.handler.queueNetworkData(req);
        System.gc();
    }

    private void postNetworkRequest(CntReq req) {
        log.debug("AsyncSender.postNetworkRequest()");
        AsyncPost post = AsyncPost.newInstance(req);
        post.execute();
        post.waitForResult();
        if (!post.isFinished()) {
            log.debug("Timeout!");
            AsyncPostThread.fail();
            req.setErrCode(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runMe() {
        while (!this.stop) {
            log.debug("processing next chunk of requests, queue.size()=" + this.getQueueSize());
            CntReq req = (CntReq)this.queue.get(this);
            if (this.stop) break;
            Object object = this.pauseObject;
            synchronized (object) {
                try {
                    if (this.pause) {
                        this.pauseObject.wait();
                    }
                }
                catch (InterruptedException e) {
                    log.debug("pauseObject got interrupted");
                }
            }
            this.processRequest(req);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.debug("runMe()" + e);
            }
        }
        log.debug("AsyncSender going to die");
    }

    protected void closeMe() {
        log.debug("closing sender, notifying");
        this.clearQueue();
        this.queue.doNotifyAll();
    }

    public void stop() {
        this.handler.close();
        this.close();
    }

    public void setHandler(RespHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        log.debug("pause handler");
        Object object = this.pauseObject;
        synchronized (object) {
            this.pause = true;
            this.handler.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        log.debug("resume handler");
        Object object = this.pauseObject;
        synchronized (object) {
            this.pause = false;
            this.pauseObject.notify();
            this.handler.resume();
        }
    }
}

