/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.uiimpl;

import com.fw.j2me.util.log.CntLog;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Property {
    private static CntLog log = new CntLog("Property");
    private Hashtable propertiesHt = new Hashtable();

    public Property(String configFile) {
        this.loadPropertiesText(configFile);
    }

    public int getIntProperty(String pName, int defVal) {
        try {
            return Integer.parseInt(this.getAppProperty(pName));
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public long getLongProperty(String pName, long defVal) {
        try {
            return Long.parseLong(this.getAppProperty(pName));
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public boolean getBoolProperty(String propertyName, boolean defVal) {
        try {
            String strProperty = this.getAppProperty(propertyName);
            if (strProperty == null) {
                return defVal;
            }
            return strProperty.equals("T");
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public String getAppProperty(String key) {
        String property = null;
        if (property == null) {
            property = (String)this.propertiesHt.get(key);
        }
        return property;
    }

    private void loadPropertiesText(String configFile) {
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            InputStream is = this.getClass().getResourceAsStream(configFile);
            InputStreamReader isr = new InputStreamReader(is, "utf-8");
            while ((c = isr.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        String properties = sb.toString();
        int begIndex = 0;
        int endIndex = properties.indexOf("\n") + 1;
        int sepIndex = 0;
        while (endIndex > begIndex) {
            String paramValue = properties.substring(begIndex, endIndex);
            boolean isComment = paramValue.startsWith("//") || paramValue.startsWith("#");
            sepIndex = paramValue.indexOf("=");
            if (!isComment && sepIndex > 0) {
                String param = paramValue.substring(0, sepIndex).trim();
                String value = paramValue.substring(sepIndex + 1).trim();
                this.propertiesHt.put(param, value);
            }
            begIndex = endIndex;
            endIndex = properties.indexOf("\n", begIndex + 1) + 1;
        }
        log.debug("propertiesHt ====> " + this.propertiesHt.size());
    }
}

