/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.IoUtil;
import com.fw.j2me.util.log.CntLog;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ResUtil {
    private static CntLog log = new CntLog("ResUtil");

    private ResUtil() {
    }

    public static Image getImageFromJar(String fn) throws Exception {
        return Image.createImage((String)fn);
    }

    public static Image effectResizeImage(Image src, int destW, int destH) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = ResUtil.getPixels(src);
        for (int destY = 0; destY < destH; ++destY) {
            for (int destX = 0; destX < destW; ++destX) {
                int srcX = destX * srcW / destW;
                int srcY = destY * srcH / destH;
                destPixels[destX + destY * destW] = srcPixels[srcX + srcY * srcW];
            }
        }
        return ResUtil.drawPixels(destPixels, destW, destH);
    }

    private static int[] getPixels(Image src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] pixels = new int[w * h];
        src.getRGB(pixels, 0, w, 0, 0, w, h);
        return pixels;
    }

    private static Image drawPixels(int[] pixels, int w, int h) {
        Image image = Image.createRGBImage((int[])pixels, (int)w, (int)h, (boolean)true);
        pixels = null;
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getProperties(MIDlet midlet, String fileUrl) throws Exception {
        log.debug("ResUtil.getProperties: fileUrl=" + fileUrl);
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = midlet.getClass().getResourceAsStream(fileUrl);
            isr = new InputStreamReader(is, "UTF-8");
            Hashtable hashtable = ResUtil.parseProperties(isr);
            return hashtable;
        }
        finally {
            if (isr != null) {
                isr.close();
                isr = null;
            }
            if (is != null) {
                is = null;
            }
        }
    }

    public static Hashtable parseProperties(InputStreamReader isr) throws Exception {
        log.debug("ResUtil.parseProperties()");
        Hashtable<String, String> res = new Hashtable<String, String>();
        int ch = isr.read();
        while (ch != -1) {
            if (ch == 35) {
                IoUtil.readTill(isr, '\n', true, ch);
            } else {
                String k = IoUtil.readTill(isr, '=', true, ch);
                String v = IoUtil.readTill(isr, '\n', false, -1);
                if (v != null) {
                    res.put(k.trim(), v.trim());
                }
            }
            ch = isr.read();
        }
        return res;
    }

    public static byte[] getByteArray(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int argb = raw[i];
            int a = (argb & 0xFF000000) >> 24;
            int r = (argb & 0xFF0000) >> 16;
            int g = (argb & 0xFF00) >> 8;
            int b = argb & 0xFF;
            rawByte[n] = (byte)b;
            rawByte[n + 1] = (byte)g;
            rawByte[n + 2] = (byte)r;
            rawByte[n + 3] = (byte)a;
            n += 4;
        }
        raw = null;
        return rawByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(MIDlet midlet, String fileUrl) throws Exception {
        log.debug("ResUtil.getString: fileUrl=" + fileUrl);
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = midlet.getClass().getResourceAsStream(fileUrl);
            isr = new InputStreamReader(is, "UTF-8");
            StringBuffer sb = new StringBuffer();
            int b = 0;
            while ((b = isr.read()) > -1) {
                sb.append((char)b);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (isr != null) {
                isr.close();
                isr = null;
            }
            if (is != null) {
                is = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(MIDlet midlet, String fileUrl) throws Exception {
        log.debug("ResUtil.getBytes: fileUrl=" + fileUrl);
        InputStream is = null;
        try {
            is = midlet.getClass().getResourceAsStream(fileUrl);
            byte[] byArray = IoUtil.readInputStream(is);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

