/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.CntThread;
import com.fw.j2me.util.log.CntLog;
import java.util.Vector;

public class SyncQueue {
    private static CntLog log = new CntLog("util.SyncQueue");
    private Vector[] queue;
    private int waitObjNum;
    private int levels;

    public SyncQueue() {
        this.levels = 1;
        this.queue = new Vector[this.levels];
        this.queue[0] = new Vector();
    }

    public SyncQueue(int levels) {
        this.levels = levels;
        this.queue = new Vector[levels];
        for (int i = 0; i < levels; ++i) {
            this.queue[i] = new Vector();
        }
    }

    public synchronized Object get(CntThread callingThread) {
        while (this.waitObjNum < 1) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                log.debug("SyncQueue.get() got interrupted");
                return null;
            }
            if (null == callingThread || !callingThread.isStop()) continue;
            return null;
        }
        for (int i = 0; i < this.levels; ++i) {
            if (this.queue[i].size() <= 0) continue;
            Object obj = this.queue[i].firstElement();
            this.queue[i].removeElementAt(0);
            --this.waitObjNum;
            this.notifyAll();
            return obj;
        }
        return null;
    }

    public synchronized void put(Object obj) {
        this.queue[this.levels - 1].addElement(obj);
        ++this.waitObjNum;
        this.notifyAll();
    }

    public synchronized void put(Object obj, boolean addToFront, boolean notify) {
        if (addToFront) {
            this.queue[0].insertElementAt(obj, 0);
        } else {
            this.queue[this.levels - 1].addElement(obj);
        }
        ++this.waitObjNum;
        if (notify) {
            this.notifyAll();
        }
    }

    public synchronized void put2Tail(Object obj, int level) {
        if (level >= this.levels) {
            level = this.levels - 1;
        }
        if (level < 0) {
            level = 0;
        }
        this.queue[level].addElement(obj);
        ++this.waitObjNum;
        this.notifyAll();
    }

    public synchronized void put2Head(Object obj, int level) {
        if (level >= this.levels) {
            level = this.levels - 1;
        }
        if (level < 0) {
            level = 0;
        }
        this.queue[level].insertElementAt(obj, 0);
        ++this.waitObjNum;
        this.notifyAll();
    }

    public synchronized void clearQueue() {
        for (int i = 0; i < this.levels; ++i) {
            this.queue[i].removeAllElements();
        }
        this.waitObjNum = 0;
        this.notifyAll();
    }

    public synchronized void clearQueue(int level) {
        if (level < this.levels && level >= 0) {
            this.waitObjNum -= this.queue[level].size();
            this.queue[level].removeAllElements();
            this.notifyAll();
        }
    }

    public synchronized void doNotifyAll() {
        this.notifyAll();
    }

    public synchronized int getSize() {
        return this.waitObjNum;
    }

    protected synchronized Vector[] getQueue() {
        return this.queue;
    }

    protected synchronized int getLevels() {
        return this.levels;
    }

    protected synchronized void reduceSize() {
        --this.waitObjNum;
    }
}

