/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util.log;

import com.fw.j2me.util.log.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public class BluetoothLogger
extends Logger
implements DiscoveryListener {
    protected static final String BLUETOOTH_ID = "0x1101";
    private String pairingId = "";
    protected static final String BT_PROTOCOL = "btspp";
    private Thread idleThread;
    private LocalDevice localDevice;
    private RemoteDevice remoteDevice;
    private Vector messageQueue = new Vector();
    private String remoteServiceUrl;
    private boolean stopSending = false;
    private boolean consoleFound = false;
    OutputStream out = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothLogger(String pairingId, int level) {
        super(level);
        this.pairingId = pairingId;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
            this.start();
        }
        catch (BluetoothStateException e) {
            throw new Error("Bluetooth logger: failed to initialize");
        }
        BluetoothLogger bluetoothLogger = this;
        synchronized (bluetoothLogger) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("BluetoothLogger end of constructor");
        this.idleThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        BluetoothLogger.this.preLog(" Logger IDLE");
                        try {
                            this.wait(120000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        };
        this.idleThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (this.consoleFound) {
            return;
        }
        String deviceName = null;
        try {
            deviceName = remoteDevice.getFriendlyName(false);
            System.out.println("deviceName = " + deviceName);
        }
        catch (IOException ex) {
            BluetoothLogger bluetoothLogger = this;
            synchronized (bluetoothLogger) {
                this.notify();
            }
        }
        if (deviceName != null && deviceName.equals(this.pairingId)) {
            this.remoteDevice = remoteDevice;
            this.consoleFound = true;
            this.localDevice.getDiscoveryAgent().cancelInquiry((DiscoveryListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servicesDiscovered(int i, ServiceRecord[] serviceRecords) {
        boolean hasBtSPP = false;
        for (int j = 0; j < serviceRecords.length; ++j) {
            String conURL = serviceRecords[j].getConnectionURL(0, false);
            if (!conURL.startsWith(BT_PROTOCOL)) continue;
            hasBtSPP = true;
            this.remoteServiceUrl = conURL;
            BluetoothLogger bluetoothLogger = this;
            synchronized (bluetoothLogger) {
                this.notify();
                continue;
            }
        }
        if (!hasBtSPP) {
            BluetoothLogger bluetoothLogger = this;
            synchronized (bluetoothLogger) {
                this.notify();
            }
        }
    }

    public void serviceSearchCompleted(int i, int i0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int i) {
        System.out.println("inquiry completed");
        if (this.remoteDevice != null) {
            UUID[] filter = new UUID[]{new UUID(4353L)};
            try {
                this.localDevice.getDiscoveryAgent().searchServices(null, filter, this.remoteDevice, (DiscoveryListener)this);
            }
            catch (BluetoothStateException e) {
                BluetoothLogger bluetoothLogger = this;
                synchronized (bluetoothLogger) {
                    this.notify();
                }
            }
        } else {
            System.out.println("not find device");
            BluetoothLogger bluetoothLogger = this;
            synchronized (bluetoothLogger) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean messagesRemaining = false;
        while (!this.stopSending) {
            boolean bl = messagesRemaining = this.messageQueue.size() > 0;
            while (messagesRemaining) {
                String message = null;
                Vector vector = this.messageQueue;
                synchronized (vector) {
                    if (this.messageQueue.size() > 0) {
                        message = (String)this.messageQueue.firstElement();
                    }
                }
                if (message != null) {
                    if (this.remoteServiceUrl == null) continue;
                    try {
                        if (this.out == null) {
                            this.out = Connector.openOutputStream((String)this.remoteServiceUrl);
                        }
                        this.out.write(message.getBytes());
                        this.messageQueue.removeElement(message);
                        continue;
                    }
                    catch (IOException e) {
                        if (this.out == null) continue;
                        try {
                            this.out.close();
                        }
                        catch (Exception ex) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    finally {
                        if (this.out == null) continue;
                        try {
                            this.out.flush();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        continue;
                    }
                }
                if (message == null) continue;
                this.messageQueue.removeElement(message);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(String message) {
        if (this.remoteServiceUrl != null) {
            this.messageQueue.addElement(message);
        }
        BluetoothLogger bluetoothLogger = this;
        synchronized (bluetoothLogger) {
            this.notifyAll();
        }
    }

    public void release() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Logger.logger = null;
    }
}

