/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.engine;

import com.fw.j2me.protocol.ISessionListener;
import com.fw.j2me.protocolimpl.CntReq;
import com.fw.j2me.protocolimpl.SyncEvent;
import com.fw.j2me.ui.UiCallback;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.engine.EngineBase;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.DataChannelVideos;
import com.sonyericsson.ykjc.model.DataMyYouKu;
import com.sonyericsson.ykjc.model.SearchResult;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.protocol.DoRegisterReq;
import com.sonyericsson.ykjc.protocol.GetChannelThumbnailReq;
import com.sonyericsson.ykjc.protocol.GetVideoThumbnailReq;
import com.sonyericsson.ykjc.protocol.SeCommentVideoReq;
import com.sonyericsson.ykjc.protocol.SeLoginReq;
import com.sonyericsson.ykjc.proxy.YkEvent;
import java.util.Vector;

public class Engine
extends EngineBase
implements ISessionListener {
    private static CntLog log = new CntLog("Engine");

    public Engine(UiCallback cb) {
        super(cb);
        this.session.setListener(this);
    }

    public void doneJob(CntReq req) {
        log.debug("doneJob(): req: " + req.getReqType() + "; Success: " + req.isSucceed());
        if (req.testFlag(1)) {
            log.debug("retry: req " + req.getRequest());
            this.session.doJob(req);
            return;
        }
        CntEvent event = null;
        switch (req.getReqType()) {
            case 100: {
                event = this.doneGetSeRecommendVideo(req);
                break;
            }
            case 111: {
                event = this.doneSearchVideoList(req);
                break;
            }
            case 1073741945: {
                event = this.doneCommentVideo(req);
                break;
            }
            case 0x40000066: {
                event = this.doneLoadVideoThumbnail(req);
                break;
            }
            case 131: {
                event = this.doneLogin(req);
                break;
            }
            case 101: {
                event = this.doneRelateVideoList(req);
                break;
            }
            case 103: {
                event = this.doneGetChannels(req);
                break;
            }
            case 141: {
                event = this.doneGetChannelVideos(req);
                break;
            }
            case 151: {
                event = this.doneDoRegister(req);
                break;
            }
            case 161: {
                event = this.doneGetMyYouKu(req);
                break;
            }
            case 171: {
                event = this.doneGetKeywords(req);
                break;
            }
            case 181: {
                event = this.doneForgetPwd(req);
                break;
            }
            case 1073741928: {
                event = this.doneLoadChannelThumbnail(req);
                break;
            }
            default: {
                event = null;
            }
        }
        if (event != null) {
            event.setAttr(0, new Integer(req.getReqId()));
            this.callBack.handleEvent(event);
        }
    }

    private CntEvent doneGetChannels(CntReq req) {
        if (req.isSucceed()) {
            this.model.setChannels((Vector)req.getResponse());
            return new YkEvent(10);
        }
        return new YkEvent(-2147483638);
    }

    private CntEvent doneRelateVideoList(CntReq req) {
        if (req.isSucceed()) {
            this.model.setRelativeList((Vector)req.getResponse());
            this.loadVideoThumbnail(req.getResponse());
            return new YkEvent(9);
        }
        return new YkEvent(-2147483639);
    }

    private CntEvent doneGetSeRecommendVideo(CntReq req) {
        if (req.isSucceed()) {
            this.model.setRecommendList((Vector)req.getResponse());
            this.loadVideoThumbnail(req.getResponse());
            return new YkEvent(5);
        }
        return new YkEvent(-2147483643);
    }

    private CntEvent doneSearchVideoList(CntReq req) {
        if (req.isSucceed()) {
            this.model.setSearchResult((SearchResult)req.getResponse());
            this.loadVideoThumbnail(((SearchResult)req.getResponse()).getResult());
            return new YkEvent(6);
        }
        return new YkEvent(-2147483642);
    }

    private CntEvent doneCommentVideo(CntReq req) {
        if (req.isSucceed()) {
            SeCommentVideoReq comReq = (SeCommentVideoReq)req;
            if (((String)req.getResponse()).equals("0")) {
                VideoInfo videoInfo = comReq.getVideoInfo();
                if (comReq.isUp()) {
                    videoInfo.setUp(videoInfo.getUp() + 1);
                } else {
                    videoInfo.setDown(videoInfo.getDown() + 1);
                }
            }
            return new YkEvent(8);
        }
        return new YkEvent(-2147483640);
    }

    private CntEvent doneLogin(CntReq req) {
        if (req.isSucceed()) {
            SeLoginReq loginReq = (SeLoginReq)req;
            if (((String)req.getResponse()).equals("0")) {
                this.model.getUserInfo().setUserId(loginReq.getEMail());
                this.model.getUserInfo().setPassword(loginReq.getPwd());
                this.model.resetLoginFailCount();
            } else {
                this.model.increaseLoginFailCount();
            }
            return YkEvent.getLogin((String)req.getResponse(), loginReq.getEMail());
        }
        return new YkEvent(-2147483633);
    }

    private CntEvent doneDoRegister(CntReq req) {
        if (req.isSucceed()) {
            this.model.setRegisterResult((String)req.getResponse());
            DoRegisterReq rReq = (DoRegisterReq)req;
            return YkEvent.getRegister((String)req.getResponse(), rReq.getEMail(), rReq.getPwd());
        }
        return new YkEvent(-2147483636);
    }

    private CntEvent doneLoadVideoThumbnail(CntReq req) {
        if (req.isSucceed()) {
            VideoInfo info = ((GetVideoThumbnailReq)req).getInfo();
            return YkEvent.getVideoThumbnail(info.getId());
        }
        return null;
    }

    private CntEvent doneGetChannelVideos(CntReq req) {
        if (req.isSucceed()) {
            this.model.setChannelVideos((DataChannelVideos)req.getResponse());
            this.loadVideoThumbnail(((DataChannelVideos)req.getResponse()).getResult());
            return new YkEvent(11);
        }
        return new YkEvent(-2147483637);
    }

    private CntEvent doneGetMyYouKu(CntReq req) {
        if (req.isSucceed()) {
            this.model.setMyYouKu((DataMyYouKu)req.getResponse());
            this.loadVideoThumbnail(((DataMyYouKu)req.getResponse()).getResult());
            return new YkEvent(13);
        }
        return new YkEvent(-2147483635);
    }

    private CntEvent doneGetKeywords(CntReq req) {
        if (req.isSucceed()) {
            Vector keywordsVec = (Vector)req.getResponse();
            Object[] keywords = new String[keywordsVec.size()];
            keywordsVec.copyInto(keywords);
            this.model.setHotKeywords((String[])keywords);
            return new YkEvent(7);
        }
        return new YkEvent(-2147483641);
    }

    private CntEvent doneForgetPwd(CntReq req) {
        if (req.isSucceed()) {
            return YkEvent.getForgetPwd(Integer.parseInt((String)req.getResponse()));
        }
        return new YkEvent(-2147483634);
    }

    private CntEvent doneLoadChannelThumbnail(CntReq req) {
        if (req.isSucceed()) {
            Channel channle = ((GetChannelThumbnailReq)req).getChannel();
            return YkEvent.getChannelThumbnail(channle.getId());
        }
        return null;
    }

    public void syncInform(SyncEvent syncEvent) {
        this.callBack.syncInform(syncEvent);
    }
}

