/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Button;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.Style;
import java.util.Hashtable;

public class ChannelContainer
extends Container {
    protected Channel[] channels;
    protected Button[] buttons;
    protected Image defaultUnFocusImg = YkUiContext.imgMgr.getImage("Command1");
    protected Image defaultFocusImg = YkUiContext.imgMgr.getImage("Command2");

    public void build(Channel[] channels, ActionListener listener, Hashtable channelHash) {
        this.channels = channels;
        this.buttons = new Button[channels.length];
        this.createButtons(listener, channelHash);
        this.setFocusable(false);
    }

    protected void createButtons(ActionListener listener, Hashtable channelHash) {
        for (int i = 0; i < this.channels.length; ++i) {
            Image icon = this.channels[i].getIcon1();
            if (icon == null) {
                icon = this.defaultUnFocusImg;
            }
            this.buttons[i] = new Button(this.channels[i].getName(), icon){

                public Image getPressedIcon() {
                    Image i = this.getIcon();
                    return i.scaled((int)((double)i.getWidth() * 0.8), (int)((double)i.getHeight() * 0.8));
                }
            };
            icon = this.channels[i].getIcon2();
            if (icon == null) {
                icon = this.defaultFocusImg;
            }
            this.buttons[i].setRolloverIcon(icon);
            Style s = this.buttons[i].getStyle();
            s.setBorder(null);
            s.setBgTransparency(0);
            s.setBgSelectionColor(0xFFFFFF);
            this.buttons[i].setAlignment(4);
            this.buttons[i].setTextPosition(2);
            this.addComponent(this.buttons[i]);
            if (i == 0) {
                this.buttons[i].setFocus(true);
            }
            this.buttons[i].addActionListener(listener);
            channelHash.put(this.buttons[i], this.channels[i]);
        }
        this.setLayout(new GridLayout(3, 3));
    }

    public boolean updateImage(String channelId) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (!this.channels[i].getId().equals(channelId)) continue;
            if (this.channels[i].getIcon1() != null) {
                this.buttons[i].setIcon(this.channels[i].getIcon1());
            }
            if (this.channels[i].getIcon2() != null) {
                this.buttons[i].setRolloverIcon(this.channels[i].getIcon2());
            }
            this.buttons[i].repaint();
            return true;
        }
        return false;
    }
}

