/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.ui.component.YkTabbedPane;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;

public class YkTabbedTitle
extends Container {
    private static final int MAX_SHOW = 3;
    private String[] titles;
    private int index;
    private YkTabbedPane parent;
    private int firstShow = 0;
    private int maxShow = 3;
    private int[] xs;
    public static final Font FONT = Font.createSystemFont(32, 0, 8);

    public YkTabbedTitle(String[] titles, YkTabbedPane parent) {
        this(null, titles, parent);
    }

    public YkTabbedTitle(Dimension d, String[] titles, YkTabbedPane parent) {
        if (null != d) {
            this.setPreferredSize(new Dimension(d.getWidth(), FONT.getHeight() + 10));
        }
        this.titles = titles;
        this.parent = parent;
        this.maxShow = Math.min(titles.length, 3);
        this.xs = new int[this.maxShow + 1];
        this.xs[0] = -1;
        for (int i = 1; i < this.xs.length; ++i) {
            this.xs[i] = (this.getPreferredW() + 1) * i / this.maxShow - 1;
        }
    }

    public void keyPressed(int keyCode) {
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 2) {
            --this.index;
            int n = this.index = this.index < 0 ? 0 : this.index;
            if (this.firstShow > this.index) {
                this.firstShow = this.index;
            }
            this.parent.setSelectedIndex(this.index);
        } else if (gameAction == 5) {
            ++this.index;
            int n = this.index = this.index >= this.titles.length ? this.titles.length - 1 : this.index;
            if (this.firstShow + this.maxShow <= this.index) {
                this.firstShow = this.index - this.maxShow + 1;
            }
            this.parent.setSelectedIndex(this.index);
        }
    }

    public void paint(Graphics g) {
        this.paintTabTitleBg(g);
        this.paintFrame(g);
        this.paintText(g);
    }

    private void paintText(Graphics g) {
        for (int i = 0; i < this.maxShow; ++i) {
            g.setColor(0);
            g.drawString(this.titles[this.firstShow + i], this.xs[i] + this.xs[i + 1] - FONT.stringWidth(this.titles[this.firstShow + i]) >> 1, this.getY() + (this.getHeight() - FONT.getHeight() >> 1));
        }
    }

    private void paintTabTitleBg(Graphics g) {
        for (int i = 0; i < this.maxShow; ++i) {
            g.setColor(this.firstShow + i == this.index ? 0xEFEFEF : 0xD3D3D3);
            g.fillRect(this.xs[i] + 1, this.getY() + 1, this.xs[i + 1] - this.xs[i] - 1, this.getHeight() - 1);
        }
    }

    private void paintFrame(Graphics g) {
        g.setColor(0);
        g.drawLine(0, this.getY(), this.getPreferredW(), this.getY());
        for (int i = 0; i < this.xs.length; ++i) {
            g.setColor(0);
            g.drawLine(this.xs[i], this.getY(), this.xs[i], this.getPreferredH() - 1);
            if (this.xs.length - 1 == i) continue;
            g.setColor(0xFFFFFF);
            g.drawLine(this.xs[i] + 1, this.getY() + 1, this.xs[i] + 1, this.getPreferredH() - 2);
            g.drawLine(this.xs[i] + 1, this.getY() + 1, this.xs[i + 1] - 1, this.getY() + 1);
        }
        int y = this.getY() + this.getPreferredH() - 1;
        if (this.firstShow != this.index) {
            g.drawLine(0, y, this.xs[this.index - this.firstShow], y);
        }
        if (this.firstShow + this.maxShow - 1 != this.index) {
            g.drawLine(this.xs[this.index - this.firstShow + 1], y, this.getWidth(), y);
        }
    }
}

