/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.CntEvent;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.SearchResult;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.AutoFixLabel;
import com.sonyericsson.ykjc.ui.component.ChannelsBar;
import com.sonyericsson.ykjc.ui.component.NavigationSimpleBar;
import com.sonyericsson.ykjc.ui.component.SearchBox2;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.YBrowser;
import com.sonyericsson.ykjc.ui.component.YForm;
import com.sonyericsson.ykjc.ui.pages.PageSearchBase;
import com.sonyericsson.ykjc.ui.pages.RelatedWordsButton;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class PageSearch
extends PageSearchBase
implements FocusListener {
    private static final int PLAY_COMMAND = 1;
    private static final int LOGOUT_COMMAND = 2;
    private static final int MYYOUKU_COMMAND = 3;
    private static final int HELP_COMMAND = 4;
    private static final int SELECT_COMMAND = 5;
    private static final int PAGE_NAV_COMMAND = 6;
    private Command cmdPlay = new Command(YkUiContext.strMgr.getString("play"), 1);
    private Command cmdHelp = new Command(YkUiContext.strMgr.getString("help"), 4);
    private Command cmdmyyk = new Command(YkUiContext.strMgr.getString("myYouku"), 3);
    private Command cmdlogout = new Command(YkUiContext.strMgr.getString("logout"), 2);
    private Command cmdSelect = new Command(YkUiContext.strMgr.getString("select"), 5);
    private CntLog log = new CntLog("PageSearch");
    private VideoInfo[] videos;
    private SearchResult result;
    private String curKey = "";
    private YBrowser yBrowser;
    private ChannelsBar chsBar;
    private Component initFocusedComponent = null;
    private NavigationSimpleBar pageNavig;

    public PageSearch(int pageID) {
        super(pageID);
    }

    public void doActionPerformed(ActionEvent evt) {
        super.doActionPerformed(evt);
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 0: {
                UiContext.pageMgr.changePage(0x10000000);
                break;
            }
            case 1: {
                this.playVideo(this.yBrowser.getCurVideoInfo());
                break;
            }
            case 4: {
                this.changePage(5);
                break;
            }
            case 3: {
                this.doActionMyYoukuOption();
                break;
            }
            case 2: {
                this.doActionLogoutOption();
                break;
            }
            case 6: {
                this.pageNavig.actionPerformed(evt);
                break;
            }
        }
    }

    protected void initFocus() {
        if (this.initFocusedComponent != null) {
            this.form.setFocused(this.initFocusedComponent);
        }
    }

    public void buildPageCommand() {
        this.form.removeAllCommands();
        if (this.yBrowser != null && this.yBrowser.hasFocus()) {
            this.form.addCommand(this.cmdPlay);
        } else if (null != this.chsBar && this.chsBar.hasFocus()) {
            this.form.addCommand(this.cmdSelect);
        } else if (null != this.pageNavig && this.pageNavig.hasFocus()) {
            Command cmdPageNav = new Command(this.pageNavig.getIndicateString(), 6);
            this.form.addCommand(cmdPageNav);
        }
        super.buildPageCommand();
        this.form.addCommand(this.cmdBack);
        this.form.addCommand(this.cmdHelp);
        this.form.addCommand(this.cmdmyyk);
        if (YkUiContext.proxy.getLoginStatus()) {
            this.form.addCommand(this.cmdlogout);
        }
    }

    protected void buildPageContent() {
        try {
            this.form.setLayout(new CoordinateLayout(YkPageBase.getScreenWidth(), YkPageBase.getScreenHeight()));
            this.result = YkUiContext.proxy.getSearchResult();
            if (null != this.result) {
                this.curKey = this.result.getKeyword();
            }
            String[] words = YkUiContext.proxy.getHotKeywords();
            this.searchBox = new SearchBox2(new Dimension(YkPageBase.getScreenWidth(), 0), words);
            this.searchBox.setListener(this);
            if (null == this.result) {
                return;
            }
            Container otherComponents = new Container(new BoxLayout(2));
            Channel[] channels = YkUiContext.proxy.listChannel();
            int barHeight = 25;
            this.chsBar = new ChannelsBar(new Dimension(YkPageBase.getScreenWidth(), barHeight), channels, this);
            this.chsBar.setFocusable(channels.length > 0);
            ((YForm)this.form).addIndependentComponents(this.chsBar);
            otherComponents.addComponent(this.chsBar);
            otherComponents.addComponent(new Seperator());
            Vector videoList = this.result.getResult();
            String[] relateWords = this.result.getRelateWords();
            if (null == videoList || 0 == videoList.size()) {
                if (relateWords == null || relateWords.length == 0) {
                    this.addSearchAdvices(otherComponents);
                } else {
                    this.addRelateWords(otherComponents);
                }
            } else {
                this.addPageNumBar(otherComponents);
                this.videos = new VideoInfo[videoList.size()];
                videoList.copyInto(this.videos);
                this.addResultList(otherComponents);
                this.pageNavig.setFocusDown(this.yBrowser.getReal());
                this.pageNavig.setFocusUp(this.chsBar);
            }
            int searchBoxHeight = YkUiContext.uiConfig.getIntProperty("search_box_height", 40);
            this.searchBox.setY(0);
            ((YForm)this.form).addIndependentComponents(this.searchBox);
            otherComponents.setY(searchBoxHeight);
            this.form.addComponent(otherComponents);
            this.form.addComponent(this.searchBox);
        }
        catch (Exception e) {
            this.log.error("buildPageContent(): ", e);
        }
    }

    private void addPageNumBar(Container c) {
        this.pageNavig = new NavigationSimpleBar(this.form.getWidth(), this.result.getAllResult(), this.result.getCurPage(), this.result.getAllPage()){

            protected void getPage(int page) {
                PageSearch.this.doSearch(PageSearch.this.curKey, page);
            }
        };
        this.pageNavig.setFocusListener(this);
        c.addComponent(this.pageNavig);
    }

    private void addResultList(Container c) {
        this.yBrowser = new YBrowser(this.videos, this);
        ((YForm)this.form).addIndependentComponents(this.yBrowser);
        c.addComponent(this.yBrowser);
        this.form.setFocused(this.yBrowser.getReal());
    }

    private void addRelateWords(Container c) {
        String[] words = this.result.getRelateWords();
        String s0 = YkUiContext.strMgr.getString("findNoneClip");
        String s1 = YkUiContext.strMgr.getString("relateWordsTitle");
        c.addComponent(new Label(s0 + s1));
        Image icon = YkUiContext.imgMgr.getImage("triangle2");
        for (int i = 0; i < words.length; ++i) {
            final RelatedWordsButton b = new RelatedWordsButton(" " + words[i], icon);
            b.setCellRenderer(false);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    PageSearch.this.doSearch(b.getText(), 1);
                }
            });
            c.addComponent(b);
            if (i == 0) {
                this.initFocusedComponent = b;
                continue;
            }
            if (i != words.length - 1) continue;
            b.setNextFocusDown(b);
            b.setNextFocusRight(b);
        }
    }

    public boolean handleEvent(CntEvent event) {
        boolean handle = false;
        if (event != null && this.videos != null && event.getEventType() == 100) {
            String videoId = event.getAttrString(100);
            for (int i = 0; i < this.videos.length; ++i) {
                VideoInfo vInfo = this.videos[i];
                if (!vInfo.getId().equals(videoId)) continue;
                if (this.yBrowser != null) {
                    this.yBrowser.setClip(vInfo.getImg(), i);
                }
                handle = true;
            }
            this.yBrowser.repaint();
        }
        return handle;
    }

    public void refresh() {
        super.refresh();
        if (this.yBrowser != null && this.videos != null && this.videos.length > 0) {
            this.yBrowser.refresh();
            this.form.setFocused(this.yBrowser.getReal());
        }
        this.searchBox.refresh();
        this.chsBar.startTimer();
        this.buildPageCommand();
    }

    protected void addSearchAdvices(Container c) {
        String s0 = YkUiContext.strMgr.getString("findNoneClip");
        String s1 = YkUiContext.strMgr.getString("searchAdviceTitle");
        c.addComponent(new Label(s0));
        c.addComponent(new Label(s1));
        Image icon = YkUiContext.imgMgr.getImage("triangle2");
        AutoFixLabel advice1 = new AutoFixLabel(YkUiContext.strMgr.getString("searchAdvice1"), YkPageBase.getScreenWidth(), icon);
        AutoFixLabel advice2 = new AutoFixLabel(YkUiContext.strMgr.getString("searchAdvice2"), YkPageBase.getScreenWidth(), icon);
        AutoFixLabel advice3 = new AutoFixLabel(YkUiContext.strMgr.getString("searchAdvice3"), YkPageBase.getScreenWidth(), icon);
        c.addComponent(advice1);
        c.addComponent(advice2);
        c.addComponent(advice3);
    }

    public void cleanup() {
        this.searchBox.stopTimer();
        this.chsBar.stopTimer();
    }

    public void focusGained(Component cmp) {
        this.buildPageCommand();
    }

    public void focusLost(Component cmp) {
        this.buildPageCommand();
    }
}

