/*
 * Decompiled with CFR 0.152.
 */
package com.rogers.j2me.stub;

import com.rogers.j2me.stub.Globals;
import com.rogers.j2me.stub.MainScreen;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LanguageScreen
extends Canvas {
    private static final int HINS = 12;
    private static final int VINS = 4;
    private static final int VGAP = 8;
    private Image _image = null;
    private int _ar = -1;
    private int _sel;
    private int[] _buttonPos = new int[8];

    public LanguageScreen() {
        this.setFullScreenMode(true);
        this._sel = Globals._language != null && Globals._language.equals("fr") ? 1 : 0;
    }

    protected void keyPressed(int keyCode) {
        int ga = this.getGameAction(keyCode);
        if (ga == 1 || ga == 2 || keyCode == 50 || keyCode == 52) {
            --this._sel;
            if (this._sel < 0) {
                this._sel = 1;
            }
            this.repaint();
        } else if (ga == 6 || ga == 5 || keyCode == 56 || keyCode == 54) {
            ++this._sel;
            if (this._sel > 1) {
                this._sel = 0;
            }
            this.repaint();
        } else if (ga == 8 || keyCode == 53) {
            this.gotoMainScreen();
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.insideButton(0, x, y)) {
            this._sel = 0;
            this.repaint();
        } else if (this.insideButton(1, x, y)) {
            this._sel = 1;
            this.repaint();
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.insideButton(0, x, y) && this._sel == 0) {
            this.gotoMainScreen();
        } else if (this.insideButton(1, x, y) && this._sel == 1) {
            this.gotoMainScreen();
        }
    }

    protected boolean insideButton(int but, int x, int y) {
        return this._buttonPos[but * 2] <= x && x < this._buttonPos[but * 2] + this._buttonPos[4] && this._buttonPos[but * 2 + 1] <= y && y < this._buttonPos[but * 2 + 1] + this._buttonPos[5];
    }

    private void gotoMainScreen() {
        Globals._language = this._sel == 0 ? "en" : "fr";
        Globals._display.setCurrent((Displayable)new MainScreen());
    }

    protected void sizeChanged(int w, int h) {
        this.repaint();
    }

    protected void paint(Graphics g) {
        g.setColor(Globals.BACK_COLOUR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.checkOrientation(g);
        if (this._image != null) {
            g.drawImage(this._image, this.getWidth() >> 1, this.getHeight() >> 1, 3);
        }
        this.drawChoice(g, this._buttonPos[0], this._buttonPos[1], this._buttonPos[4], this._buttonPos[5], "app.option.en", this._buttonPos[6], 0);
        this.drawChoice(g, this._buttonPos[2], this._buttonPos[3], this._buttonPos[4], this._buttonPos[5], "app.option.fr", this._buttonPos[7], 1);
    }

    private void drawChoice(Graphics g, int bx, int by, int bw, int bh, String id, int sw, int ch) {
        if (this._sel == ch) {
            g.setColor(Globals.LANG_SEL_BG_COLOUR);
            g.fillRect(bx, by, bw, bh);
            g.setColor(Globals.LANG_SEL_FG_COLOUR);
        } else {
            g.setColor(Globals.LANG_FG_COLOUR);
        }
        g.drawString((String)Globals._p.get(id), bx + (bw - sw >> 1), by + 4, 20);
        g.setColor(Globals.LANG_BORDER_COLOUR);
        g.drawRect(bx, by, bw, bh);
    }

    private void checkOrientation(Graphics g) {
        if (this.getWidth() > this.getHeight() && this._ar != 2) {
            this._image = this.loadImage("app.image.lang.wide");
            this.calcButtonPos(g, "wide");
            this._ar = 2;
        } else if (this.getWidth() <= this.getHeight() && this._ar != 1) {
            this._image = this.loadImage("app.image.lang.tall");
            this.calcButtonPos(g, "tall");
            this._ar = 1;
        }
    }

    private Image loadImage(String id) {
        try {
            return Image.createImage((String)("/" + Globals._p.get(id)));
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void calcButtonPos(Graphics g, String orient) {
        Font f = g.getFont();
        int w1 = f.stringWidth((String)Globals._p.get("app.option.en"));
        int w2 = f.stringWidth((String)Globals._p.get("app.option.fr"));
        int bw = Math.max(w1, w2) + 24;
        int bh = f.getHeight() + 8;
        int iw = this.getWidth();
        int ih = this.getHeight();
        int ix = 0;
        int iy = 0;
        String buttonMode = (String)Globals._p.get("app.buttons.lang.mode");
        if (this._image != null && buttonMode.endsWith("Bitmap")) {
            iw = this._image.getWidth();
            ih = this._image.getHeight();
            ix = this.getWidth() - iw >> 1;
            iy = this.getHeight() - ih >> 1;
        }
        if (buttonMode.startsWith("auto")) {
            int bx = ix + (iw - bw >> 1);
            int by = iy + (ih - ((bh << 1) + 8) >> 1);
            this._buttonPos[0] = bx;
            this._buttonPos[1] = by;
            this._buttonPos[2] = bx;
            this._buttonPos[3] = by + bh + 8;
        } else {
            this._buttonPos[0] = ix + Integer.parseInt((String)Globals._p.get("app.buttons.lang." + orient + ".x1"));
            this._buttonPos[1] = iy + Integer.parseInt((String)Globals._p.get("app.buttons.lang." + orient + ".y1"));
            this._buttonPos[2] = ix + Integer.parseInt((String)Globals._p.get("app.buttons.lang." + orient + ".x2"));
            this._buttonPos[3] = iy + Integer.parseInt((String)Globals._p.get("app.buttons.lang." + orient + ".y2"));
        }
        this._buttonPos[4] = bw;
        this._buttonPos[5] = bh;
        this._buttonPos[6] = w1;
        this._buttonPos[7] = w2;
    }
}

