/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.twitter.Parser;
import com.sonyericsson.twitter.Tweet;
import com.sonyericsson.twitter.XMLParser;
import java.util.Vector;

public class StatusParser
implements Parser {
    private XMLParser parser = null;
    private Vector pV;
    private int read = 0;
    private boolean isCancelled = false;

    public StatusParser() {
        if (this.parser == null) {
            this.parser = new XMLParser();
        }
    }

    public Vector parse(String xml) {
        this.parser.setXML(xml);
        Tweet t = null;
        Vector<Tweet> v = new Vector<Tweet>(20);
        int index = 0;
        while (-1 != (index = this.parser.getNext(index, "status"))) {
            t = null;
            System.gc();
            t = new Tweet();
            t.messageId = this.parser.getValue(index, "id");
            t.screenname = this.parser.getValue(index, "screen_name");
            t.username = this.parser.getValue(index, "name");
            t.text = this.parser.getValue(index, "text");
            t.avatar = this.parser.getValue(index, "profile_image_url");
            t.createdAt = this.parser.getValue(index, "created_at");
            t.location = this.parser.getValue(index, "location");
            t.favorited = this.parser.getValue(index, "favorited").equals("true");
            v.addElement(t);
        }
        this.parser.setXML(null);
        return v;
    }

    public void cancel() {
        this.isCancelled = true;
        this.pV = null;
        this.parser.setXML(null);
    }

    public String getType() {
        return "<?xml";
    }

    public void startParse() {
        this.isCancelled = false;
        this.pV = null;
        this.pV = new Vector(20);
        this.read = -1;
    }

    public int parsePartial(String xml) {
        this.parser.setXML(xml);
        Tweet t = null;
        int index = 0;
        try {
            this.read = -1;
            while (-1 != (index = this.parser.getNext(index, "status"))) {
                int lc = this.parser.getEnd(index, "status");
                if (-1 == lc) {
                    this.parser.setXML(null);
                    return this.pV.size();
                }
                this.read = lc;
                t = null;
                System.gc();
                t = new Tweet();
                t.messageId = this.parser.getValue(index, "id");
                t.screenname = this.parser.getValue(index, "screen_name");
                t.location = this.parser.getValue(index, "location");
                t.username = this.parser.getValue(index, "name");
                t.text = this.parser.getValue(index, "text");
                t.avatar = this.parser.getValue(index, "profile_image_url");
                t.createdAt = this.parser.getValue(index, "created_at");
                t.favorited = this.parser.getValue(index, "favorited").equals("true");
                this.pV.addElement(t);
            }
        }
        catch (NullPointerException ne) {
            return -1;
        }
        this.parser.setXML(null);
        return this.pV.size();
    }

    public Vector finishParse() {
        Vector t = this.pV;
        this.pV = null;
        if (t == null) {
            return new Vector();
        }
        return t;
    }

    public int getRead() {
        return this.read;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

